/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ChannelHealthProbe {
    private ChannelHealthProbe() {
    }

    static void connect(Publisher<?> pub, final Subscriber<? super Object> sub, final AtomicBoolean live, final AtomicBoolean ready) {
        pub.subscribe((Subscriber)new Subscriber<Object>(){

            public void onSubscribe(final Subscription s) {
                sub.onSubscribe(new Subscription(){

                    public void request(long n) {
                        s.request(n);
                    }

                    public void cancel() {
                        live.set(false);
                        s.cancel();
                    }
                });
                ready.set(true);
            }

            public void onNext(Object o) {
                sub.onNext(o);
            }

            public void onError(Throwable t) {
                live.set(false);
                sub.onError(t);
            }

            public void onComplete() {
                sub.onComplete();
            }
        });
    }
}

