/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.messaging;

import io.helidon.common.Errors;
import io.helidon.config.Config;
import io.helidon.microprofile.messaging.ChannelRouter;
import io.helidon.microprofile.messaging.MethodSignatureResolver;
import io.helidon.microprofile.messaging.MethodSignatureType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;

abstract class AbstractMessagingMethod {
    private String incomingChannelName;
    private String outgoingChannelName;
    private Bean<?> bean;
    private Object beanInstance;
    private MethodSignatureType type;
    private final Method method;
    private final Errors.Collector errors;
    private Acknowledgment.Strategy ackStrategy;

    AbstractMessagingMethod(Method method, Errors.Collector errors) {
        this.method = method;
        this.errors = errors;
        Optional<MethodSignatureType> signatureType = MethodSignatureResolver.create(method).resolve();
        if (signatureType.isPresent()) {
            this.type = signatureType.get();
            this.resolveAckStrategy();
        } else {
            errors.fatal("Unsupported method signature " + method);
        }
    }

    void validate() {
        if (this.type == null) {
            return;
        }
        Optional.ofNullable(this.method.getAnnotation(Acknowledgment.class)).map(Acknowledgment::value).filter(s -> !this.type.getSupportedAckStrategies().contains(s)).ifPresent(strategy -> this.errors.fatal(String.format("Acknowledgment strategy %s is not supported for method signature: %s", new Object[]{strategy, this.type})));
    }

    void init(BeanManager beanManager, Config config) {
        this.beanInstance = ChannelRouter.lookup(this.bean, beanManager);
    }

    Method getMethod() {
        return this.method;
    }

    Errors.Collector errors() {
        return this.errors;
    }

    Object getBeanInstance() {
        return this.beanInstance;
    }

    void setDeclaringBean(Bean<?> bean) {
        this.bean = bean;
    }

    Class<?> getDeclaringType() {
        return this.method.getDeclaringClass();
    }

    String getIncomingChannelName() {
        return this.incomingChannelName;
    }

    String getOutgoingChannelName() {
        return this.outgoingChannelName;
    }

    void setIncomingChannelName(String incomingChannelName) {
        this.incomingChannelName = incomingChannelName;
    }

    void setOutgoingChannelName(String outgoingChannelName) {
        this.outgoingChannelName = outgoingChannelName;
    }

    MethodSignatureType getType() {
        return this.type;
    }

    void setType(MethodSignatureType type) {
        this.type = type;
    }

    Acknowledgment.Strategy getAckStrategy() {
        return this.ackStrategy;
    }

    <T> T invoke(Object ... args) {
        try {
            return (T)this.getMethod().invoke(this.getBeanInstance(), args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private void resolveAckStrategy() {
        this.ackStrategy = Optional.ofNullable(this.method.getAnnotation(Acknowledgment.class)).map(Acknowledgment::value).orElse(this.type.getDefaultAckType());
    }
}

