/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.context.Contexts;
import io.helidon.common.uri.UriPath;
import io.helidon.jersey.common.InvokedResource;
import io.helidon.microprofile.security.FeatureConfig;
import io.helidon.microprofile.security.JerseySecurityContext;
import io.helidon.microprofile.security.SecurityDefinition;
import io.helidon.microprofile.security.SecurityFilterCommon;
import io.helidon.microprofile.security.SecurityFilterContext;
import io.helidon.security.AuditEvent;
import io.helidon.security.Security;
import io.helidon.security.SecurityLevel;
import io.helidon.security.annotations.Audited;
import io.helidon.security.annotations.Authenticated;
import io.helidon.security.annotations.Authorized;
import io.helidon.security.integration.common.ResponseTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.providers.common.spi.AnnotationAnalyzer;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.AbstractResourceModelVisitor;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.RuntimeResource;

@Priority(value=1000)
@ConstrainedTo(value=RuntimeType.SERVER)
public class SecurityFilter
extends SecurityFilterCommon
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final System.Logger LOGGER = System.getLogger(SecurityFilter.class.getName());
    private final Map<Class<?>, CacheEntry> applicationClassCache = new HashMap();
    private final ReentrantLock applicationClassCacheLock = new ReentrantLock();
    private final ReentrantLock resourceClassSecurityLock = new ReentrantLock();
    private final ReentrantLock resourceMethodSecurityLock = new ReentrantLock();
    private final ReentrantLock subResourceMethodSecurityLock = new ReentrantLock();
    private final io.helidon.security.SecurityContext securityContext;
    private final List<AnnotationAnalyzer> analyzers = new LinkedList<AnnotationAnalyzer>();

    public SecurityFilter(@Context Security security, @Context FeatureConfig featureConfig, @Context io.helidon.security.SecurityContext securityContext) {
        super(security, featureConfig);
        this.securityContext = securityContext;
        this.loadAnalyzers();
    }

    SecurityFilter(FeatureConfig featureConfig, Security security, io.helidon.security.SecurityContext securityContext) {
        super(security, featureConfig);
        this.securityContext = securityContext;
        this.loadAnalyzers();
    }

    private void loadAnalyzers() {
        HelidonServiceLoader.builder(ServiceLoader.load(AnnotationAnalyzer.class)).build().forEach(this.analyzers::add);
    }

    @PostConstruct
    public void postConstruct() {
        Config analyzersConfig = this.config("jersey.analyzers");
        this.analyzers.forEach(analyzer -> analyzer.init(analyzersConfig));
    }

    public void filter(ContainerRequestContext request) {
        if (this.featureConfig().shouldUsePrematchingAuthentication() && this.featureConfig().shouldUsePrematchingAuthorization()) {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Security handled by pre-matching filter, ignoring.");
            }
            return;
        }
        this.doFilter(request, this.securityContext);
    }

    @Override
    protected void processSecurity(ContainerRequestContext request, SecurityFilterContext filterContext, SecurityTracing tracing, io.helidon.security.SecurityContext securityContext) {
        if (!this.featureConfig().shouldUsePrematchingAuthentication()) {
            this.authenticate(filterContext, securityContext, tracing.atnTracing());
            LOGGER.log(System.Logger.Level.TRACE, () -> "Filter after authentication. Should finish: " + filterContext.shouldFinish());
            if (filterContext.shouldFinish()) {
                return;
            }
            filterContext.clearTrace();
        }
        if (!this.featureConfig().shouldUsePrematchingAuthorization()) {
            this.authorize(filterContext, securityContext, tracing.atzTracing());
            LOGGER.log(System.Logger.Level.TRACE, () -> "Filter completed (after authorization)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        SecurityContext jSecurityContext = requestContext.getSecurityContext();
        if (null == jSecurityContext) {
            return;
        }
        if (!(jSecurityContext instanceof JerseySecurityContext)) {
            return;
        }
        JerseySecurityContext jerseySecurityContext = (JerseySecurityContext)jSecurityContext;
        io.helidon.common.context.Context helidonContext = (io.helidon.common.context.Context)Contexts.context().orElseThrow(() -> new IllegalStateException("Context must be available in Jersey"));
        helidonContext.get((Object)"security.responseHeaders", Map.class).map(it -> it).ifPresent(it -> {
            MultivaluedMap headers = responseContext.getHeaders();
            for (Map.Entry entry : it.entrySet()) {
                ((List)entry.getValue()).forEach(value -> headers.add((Object)((String)entry.getKey()), value));
            }
        });
        SecurityFilterContext fc = (SecurityFilterContext)requestContext.getProperty("io.helidon.security.jersey.FilterContext");
        SecurityDefinition methodSecurity = jerseySecurityContext.methodSecurity();
        io.helidon.security.SecurityContext securityContext = jerseySecurityContext.securityContext();
        if (fc.explicitAtz() && !securityContext.isAuthorized()) {
            switch (responseContext.getStatusInfo().getFamily()) {
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    break;
                }
                default: {
                    if (this.featureConfig().isDebug()) {
                        responseContext.setEntity((Object)"Authorization was marked as explicit, yet it was never called in resource method");
                    } else {
                        responseContext.setEntity((Object)"");
                    }
                    responseContext.setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    LOGGER.log(System.Logger.Level.ERROR, "Authorization failure. Request for" + fc.resourcePath() + " has failed, as it was markedas explicitly authorized, yet authorization was never called on security context. The method was invoked and may have changed data. Marking as internal server error");
                    fc.shouldFinish(true);
                }
            }
        }
        ResponseTracing responseTracing = SecurityTracing.get().responseTracing();
        try {
            if (methodSecurity.audited()) {
                AuditEvent.AuditSeverity auditSeverity = responseContext.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL ? methodSecurity.auditOkSeverity() : methodSecurity.auditErrorSeverity();
                SecurityAuditEvent auditEvent = SecurityAuditEvent.audit((AuditEvent.AuditSeverity)auditSeverity, (String)methodSecurity.auditEventType(), (String)methodSecurity.auditMessageFormat()).addParam(AuditEvent.AuditParam.plain((String)"method", (Object)fc.method())).addParam(AuditEvent.AuditParam.plain((String)"path", (Object)fc.resourcePath())).addParam(AuditEvent.AuditParam.plain((String)"status", (Object)String.valueOf(responseContext.getStatus()))).addParam(AuditEvent.AuditParam.plain((String)"subject", (Object)securityContext.user().or(() -> ((io.helidon.security.SecurityContext)securityContext).service()).orElse(io.helidon.security.SecurityContext.ANONYMOUS))).addParam(AuditEvent.AuditParam.plain((String)"transport", (Object)"http")).addParam(AuditEvent.AuditParam.plain((String)"resourceType", (Object)fc.resourceName())).addParam(AuditEvent.AuditParam.plain((String)"targetUri", (Object)fc.targetUri()));
                securityContext.audit((AuditEvent)auditEvent);
            }
        }
        finally {
            responseTracing.finish();
        }
    }

    @Override
    protected SecurityFilterContext initRequestFiltering(ContainerRequestContext requestContext) {
        SecurityFilterContext context = new SecurityFilterContext();
        InvokedResource invokedResource = InvokedResource.create((ContainerRequestContext)requestContext);
        return invokedResource.definitionMethod().map(definitionMethod -> {
            context.methodSecurity(this.getMethodSecurity(invokedResource, (Method)definitionMethod, (ExtendedUriInfo)requestContext.getUriInfo(), requestContext));
            context.resourceName(definitionMethod.getDeclaringClass().getSimpleName());
            return this.configureContext(context, requestContext, requestContext.getUriInfo());
        }).orElseGet(() -> {
            context.shouldFinish(true);
            return context;
        });
    }

    @Override
    protected System.Logger logger() {
        return LOGGER;
    }

    private SecurityDefinition securityForClass(Class<?> theClass, SecurityDefinition parent) {
        Class<?> realClass = SecurityFilter.getRealClass(theClass);
        Authenticated atn = realClass.getAnnotation(Authenticated.class);
        Authorized atz = realClass.getAnnotation(Authorized.class);
        Audited audited = realClass.getAnnotation(Audited.class);
        SecurityDefinition definition = null == parent ? new SecurityDefinition(this.featureConfig().shouldAuthorizeAnnotatedOnly(), this.featureConfig().failOnFailureIfOptional()) : parent.copyMe();
        definition.add(atn);
        definition.add(atz);
        definition.add(audited);
        if (!this.featureConfig().shouldAuthenticateAnnotatedOnly()) {
            definition.requiresAuthentication(true);
        }
        HashMap<Class<? extends Annotation>, List<Annotation>> customAnnotsMap = new HashMap<Class<? extends Annotation>, List<Annotation>>();
        this.addCustomAnnotations(customAnnotsMap, realClass);
        SecurityLevel securityLevel = SecurityLevel.create((String)realClass.getName()).withClassAnnotations(customAnnotsMap).build();
        definition.securityLevels().add(securityLevel);
        for (AnnotationAnalyzer analyzer : this.analyzers) {
            AnnotationAnalyzer.AnalyzerResponse analyzerResponse = null == parent ? analyzer.analyze(realClass) : analyzer.analyze(realClass, parent.analyzerResponse(analyzer));
            definition.analyzerResponse(analyzer, analyzerResponse);
        }
        if (this.logger().isLoggable(System.Logger.Level.TRACE)) {
            this.logger().log(System.Logger.Level.TRACE, "Security definition for resource {0}: {1}", theClass.getName(), definition);
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityDefinition getMethodSecurity(InvokedResource invokedResource, Method definitionMethod, ExtendedUriInfo uriInfo, ContainerRequestContext requestContext) {
        Class obtainedClass = (Class)invokedResource.definitionClass().orElseThrow(() -> new SecurityException("Got definition method, cannot get definition class"));
        Class<?> definitionClass = SecurityFilter.getRealClass(obtainedClass);
        Application appInstance = (Application)Contexts.context().flatMap(it -> it.get(Application.class)).orElseThrow(() -> new IllegalStateException("Context not available"));
        Class<?> appRealClass = SecurityFilter.getRealClass(appInstance.getClass());
        SecurityDefinition appClassSecurity = this.appClassSecurity(appRealClass);
        if (definitionClass.getAnnotation(Path.class) == null) {
            PathVisitor visitor = new PathVisitor();
            visitor.visit(uriInfo.getMatchedRuntimeResources());
            Collections.reverse(visitor.list);
            StringBuilder fullPathBuilder = new StringBuilder();
            LinkedList<Method> methodsToProcess = new LinkedList<Method>();
            for (Object m : visitor.list) {
                Method parentDefMethod = m.getDefinitionMethod();
                Class<?> parentClass = parentDefMethod.getDeclaringClass();
                fullPathBuilder.append("/").append(parentClass.getName()).append(".").append(parentDefMethod.getName());
                methodsToProcess.add(parentDefMethod);
            }
            fullPathBuilder.append("/").append(definitionClass.getName()).append(".").append(definitionMethod.getName());
            methodsToProcess.add(definitionMethod);
            String fullPath = fullPathBuilder.toString();
            try {
                this.subResourceMethodSecurityLock.lock();
                if (this.subResourceMethodSecurity(appRealClass).containsKey(fullPath)) {
                    Object m;
                    m = this.subResourceMethodSecurity(appRealClass).get(fullPath);
                    return m;
                }
            }
            finally {
                this.subResourceMethodSecurityLock.unlock();
            }
            SecurityDefinition current = appClassSecurity;
            for (Method method : methodsToProcess) {
                Class<?> clazz = method.getDeclaringClass();
                current = this.securityForClass(clazz, current);
                SecurityDefinition methodDef = this.processMethod(current.copyMe(), uriInfo.getPath(), requestContext.getMethod(), method);
                SecurityLevel currentSecurityLevel = methodDef.securityLevels().get(methodDef.securityLevels().size() - 1);
                HashMap<Class<? extends Annotation>, List<Annotation>> methodAnnotations = new HashMap<Class<? extends Annotation>, List<Annotation>>();
                this.addCustomAnnotations(methodAnnotations, method);
                SecurityLevel newSecurityLevel = SecurityLevel.create((SecurityLevel)currentSecurityLevel).withMethodName(method.getName()).withMethodAnnotations(methodAnnotations).build();
                methodDef.securityLevels().set(methodDef.securityLevels().size() - 1, newSecurityLevel);
                for (AnnotationAnalyzer analyzer : this.analyzers) {
                    AnnotationAnalyzer.AnalyzerResponse analyzerResponse = analyzer.analyze(method, current.analyzerResponse(analyzer));
                    methodDef.analyzerResponse(analyzer, analyzerResponse);
                }
                current = methodDef;
            }
            try {
                this.subResourceMethodSecurityLock.lock();
                this.subResourceMethodSecurity(appRealClass).put(fullPath, current);
            }
            finally {
                this.subResourceMethodSecurityLock.unlock();
            }
            return current;
        }
        try {
            this.resourceMethodSecurityLock.lock();
            if (this.resourceMethodSecurity(appRealClass).containsKey(definitionMethod)) {
                SecurityDefinition visitor = this.resourceMethodSecurity(appRealClass).get(definitionMethod);
                return visitor;
            }
        }
        finally {
            this.resourceMethodSecurityLock.unlock();
        }
        SecurityDefinition resClassSecurity = this.obtainClassSecurityDefinition(appRealClass, appClassSecurity, definitionClass);
        SecurityDefinition methodDef = this.processMethod(resClassSecurity, uriInfo.getRequestUri().getPath(), requestContext.getMethod(), definitionMethod);
        int index = methodDef.securityLevels().size() - 1;
        SecurityLevel currentSecurityLevel = methodDef.securityLevels().get(index);
        HashMap<Class<? extends Annotation>, List<Annotation>> methodLevelAnnotations = new HashMap<Class<? extends Annotation>, List<Annotation>>();
        this.addCustomAnnotations(methodLevelAnnotations, definitionMethod);
        methodDef.securityLevels().set(index, SecurityLevel.create((SecurityLevel)currentSecurityLevel).withMethodName(definitionMethod.getName()).withMethodAnnotations(methodLevelAnnotations).build());
        try {
            this.resourceMethodSecurityLock.lock();
            this.resourceMethodSecurity(appRealClass).put(definitionMethod, methodDef);
        }
        finally {
            this.resourceMethodSecurityLock.unlock();
        }
        for (AnnotationAnalyzer analyzer : this.analyzers) {
            AnnotationAnalyzer.AnalyzerResponse analyzerResponse = analyzer.analyze(definitionMethod, resClassSecurity.analyzerResponse(analyzer));
            methodDef.analyzerResponse(analyzer, analyzerResponse);
        }
        return methodDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityDefinition obtainClassSecurityDefinition(Class<?> appRealClass, SecurityDefinition appClassSecurity, Class<?> definitionClass) {
        Map<Class<?>, SecurityDefinition> classSecurityDefinitionMap = this.resourceClassSecurity(appRealClass);
        try {
            this.resourceClassSecurityLock.lock();
            SecurityDefinition securityDefinition = classSecurityDefinitionMap.computeIfAbsent(definitionClass, aClass -> this.securityForClass(definitionClass, appClassSecurity));
            return securityDefinition;
        }
        finally {
            this.resourceClassSecurityLock.unlock();
        }
    }

    private void addCustomAnnotations(Map<Class<? extends Annotation>, List<Annotation>> customAnnotsMap, Class<?> theClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = theClass.getAnnotations()) {
            this.addToMap(annotation.annotationType(), customAnnotsMap, annotation);
        }
    }

    private void addToMap(Class<? extends Annotation> annotClass, Map<Class<? extends Annotation>, List<Annotation>> customAnnotsMap, Annotation ... annot) {
        customAnnotsMap.computeIfAbsent(annotClass, key -> new LinkedList()).addAll(Arrays.asList(annot));
    }

    private void addCustomAnnotations(Map<Class<? extends Annotation>, List<Annotation>> customAnnotsMap, Method theMethod) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = theMethod.getAnnotations()) {
            this.addToMap(annotation.annotationType(), customAnnotsMap, annotation);
        }
    }

    List<AnnotationAnalyzer> analyzers() {
        return this.analyzers;
    }

    private SecurityDefinition processMethod(SecurityDefinition current, String path, String httpMethod, Method method) {
        SecurityDefinition methodDef = current.copyMe();
        this.findMethodConfig(UriPath.create((String)path), httpMethod).asNode().ifPresentOrElse(methodDef::fromConfig, () -> {
            Authenticated atn = method.getAnnotation(Authenticated.class);
            Authorized atz = method.getAnnotation(Authorized.class);
            Audited audited = method.getAnnotation(Audited.class);
            methodDef.add(atn);
            methodDef.add(atz);
            methodDef.add(audited);
        });
        return methodDef;
    }

    private CacheEntry appClassCacheEntry(Class<?> appClass) {
        try {
            this.applicationClassCacheLock.lock();
            CacheEntry cacheEntry = this.applicationClassCache.computeIfAbsent(appClass, c -> {
                SecurityDefinition appClassSecurity = this.securityForClass((Class<?>)c, null);
                CacheEntry entry = new CacheEntry();
                entry.appClassSecurity = appClassSecurity;
                return entry;
            });
            return cacheEntry;
        }
        finally {
            this.applicationClassCacheLock.unlock();
        }
    }

    private SecurityDefinition appClassSecurity(Class<?> appClass) {
        return this.appClassCacheEntry(appClass).appClassSecurity;
    }

    private Map<Class<?>, SecurityDefinition> resourceClassSecurity(Class<?> appClass) {
        return this.appClassCacheEntry(appClass).resourceClassSecurity;
    }

    private Map<Method, SecurityDefinition> resourceMethodSecurity(Class<?> appClass) {
        return this.appClassCacheEntry(appClass).resourceMethodSecurity;
    }

    private Map<String, SecurityDefinition> subResourceMethodSecurity(Class<?> appClass) {
        return this.appClassCacheEntry(appClass).subResourceMethodSecurity;
    }

    private static final class PathVisitor
    extends AbstractResourceModelVisitor {
        private final List<Invocable> list = new LinkedList<Invocable>();

        private PathVisitor() {
        }

        public void visitResource(Resource resource) {
            if (resource.getResourceLocator() != null) {
                resource.getResourceLocator().accept((ResourceModelVisitor)this);
            }
        }

        public void visitChildResource(Resource resource) {
            this.visitResource(resource);
        }

        public void visitResourceMethod(ResourceMethod method) {
            this.list.add(method.getInvocable());
        }

        public void visitRuntimeResource(RuntimeResource runtimeResource) {
            for (Resource resource : runtimeResource.getResources()) {
                resource.accept((ResourceModelVisitor)this);
            }
        }

        public void visit(List<RuntimeResource> runtimeResources) {
            for (RuntimeResource runtimeResource : runtimeResources) {
                runtimeResource.accept((ResourceModelVisitor)this);
            }
        }
    }

    private static class CacheEntry {
        private SecurityDefinition appClassSecurity;
        private final Map<Class<?>, SecurityDefinition> resourceClassSecurity = new HashMap();
        private final Map<Method, SecurityDefinition> resourceMethodSecurity = new HashMap<Method, SecurityDefinition>();
        private final Map<String, SecurityDefinition> subResourceMethodSecurity = new HashMap<String, SecurityDefinition>();

        private CacheEntry() {
        }
    }
}

