/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.microprofile.cdi.RuntimeStart;
import io.helidon.microprofile.security.JerseySecurityFeature;
import io.helidon.microprofile.security.SecurityDisabledFeature;
import io.helidon.microprofile.security.SecurityProducer;
import io.helidon.microprofile.server.JaxRsCdiExtension;
import io.helidon.microprofile.server.ServerCdiExtension;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Security;
import io.helidon.security.providers.abac.AbacProvider;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.AuthorizationProvider;
import io.helidon.webserver.security.SecurityFeature;
import io.helidon.webserver.security.SecurityFeatureConfig;
import io.helidon.webserver.spi.ServerFeature;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class SecurityCdiExtension
implements Extension {
    private static final System.Logger LOGGER = System.getLogger(SecurityCdiExtension.class.getName());
    private final AtomicReference<Security> security = new AtomicReference();
    private Security.Builder securityBuilder = Security.builder();
    private Config config;
    private SecurityFeatureConfig.Builder securityFeatureBuilder = SecurityFeature.builder();

    public Security.Builder securityBuilder() {
        if (null == this.securityBuilder) {
            throw new IllegalStateException("Security is already built, you cannot update the builder");
        }
        return this.securityBuilder;
    }

    public Optional<Security> security() {
        return Optional.ofNullable(this.security.get());
    }

    private void registerBean(@Observes BeforeBeanDiscovery abd) {
        abd.addAnnotatedType(SecurityProducer.class, "helidon-security-producer").add((Annotation)ApplicationScoped.Literal.INSTANCE);
    }

    private void configure(@Observes @RuntimeStart @Priority(value=2) Config config) {
        this.config = config;
        this.securityBuilder.config((io.helidon.common.config.Config)config.get("security"));
        this.securityFeatureBuilder.config(config.get("server.features.security"));
    }

    private void registerSecurity(@Observes @Priority(value=1000) @Initialized(value=ApplicationScoped.class) Object adv, BeanManager bm) {
        if (this.securityBuilder.noProvider(AuthenticationProvider.class)) {
            LOGGER.log(System.Logger.Level.INFO, "Authentication provider is missing from security configuration, but security extension for microprofile is enabled (requires providers configuration at key security.providers). Security will not have any valid authentication provider");
            this.securityBuilder.addAuthenticationProvider(this::failingAtnProvider);
        }
        if (this.securityBuilder.noProvider(AuthorizationProvider.class)) {
            LOGGER.log(System.Logger.Level.INFO, "Authorization provider is missing from security configuration, but security extension for microprofile is enabled (requires providers configuration at key security.providers). ABAC provider is configured for authorization.");
            this.securityBuilder.addAuthorizationProvider((AuthorizationProvider)AbacProvider.create());
        }
        Security tmpSecurity = this.securityBuilder.build();
        this.securityBuilder = null;
        if (!tmpSecurity.enabled()) {
            LOGGER.log(System.Logger.Level.INFO, "Security is disabled.");
            tmpSecurity = Security.builder().enabled(false).build();
        }
        Security security = tmpSecurity;
        Contexts.globalContext().register((Object)security);
        JaxRsCdiExtension jaxrs = (JaxRsCdiExtension)bm.getExtension(JaxRsCdiExtension.class);
        ServerCdiExtension server = (ServerCdiExtension)bm.getExtension(ServerCdiExtension.class);
        server.addFeature((ServerFeature)this.securityFeatureBuilder.build());
        this.securityFeatureBuilder = null;
        Contexts.context().ifPresent(ctx -> ctx.register((Object)security));
        Config jerseyConfig = this.config.get("security.jersey");
        if (((Boolean)jerseyConfig.get("enabled").asBoolean().orElse((Object)true)).booleanValue()) {
            JerseySecurityFeature feature = JerseySecurityFeature.builder(security).config((io.helidon.common.config.Config)jerseyConfig).build();
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Security feature config: {0}. Registered for applications: {1}", feature.featureConfig(), jaxrs.applicationsToRun());
            }
            jaxrs.applicationsToRun().forEach(app -> app.resourceConfig().register((Object)feature));
        } else {
            SecurityDisabledFeature feature = new SecurityDisabledFeature(security);
            jaxrs.applicationsToRun().forEach(app -> app.resourceConfig().register((Object)feature));
        }
        this.security.set(security);
    }

    private AuthenticationResponse failingAtnProvider(ProviderRequest request) {
        return AuthenticationResponse.failed((String)"No provider configured");
    }
}

