/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.context.Contexts;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.Ref;

@PreMatching
@Priority(value=1000)
@ConstrainedTo(value=RuntimeType.SERVER)
class SecurityDisabledFilter
implements ContainerRequestFilter {
    private final AtomicLong contextCounter = new AtomicLong();
    private final Security security;
    @Context
    private InjectionManager injectionManager;

    SecurityDisabledFilter(Security security) {
        this.security = security;
    }

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        SecurityContext securityContext = this.security.createContext("empty-security-context-" + this.contextCounter.incrementAndGet());
        Contexts.context().ifPresent(ctx -> ctx.register((Object)securityContext));
        ((Ref)this.injectionManager.getInstance(new GenericType<Ref<SecurityContext>>(this){}.getType())).set((Object)securityContext);
    }
}

