/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;

class SecurityProducer {
    private final AtomicLong contextCounter = new AtomicLong();

    SecurityProducer() {
    }

    @ApplicationScoped
    @Produces
    Security security() {
        return (Security)Contexts.context().flatMap(this::security).orElseThrow(() -> new IllegalStateException("Security cannot be injected when not configured"));
    }

    @RequestScoped
    @Produces
    SecurityContext securityContext() {
        return Contexts.context().flatMap(this::securityContext).orElseGet(() -> this.emptyContext(this.security()));
    }

    private Optional<SecurityContext> securityContext(Context context) {
        return context.get(SecurityContext.class);
    }

    private Optional<Security> security(Context context) {
        return context.get(Security.class);
    }

    private SecurityContext emptyContext(Security security) {
        return security.createContext("security-producer-context-" + this.contextCounter.incrementAndGet());
    }
}

