/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.security;

import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.microprofile.server.spi.MpService;
import io.helidon.microprofile.server.spi.MpServiceContext;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.Security;
import io.helidon.security.integration.jersey.SecurityFeature;
import io.helidon.security.integration.webserver.WebSecurity;
import io.helidon.security.providers.abac.AbacProvider;
import io.helidon.security.spi.SecurityProvider;
import io.helidon.webserver.Service;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;

public class SecurityMpService
implements MpService {
    private static final Logger LOGGER = Logger.getLogger(SecurityMpService.class.getName());

    public void configure(MpServiceContext context) {
        Config webServerConfig;
        Security security;
        Config config = context.helidonConfig();
        if (config.get("security.providers").exists()) {
            security = Security.create((Config)config.get("security"));
        } else {
            LOGGER.info("Security extension for microprofile is enabled, yet security configuration is missing from config (requires providers configuration at key security.providers). Security will not have any valid provider.");
            security = Security.builder().addProvider((SecurityProvider)AbacProvider.create()).addAuthenticationProvider(providerRequest -> CompletableFuture.completedFuture(AuthenticationResponse.failed((String)"No provider configured"))).build();
        }
        Contexts.context().ifPresent(ctx -> ctx.register((Object)security));
        Config jerseyConfig = config.get("security.jersey");
        if (((Boolean)jerseyConfig.get("enabled").asBoolean().orElse((Object)true)).booleanValue()) {
            SecurityFeature feature = SecurityFeature.builder((Security)security).config(jerseyConfig).build();
            context.applications().forEach(app -> app.register((Object)feature));
        }
        if ((webServerConfig = config.get("security.web-server")).exists() && ((Boolean)webServerConfig.get("enabled").asBoolean().orElse((Object)true)).booleanValue()) {
            context.serverRoutingBuilder().register(new Service[]{WebSecurity.create((Security)security, (Config)config.get("security"))});
        }
        context.register(Security.class, (Object)security);
    }
}

