/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import graphql.scalars.ExtendedScalars;
import io.helidon.common.Builder;
import io.helidon.microprofile.graphql.server.CustomScalars;
import io.helidon.microprofile.graphql.server.FormattingHelper;
import io.helidon.microprofile.graphql.server.GraphQlConfigurationException;
import io.helidon.microprofile.graphql.server.Schema;
import io.helidon.microprofile.graphql.server.SchemaArgument;
import io.helidon.microprofile.graphql.server.SchemaScalar;
import io.helidon.microprofile.graphql.server.SchemaType;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import org.eclipse.microprofile.graphql.DefaultValue;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.Enum;
import org.eclipse.microprofile.graphql.Ignore;
import org.eclipse.microprofile.graphql.Input;
import org.eclipse.microprofile.graphql.Interface;
import org.eclipse.microprofile.graphql.Mutation;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.Query;

final class SchemaGeneratorHelper {
    protected static final String OFFSET_TIME_CLASS = OffsetTime.class.getName();
    protected static final String LOCAL_TIME_CLASS = LocalTime.class.getName();
    protected static final String OFFSET_DATE_TIME_CLASS = OffsetDateTime.class.getName();
    protected static final String ZONED_DATE_TIME_CLASS = ZonedDateTime.class.getName();
    protected static final String LOCAL_DATE_TIME_CLASS = LocalDateTime.class.getName();
    protected static final String LOCAL_DATE_CLASS = LocalDate.class.getName();
    protected static final String LEGACY_DATE_CLASS = Date.class.getName();
    protected static final String BIG_DECIMAL_CLASS = BigDecimal.class.getName();
    protected static final String LONG_CLASS = Long.class.getName();
    protected static final String LONG_PRIMITIVE_CLASS = Long.TYPE.getName();
    protected static final String FLOAT_CLASS = Float.class.getName();
    protected static final String FLOAT_PRIMITIVE_CLASS = Float.TYPE.getName();
    protected static final String DOUBLE_CLASS = Double.class.getName();
    protected static final String DOUBLE_PRIMITIVE_CLASS = Double.TYPE.getName();
    protected static final String BIG_INTEGER_CLASS = BigInteger.class.getName();
    protected static final String INTEGER_CLASS = Integer.class.getName();
    protected static final String INTEGER_PRIMITIVE_CLASS = Integer.TYPE.getName();
    protected static final String BYTE_CLASS = Byte.class.getName();
    protected static final String BYTE_PRIMITIVE_CLASS = Byte.TYPE.getName();
    protected static final String SHORT_CLASS = Short.class.getName();
    protected static final String SHORT_PRIMITIVE_CLASS = Short.TYPE.getName();
    public static final String FORMATTED_DATE_SCALAR = "FormattedDate";
    public static final String FORMATTED_DATETIME_SCALAR = "FormattedDateTime";
    public static final String FORMATTED_OFFSET_DATETIME_SCALAR = "FormattedOffsetDateTime";
    public static final String FORMATTED_ZONED_DATETIME_SCALAR = "FormattedZonedDateTime";
    public static final String FORMATTED_TIME_SCALAR = "FormattedTime";
    public static final String DATE_SCALAR = "Date";
    public static final String DATETIME_SCALAR = "DateTime";
    public static final String TIME_SCALAR = "Time";
    static final String BIG_DECIMAL = "BigDecimal";
    static final String BIG_INTEGER = "BigInteger";
    static final String DEFAULT_LOCALE = "##default";
    public static final String INT = "Int";
    public static final String FLOAT = "Float";
    public static final String STRING = "String";
    public static final String ID = "ID";
    public static final String BOOLEAN = "Boolean";
    private static final Logger LOGGER = Logger.getLogger(SchemaGeneratorHelper.class.getName());
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    static final Map<String, SchemaScalar> SUPPORTED_SCALARS = new HashMap<String, SchemaScalar>(){
        {
            this.put(Object.class.getName(), new SchemaScalar("Object", Object.class.getName(), ExtendedScalars.Object, null));
            this.put(OffsetTime.class.getName(), new SchemaScalar(SchemaGeneratorHelper.FORMATTED_TIME_SCALAR, OFFSET_TIME_CLASS, CustomScalars.FORMATTED_CUSTOM_TIME_SCALAR, "HH[:mm][:ss]Z"));
            this.put(LocalTime.class.getName(), new SchemaScalar(SchemaGeneratorHelper.FORMATTED_TIME_SCALAR, LOCAL_TIME_CLASS, CustomScalars.FORMATTED_CUSTOM_TIME_SCALAR, "HH[:mm][:ss]"));
            this.put(OFFSET_DATE_TIME_CLASS, new SchemaScalar(SchemaGeneratorHelper.FORMATTED_OFFSET_DATETIME_SCALAR, OFFSET_DATE_TIME_CLASS, CustomScalars.CUSTOM_OFFSET_DATE_TIME_SCALAR, "yyyy-MM-dd'T'HH[:mm][:ss]Z"));
            this.put(ZONED_DATE_TIME_CLASS, new SchemaScalar(SchemaGeneratorHelper.FORMATTED_ZONED_DATETIME_SCALAR, ZONED_DATE_TIME_CLASS, CustomScalars.CUSTOM_ZONED_DATE_TIME_SCALAR, "yyyy-MM-dd'T'HH[:mm][:ss]Z'['VV']'"));
            this.put(LOCAL_DATE_TIME_CLASS, new SchemaScalar(SchemaGeneratorHelper.FORMATTED_DATETIME_SCALAR, LOCAL_DATE_TIME_CLASS, CustomScalars.FORMATTED_CUSTOM_DATE_TIME_SCALAR, "yyyy-MM-dd'T'HH[:mm][:ss]"));
            this.put(LOCAL_DATE_CLASS, new SchemaScalar(SchemaGeneratorHelper.FORMATTED_DATE_SCALAR, LOCAL_DATE_CLASS, CustomScalars.FORMATTED_CUSTOM_DATE_SCALAR, "yyyy-MM-dd"));
            this.put(LEGACY_DATE_CLASS, new SchemaScalar(SchemaGeneratorHelper.FORMATTED_DATE_SCALAR, LEGACY_DATE_CLASS, CustomScalars.FORMATTED_CUSTOM_DATE_SCALAR, "yyyy-MM-dd"));
            this.put(BIG_DECIMAL_CLASS, new SchemaScalar(SchemaGeneratorHelper.BIG_DECIMAL, BIG_DECIMAL_CLASS, CustomScalars.CUSTOM_BIGDECIMAL_SCALAR, null));
            this.put(BIG_INTEGER_CLASS, new SchemaScalar(SchemaGeneratorHelper.BIG_INTEGER, BIG_INTEGER_CLASS, CustomScalars.CUSTOM_BIGINTEGER_SCALAR, null));
            this.put(LONG_PRIMITIVE_CLASS, new SchemaScalar(SchemaGeneratorHelper.BIG_INTEGER, LONG_CLASS, CustomScalars.CUSTOM_BIGINTEGER_SCALAR, null));
            this.put(LONG_CLASS, new SchemaScalar(SchemaGeneratorHelper.BIG_INTEGER, LONG_CLASS, CustomScalars.CUSTOM_BIGINTEGER_SCALAR, null));
            this.put(INTEGER_CLASS, new SchemaScalar(SchemaGeneratorHelper.INT, INTEGER_CLASS, CustomScalars.CUSTOM_INT_SCALAR, null));
            this.put(INTEGER_PRIMITIVE_CLASS, new SchemaScalar(SchemaGeneratorHelper.INT, INTEGER_PRIMITIVE_CLASS, CustomScalars.CUSTOM_INT_SCALAR, null));
            this.put(BYTE_CLASS, new SchemaScalar(SchemaGeneratorHelper.INT, BYTE_CLASS, CustomScalars.CUSTOM_INT_SCALAR, null));
            this.put(BYTE_PRIMITIVE_CLASS, new SchemaScalar(SchemaGeneratorHelper.INT, BYTE_PRIMITIVE_CLASS, CustomScalars.CUSTOM_INT_SCALAR, null));
            this.put(SHORT_CLASS, new SchemaScalar(SchemaGeneratorHelper.INT, SHORT_CLASS, CustomScalars.CUSTOM_INT_SCALAR, null));
            this.put(SHORT_PRIMITIVE_CLASS, new SchemaScalar(SchemaGeneratorHelper.INT, SHORT_PRIMITIVE_CLASS, CustomScalars.CUSTOM_INT_SCALAR, null));
            this.put(FLOAT_CLASS, new SchemaScalar(SchemaGeneratorHelper.FLOAT, FLOAT_CLASS, CustomScalars.CUSTOM_FLOAT_SCALAR, null));
            this.put(FLOAT_PRIMITIVE_CLASS, new SchemaScalar(SchemaGeneratorHelper.FLOAT, FLOAT_PRIMITIVE_CLASS, CustomScalars.CUSTOM_FLOAT_SCALAR, null));
            this.put(DOUBLE_CLASS, new SchemaScalar(SchemaGeneratorHelper.FLOAT, DOUBLE_CLASS, CustomScalars.CUSTOM_FLOAT_SCALAR, null));
            this.put(DOUBLE_PRIMITIVE_CLASS, new SchemaScalar(SchemaGeneratorHelper.FLOAT, DOUBLE_PRIMITIVE_CLASS, CustomScalars.CUSTOM_FLOAT_SCALAR, null));
        }
    };
    static final List<String> BOOLEAN_LIST = new ArrayList<String>(){
        {
            this.add("boolean");
            this.add("java.lang.Boolean");
        }
    };
    static final List<String> STRING_LIST = new ArrayList<String>(){
        {
            this.add("java.lang.String");
            this.add("java.lang.Character");
            this.add("char");
        }
    };
    static final Map<String, String> PRIMITIVE_ARRAY_MAP = new HashMap<String, String>(){
        {
            this.put("[Z", "boolean");
            this.put("[B", "byte");
            this.put("[C", "char");
            this.put("[D", "double");
            this.put("[F", "float");
            this.put("[I", "int");
            this.put("[J", "long");
            this.put("[S", "short");
        }
    };
    static final List<String> JAVA_PRIMITIVE_TYPES = new ArrayList<String>(){
        {
            this.add("byte");
            this.add("short");
            this.add("int");
            this.add("long");
            this.add("float");
            this.add("double");
            this.add("boolean");
            this.add("char");
        }
    };

    private SchemaGeneratorHelper() {
    }

    protected static String getSimpleName(String className) throws ClassNotFoundException {
        return SchemaGeneratorHelper.getSimpleName(className, false);
    }

    protected static boolean isPrimitive(Class<?> clazz) {
        return SchemaGeneratorHelper.isPrimitive(clazz.getName());
    }

    protected static boolean isPrimitive(String clazz) {
        return JAVA_PRIMITIVE_TYPES.contains(clazz) || PRIMITIVE_ARRAY_MAP.containsValue(clazz);
    }

    protected static boolean isPrimitiveArray(String clazz) {
        return PRIMITIVE_ARRAY_MAP.containsValue(clazz);
    }

    protected static boolean isPrimitiveArray(Class<?> clazz) {
        String className = clazz.getName();
        for (String key : PRIMITIVE_ARRAY_MAP.keySet()) {
            if (!className.contains(key)) continue;
            return true;
        }
        return false;
    }

    protected static String getSimpleName(String className, boolean ignoreInputNameAnnotation) throws ClassNotFoundException {
        if (ID.equals(className) || STRING.equals(className) || BOOLEAN.equalsIgnoreCase(className) || SchemaGeneratorHelper.getScalar(className) != null) {
            return className;
        }
        Class<?> clazz = Class.forName(className);
        return SchemaGeneratorHelper.getTypeName(clazz, ignoreInputNameAnnotation);
    }

    protected static SchemaScalar getScalar(String clazzName) {
        return SUPPORTED_SCALARS.get(clazzName);
    }

    protected static boolean isScalar(String scalarName) {
        return SUPPORTED_SCALARS.values().stream().anyMatch(s -> s.name().equals(scalarName));
    }

    protected static String getGraphQLType(String className) {
        if (BOOLEAN_LIST.contains(className)) {
            return BOOLEAN;
        }
        if (STRING_LIST.contains(className)) {
            return STRING;
        }
        if (UUID.class.getName().equals(className)) {
            return ID;
        }
        return className;
    }

    protected static boolean isDateTimeScalar(String scalarName) {
        return FORMATTED_DATE_SCALAR.equals(scalarName) || FORMATTED_TIME_SCALAR.equals(scalarName) || FORMATTED_OFFSET_DATETIME_SCALAR.equals(scalarName) || FORMATTED_ZONED_DATETIME_SCALAR.equals(scalarName) || FORMATTED_DATETIME_SCALAR.equals(scalarName);
    }

    protected static boolean isGraphQLType(String type) {
        return BOOLEAN.equals(type) || STRING.equals(type) || ID.equals(type);
    }

    protected static String getFieldName(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            Name nameAnnotation = field.getAnnotation(Name.class);
            if (nameAnnotation != null && !nameAnnotation.value().isBlank()) {
                return nameAnnotation.value();
            }
            JsonbProperty jsonbPropertyAnnotation = field.getAnnotation(JsonbProperty.class);
            return jsonbPropertyAnnotation != null && !jsonbPropertyAnnotation.value().isBlank() ? jsonbPropertyAnnotation.value() : null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    protected static String getMethodName(Method method) {
        if (method != null) {
            Query queryAnnotation = method.getAnnotation(Query.class);
            Mutation mutationAnnotation = method.getAnnotation(Mutation.class);
            Name nameAnnotation = method.getAnnotation(Name.class);
            JsonbProperty jsonbPropertyAnnotation = method.getAnnotation(JsonbProperty.class);
            if (queryAnnotation != null && !queryAnnotation.value().isBlank()) {
                return queryAnnotation.value();
            }
            if (mutationAnnotation != null && !mutationAnnotation.value().isBlank()) {
                return mutationAnnotation.value();
            }
            if (nameAnnotation != null && !nameAnnotation.value().isBlank()) {
                return nameAnnotation.value();
            }
            if (jsonbPropertyAnnotation != null && !jsonbPropertyAnnotation.value().isBlank()) {
                return jsonbPropertyAnnotation.value();
            }
        }
        return null;
    }

    protected static Class<?> getSafeClass(String clazzName) {
        try {
            return Class.forName(clazzName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected static boolean isDateTimeClass(Class<?> clazz) {
        return clazz != null && (clazz.equals(LocalDate.class) || clazz.equals(Date.class) || clazz.equals(LocalTime.class) || clazz.equals(LocalDateTime.class) || clazz.equals(OffsetTime.class) || clazz.equals(ZonedDateTime.class) || clazz.equals(OffsetDateTime.class));
    }

    protected static boolean isValidIDType(Class<?> clazz) {
        return clazz.equals(Long.class) || clazz.equals(Integer.class) || clazz.equals(UUID.class) || clazz.equals(Integer.TYPE) || clazz.equals(String.class) || clazz.equals(Long.TYPE);
    }

    protected static boolean isEnumClass(String clazz) {
        try {
            return Class.forName(clazz).isEnum();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected static String getNameAnnotationValue(Class<?> clazz) {
        Name nameAnnotation = clazz.getAnnotation(Name.class);
        if (nameAnnotation != null && !"".equals(nameAnnotation.value())) {
            return nameAnnotation.value();
        }
        return null;
    }

    protected static String getDefaultValueAnnotationValue(AnnotatedElement annotatedElement) {
        DefaultValue defaultValueAnnotation = annotatedElement.getAnnotation(DefaultValue.class);
        if (defaultValueAnnotation != null && !"".equals(defaultValueAnnotation.value())) {
            return defaultValueAnnotation.value();
        }
        return null;
    }

    protected static String getDefaultDescription(String[] format, String description) {
        String fmt;
        String string = format == null || format.length != 2 || format[0] == null || format[1] == null ? null : (fmt = format[0] + (String)(DEFAULT_LOCALE.equals(format[1]) ? "" : " " + format[1]));
        if (description == null && fmt == null) {
            return null;
        }
        if (fmt != null) {
            fmt = fmt.replaceAll("\\[", "").replaceAll("]", "");
        }
        return description == null ? fmt.trim() : (fmt == null ? description : description + " (" + fmt.trim() + ")");
    }

    protected static String stripMethodName(Method method, boolean isStrictTest) {
        Object varName;
        String name = method.getName();
        boolean isPublic = Modifier.isPublic(method.getModifiers());
        boolean isSetterName = name.matches("^set[A-Z].*");
        boolean isGetterName = name.matches("^get[A-Z].*") || name.matches("^is[A-Z].*");
        Parameter[] parameters = method.getParameters();
        if (isStrictTest) {
            boolean isGetter;
            boolean isSetter = isPublic && method.getReturnType().equals(Void.TYPE) && parameters.length == 1 && isSetterName;
            boolean bl = isGetter = isPublic && !method.getReturnType().equals(Void.TYPE) && parameters.length == 0 && isGetterName;
            if (!isGetter && !isSetter) {
                return name;
            }
        } else if (!isPublic || !isGetterName && !isSetterName) {
            return name;
        }
        if (name.startsWith("is") || name.startsWith("get") || name.startsWith("set")) {
            String prefix = name.startsWith("is") ? "is" : (name.startsWith("get") ? "get" : (name.startsWith("set") ? "set" : ""));
            varName = name.replaceAll(prefix, "");
            varName = ((String)varName).substring(0, 1).toLowerCase() + ((String)varName).substring(1);
        } else {
            varName = name;
        }
        return varName;
    }

    protected static String getTypeName(Class<?> clazz) {
        return SchemaGeneratorHelper.getTypeName(clazz, false);
    }

    protected static Annotation[] getFieldAnnotations(Field field, int index) {
        if (field.getAnnotatedType() instanceof AnnotatedParameterizedType) {
            return SchemaGeneratorHelper.getAnnotationsFromType((AnnotatedParameterizedType)field.getAnnotatedType(), index);
        }
        return EMPTY_ANNOTATIONS;
    }

    protected static Annotation[] getMethodAnnotations(Method method, int index) {
        if (method.getAnnotatedReturnType() instanceof AnnotatedParameterizedType) {
            return SchemaGeneratorHelper.getAnnotationsFromType((AnnotatedParameterizedType)method.getAnnotatedReturnType(), index);
        }
        return EMPTY_ANNOTATIONS;
    }

    protected static Annotation[] getParameterAnnotations(Parameter parameter, int index) {
        if (parameter.getAnnotatedType() instanceof AnnotatedParameterizedType) {
            return SchemaGeneratorHelper.getAnnotationsFromType((AnnotatedParameterizedType)parameter.getAnnotatedType(), index);
        }
        return EMPTY_ANNOTATIONS;
    }

    private static Annotation[] getAnnotationsFromType(AnnotatedParameterizedType apt, int index) {
        if (apt != null) {
            AnnotatedType annotatedActualTypeArgument = apt.getAnnotatedActualTypeArguments()[index];
            while (annotatedActualTypeArgument instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType parameterizedType2 = (AnnotatedParameterizedType)annotatedActualTypeArgument;
                annotatedActualTypeArgument = parameterizedType2.getAnnotatedActualTypeArguments()[index];
            }
            if (annotatedActualTypeArgument != null) {
                return annotatedActualTypeArgument.getAnnotations();
            }
        }
        return EMPTY_ANNOTATIONS;
    }

    protected static Annotation getAnnotationValue(Annotation[] annotations, Type type) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(type)) continue;
                return annotation;
            }
        }
        return null;
    }

    protected static String getTypeName(Class<?> clazz, boolean ignoreInputNameAnnotation) {
        org.eclipse.microprofile.graphql.Type typeAnnotation = clazz.getAnnotation(org.eclipse.microprofile.graphql.Type.class);
        Interface interfaceAnnotation = clazz.getAnnotation(Interface.class);
        Input inputAnnotation = ignoreInputNameAnnotation ? null : clazz.getAnnotation(Input.class);
        Enum enumAnnotation = clazz.getAnnotation(Enum.class);
        Query queryAnnotation = clazz.getAnnotation(Query.class);
        Mutation mutationAnnotation = clazz.getAnnotation(Mutation.class);
        String name = "";
        if (typeAnnotation != null) {
            name = typeAnnotation.value();
        } else if (interfaceAnnotation != null) {
            name = interfaceAnnotation.value();
        } else if (inputAnnotation != null) {
            name = inputAnnotation.value();
        } else if (enumAnnotation != null) {
            name = enumAnnotation.value();
        } else if (queryAnnotation != null) {
            name = queryAnnotation.value();
        } else if (mutationAnnotation != null) {
            name = mutationAnnotation.value();
        }
        if ("".equals(name)) {
            name = SchemaGeneratorHelper.getNameAnnotationValue(clazz);
        }
        SchemaGeneratorHelper.ensureValidName(LOGGER, name);
        return name == null || name.isBlank() ? clazz.getSimpleName() : name;
    }

    protected static void ensureValidName(Logger logger, String name) {
        if (name != null && !SchemaGeneratorHelper.isValidGraphQLName(name)) {
            SchemaGeneratorHelper.ensureConfigurationException(LOGGER, "The name '" + name + "' is not a valid GraphQL name and cannot be used.");
        }
    }

    protected static void checkScalars(Schema schema, SchemaType type) {
        type.fieldDefinitions().forEach(fd -> {
            SchemaScalar scalar = SchemaGeneratorHelper.getScalar(fd.returnType());
            if (scalar != null) {
                fd.returnType(scalar.name());
                if (!schema.containsScalarWithName(scalar.name())) {
                    schema.addScalar(scalar);
                }
            }
        });
    }

    protected static String[] ensureFormat(String scalarName, String clazzName, String[] existingFormat) {
        String[] defaultFormat;
        if ((existingFormat == null || existingFormat[0] == null && existingFormat[1] == null && SchemaGeneratorHelper.isScalar(scalarName)) && (defaultFormat = FormattingHelper.getDefaultDateTimeFormat(scalarName, clazzName)) != null) {
            return defaultFormat;
        }
        return existingFormat;
    }

    protected static int getArrayLevels(String clazz) {
        int c = 0;
        for (int i = 0; i < clazz.length(); ++i) {
            if (clazz.charAt(i) != '[') continue;
            ++c;
        }
        return c;
    }

    protected static boolean isArrayType(String clazz) {
        return clazz.startsWith("[");
    }

    protected static String getRootArrayClass(String clazz) {
        if (clazz == null || "".equals(clazz.trim()) || clazz.length() < 2) {
            throw new IllegalArgumentException("Class must be not null");
        }
        String type = PRIMITIVE_ARRAY_MAP.get(clazz.substring(clazz.length() - 2));
        if (type != null) {
            return type;
        }
        return clazz.replaceAll("\\[", "").replaceAll(";", "").replaceAll("^L", "");
    }

    protected static boolean shouldIgnoreMethod(Method method, boolean isInputType) {
        String prefix;
        Ignore ignore = method.getAnnotation(Ignore.class);
        JsonbTransient jsonbTransient = method.getAnnotation(JsonbTransient.class);
        if (ignore == null && jsonbTransient == null) {
            return false;
        }
        String methodName = method.getName();
        String string = methodName.startsWith("set") ? "set" : (prefix = methodName.startsWith("get") ? "get" : null);
        if ("get".equals(prefix) && !isInputType) {
            return true;
        }
        return "set".equals(prefix) && isInputType;
    }

    protected static boolean shouldIgnoreField(Class<?> clazz, String fieldName) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            return field != null && (field.getAnnotation(Ignore.class) != null || field.getAnnotation(JsonbTransient.class) != null);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    protected static String getDescription(Description description) {
        return description == null || "".equals(description.value()) ? null : description.value();
    }

    protected static boolean isValidGraphQLName(String name) {
        return name != null && name.matches("[_A-Za-z][_0-9A-Za-z]*") && !name.startsWith("__");
    }

    protected static void ensureRuntimeException(Logger logger, String message) {
        SchemaGeneratorHelper.ensureRuntimeException(logger, message, null);
    }

    protected static void ensureRuntimeException(Logger logger, String message, Throwable cause) {
        logger.warning(message);
        if (cause != null) {
            logger.warning(SchemaGeneratorHelper.getStackTrace(cause));
        }
        throw new RuntimeException(message, cause);
    }

    protected static void ensureConfigurationException(Logger logger, String message) {
        SchemaGeneratorHelper.ensureConfigurationException(logger, message, null);
    }

    protected static void ensureConfigurationException(Logger logger, String message, Throwable cause) {
        logger.warning(message);
        if (cause != null) {
            logger.warning(SchemaGeneratorHelper.getStackTrace(cause));
        }
        throw new GraphQlConfigurationException(message, cause);
    }

    protected static String getStackTrace(Throwable throwable) {
        StringWriter stack = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stack));
        return stack.toString();
    }

    protected static void validateIDClass(Class<?> returnClazz) {
        if (!SchemaGeneratorHelper.isValidIDType(returnClazz)) {
            SchemaGeneratorHelper.ensureConfigurationException(LOGGER, "A class of type " + String.valueOf(returnClazz) + " is not allowed to be an @Id");
        }
    }

    protected static void validateIDClass(String returnClazz) {
        try {
            SchemaGeneratorHelper.validateIDClass(Class.forName(returnClazz));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static class DiscoveredMethod {
        public static final int QUERY_TYPE = 0;
        public static final int MUTATION_TYPE = 1;
        private String name;
        private String returnType;
        private int methodType;
        private String collectionType;
        private boolean isArrayReturnType;
        private boolean isMap;
        private List<SchemaArgument> listArguments = new ArrayList<SchemaArgument>();
        private Method method;
        private int arrayLevels = 0;
        private String source;
        private String propertyName;
        private boolean isQueryAnnotated = false;
        private String[] format = new String[0];
        private String description;
        private boolean isReturnTypeMandatory;
        private Object defaultValue;
        private boolean isArrayReturnTypeMandatory;
        private Class<?> originalArrayType;
        private boolean isJsonbFormat;
        private boolean isJsonbProperty;

        private DiscoveredMethod(Builder builder) {
            this.name = builder.name;
            this.returnType = builder.returnType;
            this.methodType = builder.methodType;
            this.collectionType = builder.collectionType;
            this.isArrayReturnType = builder.isArrayReturnType;
            this.isMap = builder.isMap;
            this.listArguments = builder.listArguments;
            this.method = builder.method;
            this.arrayLevels = builder.arrayLevels;
            this.source = builder.source;
            this.propertyName = builder.propertyName;
            this.isQueryAnnotated = builder.isQueryAnnotated;
            this.format = builder.format;
            this.description = builder.description;
            this.isArrayReturnTypeMandatory = builder.isReturnTypeMandatory;
            this.defaultValue = builder.defaultValue;
            this.originalArrayType = builder.originalArrayType;
            this.isJsonbFormat = builder.isJsonbFormat;
            this.isJsonbProperty = builder.isJsonbProperty;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String name() {
            return this.name;
        }

        public void name(String name) {
            this.name = name;
        }

        public String returnType() {
            return this.returnType;
        }

        public void returnType(String returnType) {
            this.returnType = returnType;
        }

        public String collectionType() {
            return this.collectionType;
        }

        public void collectionType(String collectionType) {
            this.collectionType = collectionType;
        }

        public void jsonbProperty(boolean isJsonbProperty) {
            this.isJsonbProperty = isJsonbProperty;
        }

        public boolean isJsonbProperty() {
            return this.isJsonbProperty;
        }

        public boolean isMap() {
            return this.isMap;
        }

        public void map(boolean map) {
            this.isMap = map;
        }

        public int methodType() {
            return this.methodType;
        }

        public void methodType(int methodType) {
            this.methodType = methodType;
        }

        public boolean isArrayReturnType() {
            return this.isArrayReturnType;
        }

        public void arrayReturnType(boolean arrayReturnType) {
            this.isArrayReturnType = arrayReturnType;
        }

        public boolean isCollectionType() {
            return this.collectionType != null;
        }

        public Method method() {
            return this.method;
        }

        public void method(Method method) {
            this.method = method;
        }

        public List<SchemaArgument> arguments() {
            return this.listArguments;
        }

        public int arrayLevels() {
            return this.arrayLevels;
        }

        public void arrayLevels(int arrayLevels) {
            this.arrayLevels = arrayLevels;
        }

        public void addArgument(SchemaArgument argument) {
            this.listArguments.add(argument);
        }

        public String source() {
            return this.source;
        }

        public void source(String source) {
            this.source = source;
        }

        public boolean isQueryAnnotated() {
            return this.isQueryAnnotated;
        }

        public void queryAnnotated(boolean queryAnnotated) {
            this.isQueryAnnotated = queryAnnotated;
        }

        public String[] format() {
            if (this.format == null) {
                return null;
            }
            String[] copy = new String[this.format.length];
            System.arraycopy(this.format, 0, copy, 0, copy.length);
            return copy;
        }

        public void format(String[] format) {
            if (format == null) {
                this.format = null;
            } else {
                this.format = new String[format.length];
                System.arraycopy(format, 0, this.format, 0, this.format.length);
            }
        }

        public String propertyName() {
            return this.propertyName;
        }

        public void propertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public String description() {
            return this.description;
        }

        public void description(String description) {
            this.description = description;
        }

        public boolean isReturnTypeMandatory() {
            return this.isReturnTypeMandatory;
        }

        public void returnTypeMandatory(boolean returnTypeMandatory) {
            this.isReturnTypeMandatory = returnTypeMandatory;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public void defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public boolean isArrayReturnTypeMandatory() {
            return this.isArrayReturnTypeMandatory;
        }

        public void arrayReturnTypeMandatory(boolean arrayReturnTypeMandatory) {
            this.isArrayReturnTypeMandatory = arrayReturnTypeMandatory;
        }

        public void originalArrayType(Class<?> originalArrayType) {
            this.originalArrayType = originalArrayType;
        }

        public Class<?> originalArrayType() {
            return this.originalArrayType;
        }

        public void jsonbFormat(boolean isJsonbFormat) {
            this.isJsonbFormat = isJsonbFormat;
        }

        public boolean isJsonbFormat() {
            return this.isJsonbFormat;
        }

        public String toString() {
            return "DiscoveredMethod{name='" + this.name + "', returnType='" + this.returnType + "', methodType=" + this.methodType + ", collectionType='" + this.collectionType + "', isArrayReturnType=" + this.isArrayReturnType + ", isMap=" + this.isMap + ", listArguments=" + String.valueOf(this.listArguments) + ", arrayLevels=" + this.arrayLevels + ", source=" + this.source + ", isQueryAnnotated=" + this.isQueryAnnotated + ", isReturnTypeMandatory=" + this.isReturnTypeMandatory + ", isArrayReturnTypeMandatory=" + this.isArrayReturnTypeMandatory + ", description=" + this.description + ", originalArrayType=" + String.valueOf(this.originalArrayType) + ", defaultValue=" + String.valueOf(this.defaultValue) + ", isJsonbFormat=" + this.isJsonbFormat + ", isJsonbProperty=" + this.isJsonbProperty + ", method=" + String.valueOf(this.method) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiscoveredMethod that = (DiscoveredMethod)o;
            return this.methodType == that.methodType && this.isArrayReturnType == that.isArrayReturnType && this.isMap == that.isMap && this.arrayLevels == that.arrayLevels && Objects.equals(this.name, that.name) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.source, that.source) && Objects.equals(this.isQueryAnnotated, that.isQueryAnnotated) && Objects.equals(this.method, that.method) && Objects.equals(this.description, that.description) && Objects.equals(this.isReturnTypeMandatory, that.isReturnTypeMandatory) && Objects.equals(this.isArrayReturnTypeMandatory, that.isArrayReturnTypeMandatory) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.isJsonbFormat, that.isJsonbFormat) && Objects.equals(this.collectionType, that.collectionType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.returnType, this.methodType, this.method, this.arrayLevels, this.isQueryAnnotated, this.collectionType, this.isArrayReturnType, this.isMap, this.source, this.description, this.isReturnTypeMandatory, this.defaultValue, this.isArrayReturnTypeMandatory, this.isJsonbFormat, this.isJsonbProperty);
        }

        public static class Builder
        implements io.helidon.common.Builder<Builder, DiscoveredMethod> {
            private String name;
            private String returnType;
            private int methodType;
            private String collectionType;
            private boolean isArrayReturnType;
            private boolean isMap;
            private List<SchemaArgument> listArguments = new ArrayList<SchemaArgument>();
            private Method method;
            private int arrayLevels = 0;
            private String source;
            private String propertyName;
            private boolean isQueryAnnotated = false;
            private String[] format = new String[0];
            private String description;
            private boolean isReturnTypeMandatory;
            private Object defaultValue;
            private Class<?> originalArrayType;
            private boolean isJsonbFormat;
            private boolean isJsonbProperty;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder returnType(String returnType) {
                this.returnType = returnType;
                return this;
            }

            public Builder methodType(int methodType) {
                this.methodType = methodType;
                return this;
            }

            public Builder collectionType(String collectionType) {
                this.collectionType = collectionType;
                return this;
            }

            public Builder arrayReturnType(boolean isArrayReturnType) {
                this.isArrayReturnType = isArrayReturnType;
                return this;
            }

            public Builder map(boolean isMap) {
                this.isMap = isMap;
                return this;
            }

            public Builder addArgument(SchemaArgument argument) {
                this.listArguments.add(argument);
                return this;
            }

            public Builder method(Method method) {
                this.method = method;
                return this;
            }

            public Builder arrayLevels(int arrayLevels) {
                this.arrayLevels = arrayLevels;
                return this;
            }

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder propertyName(String propertyName) {
                this.propertyName = propertyName;
                return this;
            }

            public Builder queryAnnotated(boolean isQueryAnnotated) {
                this.isQueryAnnotated = isQueryAnnotated;
                return this;
            }

            public Builder format(String[] format) {
                if (format == null) {
                    this.format = null;
                } else {
                    this.format = new String[format.length];
                    System.arraycopy(format, 0, this.format, 0, this.format.length);
                }
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder returnTypeMandatory(boolean isReturnTypeMandatory) {
                this.isReturnTypeMandatory = isReturnTypeMandatory;
                return this;
            }

            public Builder defaultValue(Object defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            public Builder originalArrayType(Class<?> originalArrayType) {
                this.originalArrayType = originalArrayType;
                return this;
            }

            public Builder jsonbFormat(boolean isJsonbFormat) {
                this.isJsonbFormat = isJsonbFormat;
                return this;
            }

            public Builder jsonbProperty(boolean isJsonbProperty) {
                this.isJsonbProperty = isJsonbProperty;
                return this;
            }

            public DiscoveredMethod build() {
                return new DiscoveredMethod(this);
            }
        }
    }
}

