/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.PropertyDataFetcherHelper;
import io.helidon.graphql.server.ExecutionContext;
import io.helidon.microprofile.graphql.server.FormattingHelper;
import io.helidon.microprofile.graphql.server.GraphQlBean;
import io.helidon.microprofile.graphql.server.GraphQlConfigurationException;
import io.helidon.microprofile.graphql.server.JsonUtils;
import io.helidon.microprofile.graphql.server.Schema;
import io.helidon.microprofile.graphql.server.SchemaArgument;
import io.helidon.microprofile.graphql.server.SchemaFieldDefinition;
import io.helidon.microprofile.graphql.server.SchemaGenerator;
import io.helidon.microprofile.graphql.server.SchemaGeneratorHelper;
import io.helidon.microprofile.graphql.server.SchemaInputType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.graphql.GraphQLException;

class DataFetcherUtils {
    private static final Logger LOGGER = Logger.getLogger(DataFetcherUtils.class.getName());
    private static final String[] EMPTY_FORMAT = new String[]{null, null};
    private static final String MAP_MESSAGE = "This implementation does not support using a Map as input to a query or mutation";

    private DataFetcherUtils() {
    }

    static <V> DataFetcher<V> newMethodDataFetcher(Schema schema, Class<?> clazz, Method method, String source, SchemaArgument ... args) {
        GraphQlBean bean = (GraphQlBean)CDI.current().select(GraphQlBean.class, new Annotation[0]).get();
        return environment -> {
            Parameter[] parameters;
            ArrayList<Object> listArgumentValues = new ArrayList<Object>();
            if (source != null) {
                try {
                    Class<?> sourceClazz = Class.forName(source);
                    listArgumentValues.add(sourceClazz.cast(environment.getSource()));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warning("Unable to find source class " + source);
                }
            }
            if ((parameters = method.getParameters()).length == 1 && parameters[0].getType().equals(DataFetchingEnvironment.class)) {
                listArgumentValues.add(environment);
            } else if (args.length > 0) {
                for (SchemaArgument argument : args) {
                    if (argument.isDataFetchingEnvironment()) {
                        listArgumentValues.add(environment);
                        continue;
                    }
                    Class<?> originalType = argument.originalType();
                    if (originalType != null && Map.class.isAssignableFrom(originalType)) {
                        SchemaGeneratorHelper.ensureRuntimeException(LOGGER, MAP_MESSAGE);
                    }
                    if (argument.isArrayReturnType() && argument.arrayLevels() > 1 && SchemaGeneratorHelper.isPrimitiveArray(argument.originalType())) {
                        throw new GraphQlConfigurationException("This implementation does not currently support multi-level primitive arrays as arguments. Please use List or Collection of Object equivalent. E.g. In place of method(int [][] value) use  method(List<List<Integer>> value)");
                    }
                    listArgumentValues.add(DataFetcherUtils.generateArgumentValue(schema, argument.argumentType(), argument.originalType(), argument.originalArrayType(), environment.getArgument(argument.argumentName()), argument.format()));
                }
            }
            try {
                return bean.runGraphQl(clazz, method, listArgumentValues.toArray());
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                graphql.GraphQLException exception = new graphql.GraphQLException(e.getTargetException());
                if (targetException instanceof GraphQLException) {
                    ExecutionContext context = (ExecutionContext)environment.getContext();
                    context.partialResultsException((Throwable)exception);
                    return ((GraphQLException)targetException).getPartialResults();
                }
                throw exception;
            }
        };
    }

    static <S, V> DataFetcher<Collection<V>> newMapValuesDataFetcher(String propertyName) {
        return environment -> {
            Object source = environment.getSource();
            if (source == null) {
                return null;
            }
            Map map = (Map)PropertyDataFetcherHelper.getPropertyValue((String)propertyName, (Object)source, (GraphQLType)environment.getFieldType(), () -> environment);
            return map.values();
        };
    }

    protected static Object generateArgumentValue(Schema schema, String argumentType, Class<?> originalType, Class<?> originalArrayType, Object rawValue, String[] format) throws Exception {
        if (rawValue instanceof Map) {
            SchemaInputType inputType = schema.getInputTypeByName(argumentType);
            Map map = (Map)rawValue;
            HashMap<String, Object> mapConverted = new HashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                DataFetcher dataFetcher;
                String fdName = (String)entry.getKey();
                Object value = entry.getValue();
                SchemaFieldDefinition fd = inputType.getFieldDefinitionByName(fdName);
                SchemaInputType inputFdInputType = schema.getInputTypeByName(fd.returnType());
                if (inputFdInputType != null && value instanceof Map) {
                    mapConverted.put(fdName, DataFetcherUtils.generateArgumentValue(schema, inputFdInputType.name(), Class.forName(inputFdInputType.valueClassName()), null, value, EMPTY_FORMAT));
                    continue;
                }
                if (fd.isJsonbFormat() || fd.isJsonbProperty()) {
                    mapConverted.put(fdName, value);
                    continue;
                }
                Class<Map> originalFdlType = fd.originalType();
                if (originalFdlType != null && originalFdlType.isAssignableFrom(Map.class)) {
                    SchemaGeneratorHelper.ensureRuntimeException(LOGGER, MAP_MESSAGE);
                }
                if ((dataFetcher = fd.dataFetcher()) instanceof PropertyDataFetcher) {
                    fdName = ((PropertyDataFetcher)dataFetcher).getPropertyName();
                }
                mapConverted.put(fdName, DataFetcherUtils.generateArgumentValue(schema, fd.returnType(), fd.originalType(), fd.originalArrayType(), value, fd.format()));
            }
            return JsonUtils.convertFromJson(JsonUtils.convertMapToJson(mapConverted), originalType);
        }
        if (rawValue instanceof Collection) {
            SchemaInputType inputType = schema.getInputTypeByName(argumentType);
            AbstractCollection colResults = null;
            boolean isArray = originalType.isArray();
            try {
                if (originalType.equals(List.class) || isArray) {
                    colResults = new ArrayList();
                } else if (originalType.equals(Set.class) || originalType.equals(Collection.class)) {
                    colResults = new TreeSet();
                } else {
                    Constructor<?> constructor = originalType.getDeclaredConstructor(new Class[0]);
                    colResults = constructor.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                SchemaGeneratorHelper.ensureRuntimeException(LOGGER, "Unable to construct a List of type " + originalType + " using Collection constructor", e);
            }
            if (inputType != null) {
                for (Object value : (Collection)rawValue) {
                    ((Collection)colResults).add(DataFetcherUtils.generateArgumentValue(schema, inputType.name(), originalArrayType, null, value, EMPTY_FORMAT));
                }
                if (isArray) {
                    return ((List)((Object)colResults)).toArray((Object[])Array.newInstance(originalType.getComponentType(), 0));
                }
                return colResults;
            }
            for (Object value : (Collection)rawValue) {
                if (value instanceof Collection) {
                    ((Collection)colResults).add(DataFetcherUtils.generateArgumentValue(schema, argumentType, originalType, originalArrayType, value, format));
                    continue;
                }
                ((Collection)colResults).add(DataFetcherUtils.parseArgumentValue(originalArrayType, argumentType, value, format));
            }
            if (isArray) {
                if (SchemaGeneratorHelper.isPrimitiveArray(originalType)) {
                    return DataFetcherUtils.generatePrimitiveArray(colResults, originalType, argumentType, format);
                }
                return ((List)((Object)colResults)).toArray((Object[])Array.newInstance(originalType.getComponentType(), 0));
            }
            if (originalType.equals(List.class)) {
                return colResults;
            }
            if (originalType.equals(Collection.class)) {
                return colResults;
            }
            return colResults;
        }
        return DataFetcherUtils.parseArgumentValue(originalType, argumentType, rawValue, format);
    }

    protected static Object generatePrimitiveArray(List results, Class<?> originalType, String argumentType, String[] format) {
        Class<?> componentType = originalType.getComponentType();
        try {
            int i = 0;
            if (componentType.equals(Byte.TYPE)) {
                byte[] result = new byte[results.size()];
                for (Object value : results) {
                    result[i++] = Byte.parseByte(value.toString());
                }
                return result;
            }
            if (componentType.equals(Character.TYPE)) {
                char[] result = new char[results.size()];
                for (Object value : results) {
                    result[i++] = value.toString().charAt(0);
                }
                return result;
            }
            if (componentType.equals(Boolean.TYPE)) {
                boolean[] result = new boolean[results.size()];
                for (Object value : results) {
                    result[i++] = Boolean.parseBoolean(value.toString());
                }
                return result;
            }
            if (componentType.equals(Short.TYPE)) {
                short[] result = new short[results.size()];
                for (Object value : results) {
                    result[i++] = (Short)DataFetcherUtils.parseArgumentValue(componentType, argumentType, value, format);
                }
                return result;
            }
            if (componentType.equals(Float.TYPE)) {
                float[] result = new float[results.size()];
                for (Object value : results) {
                    result[i++] = ((Float)DataFetcherUtils.parseArgumentValue(componentType, argumentType, value, format)).floatValue();
                }
                return result;
            }
            if (componentType.equals(Integer.TYPE)) {
                int[] result = new int[results.size()];
                for (Object value : results) {
                    result[i++] = (Integer)DataFetcherUtils.parseArgumentValue(componentType, argumentType, value, format);
                }
                return result;
            }
            if (componentType.equals(Long.TYPE)) {
                long[] result = new long[results.size()];
                for (Object value : results) {
                    result[i++] = (Long)DataFetcherUtils.parseArgumentValue(componentType, argumentType, value, format);
                }
                return result;
            }
            if (componentType.equals(Double.TYPE)) {
                double[] result = new double[results.size()];
                for (Object value : results) {
                    result[i++] = (Double)DataFetcherUtils.parseArgumentValue(componentType, argumentType, value, format);
                }
                return result;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    protected static Object parseArgumentValue(Class<?> originalType, String argumentType, Object rawValue, String[] format) throws Exception {
        if (originalType == null) {
            originalType = rawValue.getClass();
        }
        if (originalType.isEnum()) {
            Class<?> enumClass = originalType;
            return Enum.valueOf(enumClass, rawValue.toString());
        }
        if (argumentType.equals("ID") && rawValue != null) {
            return DataFetcherUtils.getOriginalIDValue(originalType, rawValue.toString());
        }
        if (!SchemaGenerator.isFormatEmpty(format)) {
            if (rawValue == null) {
                return null;
            }
            if (SchemaGeneratorHelper.isDateTimeClass(originalType)) {
                DateTimeFormatter dateFormatter = FormattingHelper.getCorrectDateFormatter(originalType.getName(), format[1], format[0]);
                if (dateFormatter == null) {
                    return new SimpleDateFormat(format[0]).parse(rawValue.toString());
                }
                return DataFetcherUtils.getOriginalDateTimeValue(originalType, dateFormatter.parse(rawValue.toString()));
            }
            NumberFormat numberFormat = FormattingHelper.getCorrectNumberFormat(originalType.getName(), format[1], format[0]);
            if (numberFormat != null) {
                return DataFetcherUtils.getOriginalValue(originalType, numberFormat.parse(rawValue.toString()));
            }
            return rawValue;
        }
        return DataFetcherUtils.getOriginalValue(originalType, rawValue);
    }

    private static Object getOriginalIDValue(Class<?> originalType, String key) {
        if (originalType.equals(Long.class) || originalType.equals(Long.TYPE)) {
            return Long.parseLong(key);
        }
        if (originalType.equals(Integer.class) || originalType.equals(Integer.TYPE)) {
            return Integer.parseInt(key);
        }
        if (originalType.equals(UUID.class)) {
            return UUID.fromString(key);
        }
        return key;
    }

    private static Object getOriginalValue(Class<?> originalType, Object key) {
        Number numberKey = null;
        if (key instanceof Number) {
            numberKey = (Number)key;
        } else if (key instanceof String && originalType.isAssignableFrom(Number.class)) {
            try {
                Constructor<?> constructor = originalType.getDeclaredConstructor(String.class);
                numberKey = (Number)constructor.newInstance(key);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException eIgnore) {
                LOGGER.warning("Cannot find constructor with String arg for class " + originalType.getName());
            }
        }
        if (numberKey != null) {
            return originalType.equals(Float.class) ? Float.valueOf(numberKey.floatValue()) : (originalType.equals(Float.TYPE) ? Float.valueOf(numberKey.floatValue()) : (originalType.equals(Integer.class) ? Integer.valueOf(numberKey.intValue()) : (originalType.equals(Integer.TYPE) ? Integer.valueOf(numberKey.intValue()) : (originalType.equals(Long.class) ? Long.valueOf(numberKey.longValue()) : (originalType.equals(Long.TYPE) ? Long.valueOf(numberKey.longValue()) : (originalType.equals(Double.class) ? Double.valueOf(numberKey.doubleValue()) : (originalType.equals(Double.TYPE) ? Double.valueOf(numberKey.doubleValue()) : (originalType.equals(Byte.class) ? Byte.valueOf(numberKey.byteValue()) : (originalType.equals(Byte.TYPE) ? Byte.valueOf(numberKey.byteValue()) : (originalType.equals(Short.class) ? Short.valueOf(numberKey.shortValue()) : (originalType.equals(Short.TYPE) ? Short.valueOf(numberKey.shortValue()) : (originalType.equals(BigDecimal.class) ? BigDecimal.valueOf(numberKey.doubleValue()) : (originalType.equals(BigInteger.class) ? BigInteger.valueOf(numberKey.longValue()) : key)))))))))))));
        }
        if (originalType.equals(Float.class) || originalType.equals(Float.TYPE)) {
            return (Float)key;
        }
        if (originalType.equals(Long.class) || originalType.equals(Long.TYPE)) {
            return Long.valueOf(key.toString());
        }
        return key;
    }

    private static TemporalAccessor getOriginalDateTimeValue(Class<?> originalType, TemporalAccessor value) {
        if (originalType.equals(LocalDateTime.class)) {
            return LocalDateTime.from(value);
        }
        if (originalType.equals(LocalDate.class)) {
            return LocalDate.from(value);
        }
        if (originalType.equals(ZonedDateTime.class)) {
            return ZonedDateTime.from(value);
        }
        if (originalType.equals(OffsetDateTime.class)) {
            return OffsetDateTime.from(value);
        }
        if (originalType.equals(LocalTime.class)) {
            return LocalTime.from(value);
        }
        return null;
    }

    static class DateFormattingDataFetcher
    extends PropertyDataFetcher<Object> {
        private DateTimeFormatter dateTimeFormatter;
        private SimpleDateFormat simpleDateFormat;

        DateFormattingDataFetcher(String propertyName, String type, String valueFormat, String locale) {
            super(propertyName);
            this.dateTimeFormatter = FormattingHelper.getCorrectDateFormatter(type, locale, valueFormat);
            if (this.dateTimeFormatter == null) {
                this.simpleDateFormat = new SimpleDateFormat(valueFormat);
            }
        }

        public Object get(GraphQLFieldDefinition fieldDefinition, Object source, Supplier<DataFetchingEnvironment> environmentSupplier) throws Exception {
            return this.dateTimeFormatter != null ? FormattingHelper.formatDate(super.get(environmentSupplier.get()), this.dateTimeFormatter) : FormattingHelper.formatDate(super.get(environmentSupplier.get()), this.simpleDateFormat);
        }

        public Object get(DataFetchingEnvironment environment) {
            return this.dateTimeFormatter != null ? FormattingHelper.formatDate(super.get(environment), this.dateTimeFormatter) : FormattingHelper.formatDate(super.get(environment), this.simpleDateFormat);
        }
    }

    static class NumberFormattingDataFetcher
    extends PropertyDataFetcher<Object> {
        private NumberFormat numberFormat;
        private boolean isScalar;

        NumberFormattingDataFetcher(String propertyName, String type, String valueFormat, String locale) {
            super(propertyName);
            this.numberFormat = FormattingHelper.getCorrectNumberFormat(type, locale, valueFormat);
            if (this.numberFormat == null) {
                SchemaGeneratorHelper.ensureRuntimeException(LOGGER, "Unable to get number format for property '" + propertyName + "' and type '" + type + "'");
            }
            this.isScalar = SchemaGeneratorHelper.getScalar(type) != null;
        }

        public Object get(GraphQLFieldDefinition fieldDefinition, Object source, Supplier<DataFetchingEnvironment> environmentSupplier) throws Exception {
            return FormattingHelper.formatNumber(super.get(environmentSupplier.get()), this.isScalar, this.numberFormat);
        }

        public Object get(DataFetchingEnvironment environment) {
            return FormattingHelper.formatNumber(super.get(environment), this.isScalar, this.numberFormat);
        }
    }
}

