/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import io.helidon.microprofile.graphql.server.JsonUtils;
import io.helidon.microprofile.graphql.server.SchemaGeneratorHelper;
import java.util.logging.Logger;

interface ElementGenerator {
    public static final Logger LOGGER = Logger.getLogger(ElementGenerator.class.getName());
    public static final String NOTHING = "";
    public static final String COMMA_SPACE = ", ";
    public static final String COMMA = ", ";
    public static final String TRIPLE_QUOTE = "\"\"\"";
    public static final String QUOTE = "\"";
    public static final String SPACER = " ";
    public static final String OPEN_SQUARE = "[";
    public static final String CLOSE_SQUARE = "]";
    public static final String OPEN_CURLY = "{";
    public static final String CLOSE_CURLY = "}";
    public static final char NEWLINE = '\n';
    public static final char COLON = ':';
    public static final char EQUALS = '=';
    public static final char MANDATORY = '!';
    public static final char OPEN_PARENTHESES = '(';
    public static final char CLOSE_PARENTHESES = ')';

    public String getSchemaAsString();

    default public String generateDefaultValue(Object defaultValue, String argumentType) {
        String stringDefault;
        StringBuilder sb = new StringBuilder();
        Object finalDefaultValue = defaultValue;
        sb.append(SPACER).append('=').append(SPACER);
        boolean isJson = false;
        if (defaultValue instanceof String && (stringDefault = (String)defaultValue).contains(OPEN_CURLY) && stringDefault.contains(CLOSE_CURLY)) {
            try {
                finalDefaultValue = JsonUtils.convertJsonToGraphQLSDL(JsonUtils.convertJSONtoMap(stringDefault));
                isJson = true;
            }
            catch (Exception e) {
                SchemaGeneratorHelper.ensureRuntimeException(LOGGER, "Unable to parse default JSON value of[" + stringDefault + "] for " + String.valueOf(this));
            }
        }
        if ("Float".equals(argumentType) || "Int".equals(argumentType) || "Boolean".equals(argumentType) || "BigInteger".equals(argumentType) || "BigDecimal".equals(argumentType) || isJson) {
            sb.append(finalDefaultValue);
        } else {
            sb.append(QUOTE).append(finalDefaultValue).append(QUOTE);
        }
        return sb.toString();
    }
}

