/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import graphql.GraphQLException;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.TypeRuntimeWiring;
import io.helidon.microprofile.graphql.server.ElementGenerator;
import io.helidon.microprofile.graphql.server.SchemaDirective;
import io.helidon.microprofile.graphql.server.SchemaEnum;
import io.helidon.microprofile.graphql.server.SchemaGeneratorHelper;
import io.helidon.microprofile.graphql.server.SchemaInputType;
import io.helidon.microprofile.graphql.server.SchemaScalar;
import io.helidon.microprofile.graphql.server.SchemaType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class Schema
implements ElementGenerator {
    private static final Logger LOGGER = Logger.getLogger(Schema.class.getName());
    public static final String QUERY = "Query";
    public static final String MUTATION = "Mutation";
    public static final String SUBSCRIPTION = "Subscription";
    private String queryName;
    private String mutationName;
    private String subscriptionName;
    private final List<SchemaType> listSchemaTypes = new ArrayList<SchemaType>();
    private final List<SchemaScalar> listSchemaScalars = new ArrayList<SchemaScalar>();
    private final List<SchemaDirective> listSchemaDirectives = new ArrayList<SchemaDirective>();
    private final List<SchemaInputType> listInputTypes = new ArrayList<SchemaInputType>();
    private final List<SchemaEnum> listSchemaEnums = new ArrayList<SchemaEnum>();

    private Schema(Builder builder) {
        this.queryName = builder.queryName;
        this.subscriptionName = builder.subscriptionName;
        this.mutationName = builder.mutationName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Schema create() {
        return Schema.builder().build();
    }

    public GraphQLSchema generateGraphQLSchema() {
        SchemaParser schemaParser = new SchemaParser();
        try {
            TypeDefinitionRegistry typeDefinitionRegistry = schemaParser.parse(this.getSchemaAsString());
            return new SchemaGenerator().makeExecutableSchema(typeDefinitionRegistry, this.getRuntimeWiring());
        }
        catch (Exception e) {
            String message = "Unable to parse the generated schema";
            LOGGER.warning(message + "\n" + this.getSchemaAsString());
            throw new GraphQLException(message, (Throwable)e);
        }
    }

    @Override
    public String getSchemaAsString() {
        StringBuilder sb = new StringBuilder();
        this.listSchemaDirectives.forEach(d -> sb.append(d.getSchemaAsString()).append('\n'));
        if (this.listSchemaDirectives.size() > 0) {
            sb.append('\n');
        }
        sb.append("schema ").append("{").append('\n');
        SchemaType queryType = this.getTypeByName(this.queryName);
        SchemaType mutationType = this.getTypeByName(this.mutationName);
        SchemaType subscriptionType = this.getTypeByName(this.subscriptionName);
        if (queryType != null && queryType.hasFieldDefinitions()) {
            sb.append(" ").append("query: ").append(this.queryName).append('\n');
        }
        if (mutationType != null && mutationType.hasFieldDefinitions()) {
            sb.append(" ").append("mutation: ").append(this.mutationName).append('\n');
        }
        if (subscriptionType != null && subscriptionType.hasFieldDefinitions()) {
            sb.append(" ").append("subscription: ").append(this.subscriptionName).append('\n');
        }
        sb.append("}").append('\n').append('\n');
        this.listSchemaTypes.forEach(t -> sb.append(t.getSchemaAsString()).append("\n"));
        this.listInputTypes.forEach(s -> sb.append(s.getSchemaAsString()).append('\n'));
        this.listSchemaEnums.forEach(e -> sb.append(e.getSchemaAsString()).append('\n'));
        this.listSchemaScalars.forEach(s -> sb.append(s.getSchemaAsString()).append('\n'));
        return sb.toString();
    }

    public RuntimeWiring getRuntimeWiring() {
        RuntimeWiring.Builder builder = RuntimeWiring.newRuntimeWiring();
        SchemaType querySchemaType = this.getTypeByName(this.getQueryName());
        if (querySchemaType == null) {
            throw new GraphQLException("No type exists for query of name " + this.getQueryName());
        }
        TypeRuntimeWiring.Builder typeRuntimeBuilder = TypeRuntimeWiring.newTypeWiring((String)this.getQueryName());
        Set<SchemaType> setInterfaces = this.getTypes().stream().filter(SchemaType::isInterface).collect(Collectors.toSet());
        if (setInterfaces.size() > 0) {
            HashMap mapTypes = new HashMap();
            this.getTypes().stream().filter(t -> !t.isInterface()).forEach(t -> mapTypes.put(t.name(), t.valueClassName()));
            TypeResolver typeResolver = env -> {
                Object o = env.getObject();
                for (Map.Entry entry : mapTypes.entrySet()) {
                    Class<?> typeClass;
                    String valueClass = (String)entry.getValue();
                    if (valueClass == null || (typeClass = SchemaGeneratorHelper.getSafeClass((String)entry.getValue())) == null || !typeClass.isAssignableFrom(o.getClass())) continue;
                    return (GraphQLObjectType)env.getSchema().getType((String)entry.getKey());
                }
                return null;
            };
            setInterfaces.forEach(t -> builder.type(t.name(), tr -> tr.typeResolver(typeResolver)));
            builder.type(this.getQueryName(), tr -> tr.typeResolver(typeResolver));
        }
        this.getScalars().forEach(s -> {
            LOGGER.finest("Register Scalar: " + String.valueOf(s));
            builder.scalar(s.graphQLScalarType());
        });
        builder.type(typeRuntimeBuilder);
        this.getTypes().forEach(t -> {
            boolean hasDataFetchers = t.fieldDefinitions().stream().anyMatch(fd -> fd.dataFetcher() != null);
            if (hasDataFetchers) {
                TypeRuntimeWiring.Builder runtimeBuilder = TypeRuntimeWiring.newTypeWiring((String)t.name());
                t.fieldDefinitions().stream().filter(fd -> fd.dataFetcher() != null).forEach(fd -> runtimeBuilder.dataFetcher(fd.name(), fd.dataFetcher()));
                builder.type(runtimeBuilder);
            }
        });
        return builder.build();
    }

    public SchemaType getTypeByName(String typeName) {
        for (SchemaType schemaType : this.listSchemaTypes) {
            if (!schemaType.name().equals(typeName)) continue;
            return schemaType;
        }
        return null;
    }

    public SchemaInputType getInputTypeByName(String inputTypeName) {
        for (SchemaInputType schemaInputType : this.listInputTypes) {
            if (!schemaInputType.name().equals(inputTypeName)) continue;
            return schemaInputType;
        }
        return null;
    }

    public SchemaType getTypeByClass(String clazz) {
        for (SchemaType schemaType : this.listSchemaTypes) {
            if (!clazz.equals(schemaType.valueClassName())) continue;
            return schemaType;
        }
        return null;
    }

    public SchemaEnum getEnumByName(String enumName) {
        for (SchemaEnum schemaEnum1 : this.listSchemaEnums) {
            if (!schemaEnum1.name().equals(enumName)) continue;
            return schemaEnum1;
        }
        return null;
    }

    public SchemaScalar getScalarByActualClass(String actualClazz) {
        for (SchemaScalar schemaScalar : this.getScalars()) {
            if (!schemaScalar.actualClass().equals(actualClazz)) continue;
            return schemaScalar;
        }
        return null;
    }

    public SchemaScalar getScalarByName(String scalarName) {
        for (SchemaScalar schemaScalar : this.getScalars()) {
            if (!schemaScalar.name().equals(scalarName)) continue;
            return schemaScalar;
        }
        return null;
    }

    public boolean containsTypeWithName(String type) {
        return this.listSchemaTypes.stream().anyMatch(t -> t.name().equals(type));
    }

    public boolean containsInputTypeWithName(String type) {
        return this.listInputTypes.stream().anyMatch(t -> t.name().equals(type));
    }

    public boolean containsScalarWithName(String scalar) {
        return this.listSchemaScalars.stream().anyMatch(s -> s.name().equals(scalar));
    }

    public boolean containsEnumWithName(String enumName) {
        return this.listSchemaEnums.stream().anyMatch(e -> e.name().equals(enumName));
    }

    public void addType(SchemaType schemaType) {
        this.listSchemaTypes.add(schemaType);
    }

    public void addScalar(SchemaScalar schemaScalar) {
        this.listSchemaScalars.add(schemaScalar);
    }

    public void addDirective(SchemaDirective schemaDirective) {
        this.listSchemaDirectives.add(schemaDirective);
    }

    public void addInputType(SchemaInputType inputType) {
        this.listInputTypes.add(inputType);
    }

    public void addEnum(SchemaEnum schemaEnumToAdd) {
        this.listSchemaEnums.add(schemaEnumToAdd);
    }

    public List<SchemaType> getTypes() {
        return this.listSchemaTypes;
    }

    public List<SchemaScalar> getScalars() {
        return this.listSchemaScalars;
    }

    public List<SchemaDirective> getDirectives() {
        return this.listSchemaDirectives;
    }

    public List<SchemaInputType> getInputTypes() {
        return this.listInputTypes;
    }

    public List<SchemaEnum> getEnums() {
        return this.listSchemaEnums;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getMutationName() {
        return this.mutationName;
    }

    public static class Builder
    implements io.helidon.common.Builder<Schema> {
        private String queryName;
        private String mutationName;
        private String subscriptionName;

        private Builder() {
        }

        public Builder queryName(String queryName) {
            this.queryName = queryName;
            return this;
        }

        public Builder mutationName(String mutationName) {
            this.mutationName = mutationName;
            return this;
        }

        public Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public Schema build() {
            if (this.queryName == null) {
                this.queryName = Schema.QUERY;
            }
            if (this.mutationName == null) {
                this.mutationName = Schema.MUTATION;
            }
            if (this.subscriptionName == null) {
                this.subscriptionName = Schema.SUBSCRIPTION;
            }
            return new Schema(this);
        }
    }
}

