/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLScalarType;
import io.helidon.microprofile.graphql.server.CustomScalars;
import io.helidon.microprofile.graphql.server.DataFetcherUtils;
import io.helidon.microprofile.graphql.server.FormattingHelper;
import io.helidon.microprofile.graphql.server.JandexUtils;
import io.helidon.microprofile.graphql.server.Schema;
import io.helidon.microprofile.graphql.server.SchemaArgument;
import io.helidon.microprofile.graphql.server.SchemaEnum;
import io.helidon.microprofile.graphql.server.SchemaFieldDefinition;
import io.helidon.microprofile.graphql.server.SchemaGeneratorHelper;
import io.helidon.microprofile.graphql.server.SchemaInputType;
import io.helidon.microprofile.graphql.server.SchemaScalar;
import io.helidon.microprofile.graphql.server.SchemaType;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbProperty;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.Enum;
import org.eclipse.microprofile.graphql.GraphQLApi;
import org.eclipse.microprofile.graphql.Id;
import org.eclipse.microprofile.graphql.Input;
import org.eclipse.microprofile.graphql.Interface;
import org.eclipse.microprofile.graphql.Mutation;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;
import org.eclipse.microprofile.graphql.Query;
import org.eclipse.microprofile.graphql.Source;

class SchemaGenerator {
    protected static final String IS = "is";
    protected static final String GET = "get";
    protected static final String SET = "set";
    private static final Logger LOGGER = Logger.getLogger(SchemaGenerator.class.getName());
    private JandexUtils jandexUtils;
    private Set<String> setUnresolvedTypes = new HashSet<String>();
    private Set<SchemaGeneratorHelper.DiscoveredMethod> setAdditionalMethods = new HashSet<SchemaGeneratorHelper.DiscoveredMethod>();
    private final Set<Class<?>> collectedApis = new HashSet();

    private SchemaGenerator(Builder builder) {
        this.collectedApis.addAll(builder.collectedApis);
        this.jandexUtils = JandexUtils.create();
        this.jandexUtils.loadIndexes();
        if (!this.jandexUtils.hasIndex()) {
            String message = "Unable to find or load jandex index files: " + this.jandexUtils.getIndexFile() + ".\nEnsure you are using the jandex-maven-plugin when you are building your application";
            LOGGER.warning(message);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Schema generateSchema() {
        int count;
        LOGGER.info("Discovered " + count + " annotated GraphQL API class" + ((count = this.collectedApis.size()) != 1 ? "es" : ""));
        try {
            return this.generateSchemaFromClasses(this.collectedApis);
        }
        catch (IntrospectionException | ClassNotFoundException e) {
            throw new IllegalStateException("Cannot generate schema", e);
        }
    }

    protected Schema generateSchemaFromClasses(Set<Class<?>> clazzes) throws IntrospectionException, ClassNotFoundException {
        Schema schema = Schema.create();
        this.setUnresolvedTypes.clear();
        this.setAdditionalMethods.clear();
        SchemaType rootQueryType = SchemaType.builder().name(schema.getQueryName()).build();
        SchemaType rootMutationType = SchemaType.builder().name(schema.getMutationName()).build();
        for (Class<?> clazz : clazzes) {
            if (!clazz.isInterface() && (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()))) continue;
            if (clazz.isAnnotationPresent(Enum.class)) {
                schema.addEnum(this.generateEnum(clazz));
                continue;
            }
            org.eclipse.microprofile.graphql.Type typeAnnotation = clazz.getAnnotation(org.eclipse.microprofile.graphql.Type.class);
            Interface interfaceAnnotation = clazz.getAnnotation(Interface.class);
            Input inputAnnotation = clazz.getAnnotation(Input.class);
            if (typeAnnotation != null && inputAnnotation != null) {
                SchemaGeneratorHelper.ensureConfigurationException(LOGGER, "Class " + clazz.getName() + " has been annotated with both Type and Input");
            }
            if (typeAnnotation != null || interfaceAnnotation != null) {
                if (interfaceAnnotation != null && !clazz.isInterface()) {
                    SchemaGeneratorHelper.ensureConfigurationException(LOGGER, "Class " + clazz.getName() + " has been annotated with @Interface but is not one");
                }
                String typeName = SchemaGeneratorHelper.getTypeName(clazz, true);
                SchemaType type = SchemaType.builder().name(typeName.isBlank() ? clazz.getSimpleName() : typeName).valueClassName(clazz.getName()).build();
                type.isInterface(clazz.isInterface());
                type.description(SchemaGeneratorHelper.getDescription(clazz.getAnnotation(Description.class)));
                this.addTypeToSchema(schema, type);
                if (type.isInterface()) {
                    this.jandexUtils.getKnownImplementors(clazz.getName()).forEach(c -> this.setUnresolvedTypes.add(c.getName()));
                }
            } else if (inputAnnotation != null) {
                String clazzName = clazz.getName();
                String simpleName = clazz.getSimpleName();
                SchemaInputType inputType = this.generateType(clazzName, true).createInputType("");
                if (inputType.name().equals(simpleName)) {
                    inputType.name(inputType.name() + "Input");
                }
                if (!schema.containsInputTypeWithName(inputType.name())) {
                    schema.addInputType(inputType);
                    this.checkInputType(schema, inputType);
                }
            }
            if (!clazz.isAnnotationPresent(GraphQLApi.class)) continue;
            this.processGraphQLApiAnnotations(rootQueryType, rootMutationType, schema, clazz);
        }
        schema.addType(rootQueryType);
        schema.addType(rootMutationType);
        this.processUnresolvedTypes(schema);
        schema.getTypes().stream().filter(SchemaType::isInterface).forEach(it -> schema.getTypes().stream().filter(t -> !t.isInterface() && t.valueClassName() != null).forEach(type -> {
            Class<?> interfaceClass = SchemaGeneratorHelper.getSafeClass(it.valueClassName());
            Class<?> typeClass = SchemaGeneratorHelper.getSafeClass(type.valueClassName());
            if (interfaceClass != null && typeClass != null && interfaceClass.isAssignableFrom(typeClass)) {
                type.implementingInterface(it.name());
            }
        }));
        for (SchemaGeneratorHelper.DiscoveredMethod dm : this.setAdditionalMethods) {
            String returnType;
            SchemaType type = schema.getTypeByClass(dm.source());
            if (type == null) continue;
            SchemaFieldDefinition fd = this.newFieldDefinition(dm, null);
            if (dm.arguments().size() > 0) {
                dm.arguments().stream().filter(a -> !a.isSourceArgument()).forEach(fd::addArgument);
            }
            fd.dataFetcher(DataFetcherUtils.newMethodDataFetcher(schema, dm.method().getDeclaringClass(), dm.method(), dm.source(), fd.arguments().toArray(new SchemaArgument[0])));
            type.addFieldDefinition(fd);
            String simpleName = SchemaGeneratorHelper.getSimpleName(fd.returnType(), true);
            if (simpleName.equals(returnType = fd.returnType())) continue;
            this.updateLongTypes(schema, returnType, simpleName);
        }
        this.processDefaultDateTimeValues(schema);
        if (rootQueryType.fieldDefinitions().size() == 0 && rootMutationType.fieldDefinitions().size() == 0) {
            LOGGER.warning("Unable to find any classes with @GraphQLApi annotation.Unable to build schema");
        }
        return schema;
    }

    private void processDefaultDateTimeValues(Schema schema) {
        Stream<SchemaType> streamInputTypes = schema.getInputTypes().stream().map(it -> it);
        Stream<SchemaType> streamAll = Stream.concat(streamInputTypes, schema.getTypes().stream());
        streamAll.forEach(t -> t.fieldDefinitions().forEach(fd -> {
            String returnType = fd.returnType();
            if (SchemaGeneratorHelper.isDateTimeScalar(returnType) && (t.name().equals("Query") || fd.dataFetcher() == null)) {
                Object[] existingFormat = fd.format();
                Class<?> clazzOriginalType = fd.originalArrayType() != null ? fd.originalArrayType() : fd.originalType();
                Object[] newFormat = SchemaGeneratorHelper.ensureFormat(returnType, clazzOriginalType.getName(), (String[])existingFormat);
                if (!Arrays.equals(newFormat, existingFormat) && newFormat.length == 2) {
                    fd.format((String[])newFormat);
                    if (fd.dataFetcher() == null) {
                        DataFetcher<?> dataFetcher = this.retrieveFormattingDataFetcher(new String[]{"Date", newFormat[0], newFormat[1]}, fd.name(), clazzOriginalType.getName());
                        fd.dataFetcher(dataFetcher);
                    }
                    fd.defaultFormatApplied(true);
                    SchemaScalar scalar = schema.getScalarByName(fd.returnType());
                    GraphQLScalarType newScalarType = null;
                    if (fd.returnType().equals("FormattedDate")) {
                        fd.returnType("Date");
                        newScalarType = CustomScalars.CUSTOM_DATE_SCALAR;
                    } else if (fd.returnType().equals("FormattedTime")) {
                        fd.returnType("Time");
                        newScalarType = CustomScalars.CUSTOM_TIME_SCALAR;
                    } else if (fd.returnType().equals("FormattedDateTime")) {
                        fd.returnType("DateTime");
                        newScalarType = CustomScalars.CUSTOM_DATE_TIME_SCALAR;
                    } else if (fd.returnType().equals("FormattedOffsetDateTime")) {
                        fd.returnType("FormattedOffsetDateTime");
                        newScalarType = CustomScalars.CUSTOM_OFFSET_DATE_TIME_SCALAR;
                    } else if (fd.returnType().equals("FormattedZonedDateTime")) {
                        fd.returnType("FormattedZonedDateTime");
                        newScalarType = CustomScalars.CUSTOM_ZONED_DATE_TIME_SCALAR;
                    }
                    SchemaScalar newScalar = new SchemaScalar(fd.returnType(), scalar.actualClass(), newScalarType, scalar.defaultFormat());
                    if (!schema.containsScalarWithName(newScalar.name())) {
                        schema.addScalar(newScalar);
                    }
                }
            }
            fd.arguments().forEach(a -> {
                String argumentType = a.argumentType();
                if (SchemaGeneratorHelper.isDateTimeScalar(argumentType)) {
                    Object[] existingArgFormat = a.format();
                    Class<?> clazzOriginalType = a.originalArrayType() != null ? a.originalArrayType() : a.originalType();
                    Object[] newArgFormat = SchemaGeneratorHelper.ensureFormat(argumentType, clazzOriginalType.getName(), (String[])existingArgFormat);
                    if (!Arrays.equals(newArgFormat, existingArgFormat) && newArgFormat.length == 2) {
                        a.format((String[])newArgFormat);
                    }
                }
            });
        }));
    }

    private void processUnresolvedTypes(Schema schema) {
        while (this.setUnresolvedTypes.size() > 0) {
            String returnType = this.setUnresolvedTypes.iterator().next();
            this.setUnresolvedTypes.remove(returnType);
            try {
                boolean fExists;
                String simpleName = SchemaGeneratorHelper.getSimpleName(returnType, true);
                SchemaScalar scalar = SchemaGeneratorHelper.getScalar(returnType);
                if (scalar != null) {
                    if (!schema.containsScalarWithName(scalar.name())) {
                        schema.addScalar(scalar);
                    }
                    this.updateLongTypes(schema, returnType, scalar.name());
                    continue;
                }
                if (SchemaGeneratorHelper.isEnumClass(returnType)) {
                    SchemaEnum newEnum = this.generateEnum(Class.forName(returnType));
                    if (!schema.containsEnumWithName(simpleName)) {
                        schema.addEnum(newEnum);
                    }
                    this.updateLongTypes(schema, returnType, newEnum.name());
                    continue;
                }
                boolean bl = fExists = schema.getTypes().stream().filter(t -> t.name().equals(simpleName)).count() > 0L;
                if (!fExists) {
                    SchemaType newType = this.generateType(returnType, false);
                    SchemaGeneratorHelper.checkScalars(schema, newType);
                    schema.addType(newType);
                }
                this.updateLongTypes(schema, returnType, simpleName);
            }
            catch (Exception e) {
                SchemaGeneratorHelper.ensureConfigurationException(LOGGER, "Cannot get GraphQL type for " + returnType, e);
            }
        }
    }

    private SchemaType generateType(String realReturnType, boolean isInputType) throws IntrospectionException, ClassNotFoundException {
        String simpleName = SchemaGeneratorHelper.getSimpleName(realReturnType, !isInputType);
        SchemaType type = SchemaType.builder().name(simpleName).valueClassName(realReturnType).build();
        type.description(SchemaGeneratorHelper.getDescription(Class.forName(realReturnType).getAnnotation(Description.class)));
        for (Map.Entry<String, SchemaGeneratorHelper.DiscoveredMethod> entry : this.retrieveGetterBeanMethods(Class.forName(realReturnType), isInputType).entrySet()) {
            SchemaGeneratorHelper.DiscoveredMethod discoveredMethod = entry.getValue();
            String valueTypeName = discoveredMethod.returnType();
            SchemaFieldDefinition fd = this.newFieldDefinition(discoveredMethod, null);
            type.addFieldDefinition(fd);
            if ("ID".equals(valueTypeName) || !valueTypeName.equals(fd.returnType())) continue;
            this.setUnresolvedTypes.add(valueTypeName);
        }
        return type;
    }

    private void processGraphQLApiAnnotations(SchemaType rootQueryType, SchemaType rootMutationType, Schema schema, Class<?> clazz) throws IntrospectionException, ClassNotFoundException {
        for (Map.Entry<String, SchemaGeneratorHelper.DiscoveredMethod> entry : this.retrieveAllAnnotatedBeanMethods(clazz).entrySet()) {
            SchemaGeneratorHelper.DiscoveredMethod discoveredMethod = entry.getValue();
            Method method = discoveredMethod.method();
            SchemaFieldDefinition fd = null;
            String source = discoveredMethod.source();
            if (source == null || discoveredMethod.isQueryAnnotated()) {
                fd = this.newFieldDefinition(discoveredMethod, SchemaGeneratorHelper.getMethodName(method));
            }
            if (source != null) {
                String additionReturnType = SchemaGeneratorHelper.getGraphQLType(discoveredMethod.returnType());
                this.setAdditionalMethods.add(discoveredMethod);
                if (!SchemaGeneratorHelper.isGraphQLType(additionReturnType)) {
                    this.setUnresolvedTypes.add(additionReturnType);
                }
            }
            SchemaType schemaType = discoveredMethod.methodType() == 0 ? rootQueryType : rootMutationType;
            for (SchemaArgument a : discoveredMethod.arguments()) {
                String originalTypeName = a.argumentType();
                String typeName = SchemaGeneratorHelper.getGraphQLType(originalTypeName);
                a.argumentType(typeName);
                String returnType = a.argumentType();
                if (originalTypeName.equals(returnType) && !"ID".equals(returnType) && !a.isDataFetchingEnvironment()) {
                    if (SchemaGeneratorHelper.getScalar(returnType) != null || SchemaGeneratorHelper.isEnumClass(returnType)) {
                        this.setUnresolvedTypes.add(returnType);
                    } else {
                        SchemaInputType inputType = this.generateType(returnType, true).createInputType("");
                        if (inputType.name().equals(Class.forName(returnType).getSimpleName())) {
                            inputType.name(inputType.name() + "Input");
                        }
                        if (!schema.containsInputTypeWithName(inputType.name())) {
                            schema.addInputType(inputType);
                            this.checkInputType(schema, inputType);
                        }
                        a.argumentType(inputType.name());
                    }
                }
                if (fd == null) continue;
                fd.addArgument(a);
            }
            if (fd == null) continue;
            DataFetcher dataFetcher = null;
            String[] format = discoveredMethod.format();
            SchemaScalar dateScalar = SchemaGeneratorHelper.getScalar(discoveredMethod.returnType());
            if (dateScalar != null && SchemaGeneratorHelper.isDateTimeScalar(dateScalar.name()) && SchemaGenerator.isFormatEmpty(format)) {
                Class<?> originalType = fd.isArrayReturnType() ? fd.originalArrayType() : fd.originalType();
                String[] newFormat = SchemaGeneratorHelper.ensureFormat(dateScalar.name(), originalType.getName(), new String[2]);
                if (newFormat.length == 2) {
                    format = new String[]{"Date", newFormat[0], newFormat[1]};
                }
            }
            if (!SchemaGenerator.isFormatEmpty(format)) {
                String graphQLType = SchemaGeneratorHelper.getGraphQLType(fd.returnType());
                DataFetcher methodDataFetcher = DataFetcherUtils.newMethodDataFetcher(schema, clazz, method, null, fd.arguments().toArray(new SchemaArgument[0]));
                String[] newFormat = new String[]{format[0], format[1], format[2]};
                if (dateScalar != null && SchemaGeneratorHelper.isDateTimeScalar(dateScalar.name())) {
                    dataFetcher = DataFetcherFactories.wrapDataFetcher(methodDataFetcher, (e, v) -> {
                        DateTimeFormatter dateTimeFormatter = FormattingHelper.getCorrectDateFormatter(graphQLType, newFormat[2], newFormat[1]);
                        return dateTimeFormatter == null ? FormattingHelper.formatDate(v, new SimpleDateFormat(newFormat[1])) : FormattingHelper.formatDate(v, dateTimeFormatter);
                    });
                } else {
                    dataFetcher = DataFetcherFactories.wrapDataFetcher(methodDataFetcher, (e, v) -> {
                        NumberFormat numberFormat = FormattingHelper.getCorrectNumberFormat(graphQLType, newFormat[2], newFormat[1]);
                        boolean isScalar = SchemaGeneratorHelper.getScalar(discoveredMethod.returnType()) != null;
                        return FormattingHelper.formatNumber(v, isScalar, numberFormat);
                    });
                    fd.returnType("String");
                }
            } else {
                dataFetcher = DataFetcherUtils.newMethodDataFetcher(schema, clazz, method, null, fd.arguments().toArray(new SchemaArgument[0]));
            }
            fd.dataFetcher(dataFetcher);
            fd.description(discoveredMethod.description());
            schemaType.addFieldDefinition(fd);
            SchemaGeneratorHelper.checkScalars(schema, schemaType);
            String returnType = discoveredMethod.returnType();
            if (!returnType.equals(fd.returnType()) || this.setUnresolvedTypes.contains(returnType) || "ID".equals(returnType)) continue;
            this.setUnresolvedTypes.add(returnType);
        }
    }

    protected static boolean isFormatEmpty(String[] format) {
        if (format == null || format.length == 0) {
            return true;
        }
        for (String entry : format) {
            if (entry != null) continue;
            return true;
        }
        return false;
    }

    private void checkInputType(Schema schema, SchemaInputType schemaInputType) throws IntrospectionException, ClassNotFoundException {
        HashSet<SchemaInputType> setInputTypes = new HashSet<SchemaInputType>();
        setInputTypes.add(schemaInputType);
        while (setInputTypes.size() > 0) {
            SchemaInputType type = (SchemaInputType)setInputTypes.iterator().next();
            setInputTypes.remove(type);
            for (SchemaFieldDefinition fdi : type.fieldDefinitions()) {
                String fdReturnType = fdi.returnType();
                if (SchemaGeneratorHelper.isGraphQLType(fdReturnType)) continue;
                if (SchemaGeneratorHelper.getScalar(fdReturnType) != null || SchemaGeneratorHelper.isEnumClass(fdReturnType)) {
                    this.setUnresolvedTypes.add(fdReturnType);
                    continue;
                }
                SchemaInputType newInputType = this.generateType(fdReturnType, true).createInputType("");
                if (newInputType.name().equals(Class.forName(newInputType.valueClassName()).getSimpleName())) {
                    newInputType.name(newInputType.name() + "Input");
                }
                if (!schema.containsInputTypeWithName(newInputType.name())) {
                    schema.addInputType(newInputType);
                    setInputTypes.add(newInputType);
                }
                fdi.returnType(newInputType.name());
            }
        }
    }

    private void addTypeToSchema(Schema schema, SchemaType type) throws IntrospectionException, ClassNotFoundException {
        String valueClassName = type.valueClassName();
        this.retrieveGetterBeanMethods(Class.forName(valueClassName), false).forEach((k, v) -> {
            SchemaFieldDefinition fd = this.newFieldDefinition((SchemaGeneratorHelper.DiscoveredMethod)v, null);
            type.addFieldDefinition(fd);
            SchemaGeneratorHelper.checkScalars(schema, type);
            String returnType = v.returnType();
            if (!"ID".equals(returnType) && returnType.equals(fd.returnType()) && !this.setUnresolvedTypes.contains(returnType)) {
                this.setUnresolvedTypes.add(returnType);
            }
        });
        if (type.isInterface()) {
            Collection<Class<?>> setConcreteClasses = this.jandexUtils.getKnownImplementors(valueClassName);
            setConcreteClasses.forEach(c -> this.setUnresolvedTypes.add(c.getName()));
        }
        schema.addType(type);
    }

    private SchemaEnum generateEnum(Class<?> clazz) {
        if (clazz.isEnum()) {
            SchemaEnum newSchemaEnum = SchemaEnum.builder().name(SchemaGeneratorHelper.getTypeName(clazz)).build();
            Arrays.stream(clazz.getEnumConstants()).map(Object::toString).forEach(newSchemaEnum::addValue);
            return newSchemaEnum;
        }
        return null;
    }

    private SchemaFieldDefinition newFieldDefinition(SchemaGeneratorHelper.DiscoveredMethod discoveredMethod, String optionalName) {
        boolean isArrayReturnType;
        String valueClassName = discoveredMethod.returnType();
        String graphQLType = SchemaGeneratorHelper.getGraphQLType(valueClassName);
        DataFetcher dataFetcher = null;
        String propertyName = discoveredMethod.propertyName();
        String name = discoveredMethod.name();
        boolean bl = isArrayReturnType = discoveredMethod.isArrayReturnType() || discoveredMethod.isCollectionType() || discoveredMethod.isMap();
        if (isArrayReturnType && discoveredMethod.isMap()) {
            dataFetcher = DataFetcherUtils.newMapValuesDataFetcher(propertyName);
        }
        String[] format = discoveredMethod.format();
        if (propertyName != null && !SchemaGenerator.isFormatEmpty(format)) {
            if (!SchemaGeneratorHelper.isGraphQLType(valueClassName)) {
                dataFetcher = this.retrieveFormattingDataFetcher(format, propertyName, graphQLType);
                if ("Number".equals(format[0])) {
                    graphQLType = "String";
                }
            }
        } else if (propertyName != null && !propertyName.equals(name)) {
            dataFetcher = new DataFetcher(propertyName);
        }
        SchemaFieldDefinition fd = SchemaFieldDefinition.builder().name(optionalName != null ? optionalName : discoveredMethod.name()).returnType(graphQLType).arrayReturnType(isArrayReturnType).returnTypeMandatory(discoveredMethod.isReturnTypeMandatory()).arrayLevels(discoveredMethod.arrayLevels()).dataFetcher(dataFetcher).originalType(discoveredMethod.method().getReturnType()).arrayReturnTypeMandatory(discoveredMethod.isArrayReturnTypeMandatory()).originalArrayType(isArrayReturnType ? discoveredMethod.originalArrayType() : null).build();
        if (format != null && format.length == 3) {
            fd.format(new String[]{format[1], format[2]});
        }
        fd.description(discoveredMethod.description());
        fd.jsonbFormat(discoveredMethod.isJsonbFormat());
        fd.defaultValue(discoveredMethod.defaultValue());
        fd.jsonbProperty(discoveredMethod.isJsonbProperty());
        return fd;
    }

    private DataFetcher<?> retrieveFormattingDataFetcher(String[] rawFormat, String propertyName, String type) {
        return "Number".equals(rawFormat[0]) ? new DataFetcherUtils.NumberFormattingDataFetcher(propertyName, type, rawFormat[1], rawFormat[2]) : new DataFetcherUtils.DateFormattingDataFetcher(propertyName, type, rawFormat[1], rawFormat[2]);
    }

    private void updateLongTypes(Schema schema, String longReturnType, String shortReturnType) {
        Stream<SchemaType> streamInputTypes = schema.getInputTypes().stream().map(it -> it);
        Stream<SchemaType> streamAll = Stream.concat(streamInputTypes, schema.getTypes().stream());
        streamAll.forEach(t -> t.fieldDefinitions().forEach(fd -> {
            if (fd.returnType().equals(longReturnType)) {
                fd.returnType(shortReturnType);
            }
            fd.arguments().forEach(a -> {
                if (a.argumentType().equals(longReturnType)) {
                    a.argumentType(shortReturnType);
                }
            });
        }));
        this.setAdditionalMethods.forEach(m -> m.arguments().forEach(a -> {
            if (a.argumentType().equals(longReturnType)) {
                a.argumentType(shortReturnType);
            }
        }));
    }

    protected Map<String, SchemaGeneratorHelper.DiscoveredMethod> retrieveAllAnnotatedBeanMethods(Class<?> clazz) throws IntrospectionException, ClassNotFoundException {
        HashMap<String, SchemaGeneratorHelper.DiscoveredMethod> mapDiscoveredMethods = new HashMap<String, SchemaGeneratorHelper.DiscoveredMethod>();
        for (Method m : this.getAllMethods(clazz)) {
            boolean isQuery = m.getAnnotation(Query.class) != null;
            boolean isMutation = m.getAnnotation(Mutation.class) != null;
            boolean hasSourceAnnotation = Arrays.stream(m.getParameters()).anyMatch(p -> p.getAnnotation(Source.class) != null);
            if (isMutation && isQuery) {
                SchemaGeneratorHelper.ensureConfigurationException(LOGGER, "The class " + clazz.getName() + " may not have both a Query and Mutation annotation");
            }
            if (!isQuery && !isMutation && !hasSourceAnnotation) continue;
            SchemaGeneratorHelper.DiscoveredMethod discoveredMethod = this.generateDiscoveredMethod(m, clazz, null, false, true);
            discoveredMethod.methodType(isQuery || hasSourceAnnotation ? 0 : 1);
            String name = discoveredMethod.name();
            if (mapDiscoveredMethods.containsKey(name)) {
                SchemaGeneratorHelper.ensureConfigurationException(LOGGER, "A method named " + name + " already exists on the " + (isMutation ? "mutation" : "query") + " " + discoveredMethod.method().getName());
            }
            mapDiscoveredMethods.put(name, discoveredMethod);
        }
        return mapDiscoveredMethods;
    }

    protected Map<String, SchemaGeneratorHelper.DiscoveredMethod> retrieveGetterBeanMethods(Class<?> clazz, boolean isInputType) throws IntrospectionException, ClassNotFoundException {
        HashMap<String, SchemaGeneratorHelper.DiscoveredMethod> mapDiscoveredMethods = new HashMap<String, SchemaGeneratorHelper.DiscoveredMethod>();
        for (Method m : this.getAllMethods(clazz)) {
            boolean ignoreWriteMethod;
            Optional<PropertyDescriptor> optionalPdReadMethod;
            if (m.getName().equals("getClass") || SchemaGeneratorHelper.shouldIgnoreMethod(m, isInputType) || !(optionalPdReadMethod = Arrays.stream(Introspector.getBeanInfo(clazz).getPropertyDescriptors()).filter(p -> p.getReadMethod() != null && p.getReadMethod().getName().equals(m.getName())).findFirst()).isPresent()) continue;
            PropertyDescriptor propertyDescriptor = optionalPdReadMethod.get();
            Method writeMethod = propertyDescriptor.getWriteMethod();
            boolean bl = ignoreWriteMethod = isInputType && writeMethod != null && SchemaGeneratorHelper.shouldIgnoreMethod(writeMethod, true);
            if (SchemaGeneratorHelper.shouldIgnoreField(clazz, propertyDescriptor.getName()) || ignoreWriteMethod) continue;
            SchemaGeneratorHelper.DiscoveredMethod discoveredMethod = this.generateDiscoveredMethod(m, clazz, propertyDescriptor, isInputType, false);
            mapDiscoveredMethods.put(discoveredMethod.name(), discoveredMethod);
        }
        return mapDiscoveredMethods;
    }

    protected List<Method> getAllMethods(Class<?> clazz) throws IntrospectionException {
        return Arrays.asList(Introspector.getBeanInfo(clazz).getMethodDescriptors()).stream().map(MethodDescriptor::getMethod).collect(Collectors.toList());
    }

    private SchemaGeneratorHelper.DiscoveredMethod generateDiscoveredMethod(Method method, Class<?> clazz, PropertyDescriptor pd, boolean isInputType, boolean isQueryOrMutation) throws ClassNotFoundException {
        String[] format = new String[]{};
        String description = null;
        boolean isReturnTypeMandatory = false;
        boolean isArrayReturnTypeMandatory = false;
        boolean isJsonbFormat = false;
        String defaultValue = null;
        String varName = SchemaGeneratorHelper.stripMethodName(method, !isQueryOrMutation);
        String annotatedName = SchemaGeneratorHelper.getMethodName(isInputType ? pd.getWriteMethod() : method);
        if (annotatedName != null) {
            varName = annotatedName;
        } else if (pd != null && (annotatedName = SchemaGeneratorHelper.getFieldName(clazz, pd.getName())) != null) {
            varName = annotatedName;
        }
        Method methodToCheck = isInputType ? pd.getWriteMethod() : method;
        boolean isJsonbProperty = methodToCheck != null && methodToCheck.getAnnotation(JsonbProperty.class) != null;
        SchemaGeneratorHelper.ensureValidName(LOGGER, varName);
        Class<?> returnClazz = method.getReturnType();
        String returnClazzName = returnClazz.getName();
        this.ensureNonVoidQueryOrMutation(returnClazzName, method, clazz);
        if (pd != null) {
            boolean fieldHasIdAnnotation = false;
            Field field = null;
            try {
                field = clazz.getDeclaredField(pd.getName());
                fieldHasIdAnnotation = field != null && field.getAnnotation(Id.class) != null;
                description = SchemaGeneratorHelper.getDescription(field.getAnnotation(Description.class));
                defaultValue = isInputType ? SchemaGeneratorHelper.getDefaultValueAnnotationValue(field) : null;
                NonNull nonNullAnnotation = field.getAnnotation(NonNull.class);
                boolean bl = isArrayReturnTypeMandatory = SchemaGeneratorHelper.getAnnotationValue(SchemaGeneratorHelper.getFieldAnnotations(field, 0), NonNull.class) != null;
                if (isInputType) {
                    Method writeMethod = pd.getWriteMethod();
                    if (writeMethod != null) {
                        String[] argumentTypeFormat;
                        Parameter[] parameters;
                        String[] writeMethodFormat;
                        boolean isSetArrayMandatory;
                        NonNull methodAnnotation;
                        String writeMethodDefaultValue;
                        String methodDescription = SchemaGeneratorHelper.getDescription(writeMethod.getAnnotation(Description.class));
                        if (methodDescription != null) {
                            description = methodDescription;
                        }
                        if ((writeMethodDefaultValue = SchemaGeneratorHelper.getDefaultValueAnnotationValue(writeMethod)) != null) {
                            defaultValue = writeMethodDefaultValue;
                        }
                        if ((methodAnnotation = writeMethod.getAnnotation(NonNull.class)) != null) {
                            nonNullAnnotation = methodAnnotation;
                        }
                        boolean bl2 = isSetArrayMandatory = SchemaGeneratorHelper.getAnnotationValue(SchemaGeneratorHelper.getParameterAnnotations(writeMethod.getParameters()[0], 0), NonNull.class) != null;
                        if (isSetArrayMandatory && !isArrayReturnTypeMandatory) {
                            isArrayReturnTypeMandatory = true;
                        }
                        if (!SchemaGenerator.isFormatEmpty(writeMethodFormat = FormattingHelper.getFormattingAnnotation(writeMethod))) {
                            format = writeMethodFormat;
                            isJsonbFormat = FormattingHelper.isJsonbAnnotationPresent(writeMethod);
                            boolean bl3 = isJsonbProperty = writeMethod.getAnnotation(JsonbProperty.class) != null;
                        }
                        if ((parameters = writeMethod.getParameters()).length == 1 && !SchemaGenerator.isFormatEmpty(argumentTypeFormat = FormattingHelper.getMethodParameterFormat(parameters[0], 0))) {
                            format = argumentTypeFormat;
                            isJsonbFormat = FormattingHelper.isJsonbAnnotationPresent(parameters[0]);
                            isJsonbProperty = parameters[0].getAnnotation(JsonbProperty.class) != null;
                        }
                    }
                } else {
                    NonNull methodAnnotation = method.getAnnotation(NonNull.class);
                    if (methodAnnotation != null) {
                        nonNullAnnotation = methodAnnotation;
                    }
                    if (!isArrayReturnTypeMandatory) {
                        isArrayReturnTypeMandatory = SchemaGeneratorHelper.getAnnotationValue(SchemaGeneratorHelper.getMethodAnnotations(method, 0), NonNull.class) != null;
                    }
                }
                isReturnTypeMandatory = SchemaGeneratorHelper.isPrimitive(returnClazzName) && defaultValue == null || nonNullAnnotation != null && defaultValue == null;
            }
            catch (NoSuchFieldException ignored) {
                LOGGER.fine("No such field " + pd.getName() + " on class " + clazz.getName());
            }
            if (fieldHasIdAnnotation || method.getAnnotation(Id.class) != null) {
                SchemaGeneratorHelper.validateIDClass(returnClazz);
                returnClazzName = "ID";
            }
            if (field != null && SchemaGenerator.isFormatEmpty(format)) {
                format = FormattingHelper.getFormattingAnnotation(field);
                if (SchemaGenerator.isFormatEmpty(format)) {
                    format = FormattingHelper.getFieldFormat(field, 0);
                }
                isJsonbFormat = FormattingHelper.isJsonbAnnotationPresent(field);
            }
        } else {
            defaultValue = SchemaGeneratorHelper.getDefaultValueAnnotationValue(method);
            boolean bl = isReturnTypeMandatory = SchemaGeneratorHelper.isPrimitive(returnClazzName) && defaultValue == null || method.getAnnotation(NonNull.class) != null && defaultValue == null;
            if (method.getAnnotation(Id.class) != null) {
                SchemaGeneratorHelper.validateIDClass(returnClazz);
                returnClazzName = "ID";
            }
        }
        String[] methodFormat = FormattingHelper.getFormattingAnnotation(method);
        if (methodFormat[0] != null && !isInputType) {
            format = methodFormat;
        }
        SchemaGeneratorHelper.DiscoveredMethod discoveredMethod = SchemaGeneratorHelper.DiscoveredMethod.builder().name(varName).method(method).format(format).defaultValue(defaultValue).jsonbFormat(isJsonbFormat).jsonbProperty(isJsonbProperty).propertyName(pd != null ? pd.getName() : null).build();
        if (description == null && !isInputType) {
            description = SchemaGeneratorHelper.getDescription(method.getAnnotation(Description.class));
        }
        this.processMethodParameters(method, discoveredMethod, annotatedName);
        ReturnType realReturnType = this.getReturnType(returnClazz, method.getGenericReturnType(), -1, method);
        this.processReturnType(discoveredMethod, realReturnType, returnClazzName, isInputType, varName, method);
        discoveredMethod.returnTypeMandatory(isReturnTypeMandatory);
        discoveredMethod.arrayReturnTypeMandatory(isArrayReturnTypeMandatory || realReturnType.isReturnTypeMandatory && !isInputType);
        discoveredMethod.description(description);
        return discoveredMethod;
    }

    private void ensureNonVoidQueryOrMutation(String returnClazzName, Method method, Class<?> clazz) {
        if ("void".equals(returnClazzName)) {
            SchemaGeneratorHelper.ensureConfigurationException(LOGGER, "void is not a valid return type for a Query or Mutation method '" + method.getName() + "' on class " + clazz.getName());
        }
    }

    private void processReturnType(SchemaGeneratorHelper.DiscoveredMethod discoveredMethod, ReturnType realReturnType, String returnClazzName, boolean isInputType, String varName, Method method) throws ClassNotFoundException {
        if (realReturnType.returnClass() != null && !"ID".equals(returnClazzName)) {
            Class<?> originalArrayType;
            discoveredMethod.arrayReturnType(realReturnType.isArrayType());
            discoveredMethod.collectionType(realReturnType.collectionType());
            discoveredMethod.map(realReturnType.isMap());
            SchemaScalar dateScalar = SchemaGeneratorHelper.getScalar(realReturnType.returnClass());
            if (dateScalar != null && SchemaGeneratorHelper.isDateTimeScalar(dateScalar.name())) {
                discoveredMethod.originalArrayType(Class.forName(realReturnType.returnClass));
            } else if (discoveredMethod.isArrayReturnType() && (originalArrayType = SchemaGeneratorHelper.getSafeClass(realReturnType.returnClass)) != null) {
                discoveredMethod.originalArrayType(originalArrayType);
            }
            discoveredMethod.returnType(realReturnType.returnClass());
            if (!isInputType && !SchemaGenerator.isFormatEmpty(realReturnType.format())) {
                discoveredMethod.format(realReturnType.format);
            }
        } else {
            discoveredMethod.name(varName);
            discoveredMethod.returnType(returnClazzName);
            discoveredMethod.method(method);
        }
        discoveredMethod.arrayLevels(realReturnType.arrayLevels());
    }

    private void processMethodParameters(Method method, SchemaGeneratorHelper.DiscoveredMethod discoveredMethod, String annotatedName) {
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameters.length > 0) {
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            int i = 0;
            for (Parameter parameter : parameters) {
                Source sourceAnnotation;
                boolean isID = false;
                Name paramNameAnnotation = parameter.getAnnotation(Name.class);
                String parameterName = paramNameAnnotation != null && !paramNameAnnotation.value().isBlank() ? paramNameAnnotation.value() : parameter.getName();
                Class<?> paramType = parameter.getType();
                ReturnType returnType = this.getReturnType(paramType, genericParameterTypes[i], i, method);
                if (parameter.getAnnotation(Id.class) != null) {
                    SchemaGeneratorHelper.validateIDClass(returnType.returnClass());
                    returnType.returnClass("ID");
                    isID = true;
                }
                String argumentDefaultValue = SchemaGeneratorHelper.getDefaultValueAnnotationValue(parameter);
                boolean isMandatory = SchemaGeneratorHelper.isPrimitive(paramType) && argumentDefaultValue == null || parameter.getAnnotation(NonNull.class) != null && argumentDefaultValue == null;
                SchemaArgument argument = SchemaArgument.builder().argumentName(parameterName).argumentType(returnType.returnClass()).mandatory(isMandatory).defaultValue(argumentDefaultValue).originalType(paramType).description(SchemaGeneratorHelper.getDescription(parameter.getAnnotation(Description.class))).dataFetchingEnvironment(paramType.equals(DataFetchingEnvironment.class)).build();
                String[] argumentFormat = FormattingHelper.getFormattingAnnotation(parameter);
                String[] argumentTypeFormat = FormattingHelper.getMethodParameterFormat(parameter, 0);
                String[] stringArray = argumentFormat = !SchemaGenerator.isFormatEmpty(argumentTypeFormat) ? argumentTypeFormat : argumentFormat;
                if (argumentFormat[0] != null) {
                    argument.format(new String[]{argumentFormat[1], argumentFormat[2]});
                    argument.argumentType(String.class.getName());
                }
                if ((sourceAnnotation = parameter.getAnnotation(Source.class)) != null) {
                    discoveredMethod.name(annotatedName != null ? annotatedName : SchemaGeneratorHelper.stripMethodName(method, false));
                    discoveredMethod.source(returnType.returnClass());
                    discoveredMethod.queryAnnotated(method.getAnnotation(Query.class) != null);
                    argument.sourceArgument(true);
                }
                if (!isID) {
                    SchemaScalar dateScalar = SchemaGeneratorHelper.getScalar(returnType.returnClass());
                    if (dateScalar != null && SchemaGeneratorHelper.isDateTimeScalar(dateScalar.name())) {
                        discoveredMethod.originalArrayType(SchemaGeneratorHelper.getSafeClass(returnType.returnClass));
                    }
                    argument.arrayReturnTypeMandatory(returnType.isReturnTypeMandatory);
                    argument.arrayReturnType(returnType.isArrayType);
                    if (returnType.isArrayType) {
                        argument.originalArrayType(SchemaGeneratorHelper.getSafeClass(returnType.returnClass));
                    }
                    argument.arrayLevels(returnType.arrayLevels());
                }
                discoveredMethod.addArgument(argument);
                ++i;
            }
        }
    }

    protected ReturnType getReturnType(Class<?> returnClazz, Type genericReturnType, int parameterNumber, Method method) {
        ReturnType actualReturnType = ReturnType.create();
        String returnClazzName = returnClazz.getName();
        boolean isCollection = Collection.class.isAssignableFrom(returnClazz);
        boolean isMap = Map.class.isAssignableFrom(returnClazz);
        if (isCollection || isMap) {
            if (isCollection) {
                actualReturnType.collectionType(returnClazzName);
            }
            actualReturnType.map(isMap);
            RootTypeResult rootTypeResult = this.getRootTypeName(genericReturnType, isCollection ? 0 : 1, parameterNumber, method);
            String rootType = rootTypeResult.rootTypeName();
            int arrayLevels = rootTypeResult.levels();
            if (SchemaGeneratorHelper.isArrayType(rootType)) {
                actualReturnType.returnClass(SchemaGeneratorHelper.getRootArrayClass(rootType));
                arrayLevels += SchemaGeneratorHelper.getArrayLevels(rootType);
            } else {
                actualReturnType.returnClass(rootType);
            }
            actualReturnType.arrayLevels(arrayLevels);
            actualReturnType.returnTypeMandatory(rootTypeResult.isArrayReturnTypeMandatory());
            actualReturnType.format(rootTypeResult.format);
            actualReturnType.arrayType(true);
        } else if (!returnClazzName.isEmpty() && returnClazzName.startsWith("[")) {
            actualReturnType.arrayType(true);
            actualReturnType.arrayLevels(SchemaGeneratorHelper.getArrayLevels(returnClazzName));
            actualReturnType.returnClass(SchemaGeneratorHelper.getRootArrayClass(returnClazzName));
        } else {
            actualReturnType.returnClass(returnClazzName);
        }
        return actualReturnType;
    }

    protected RootTypeResult getRootTypeName(Type genericReturnType, int index, int parameterNumber, Method method) {
        int level = 1;
        boolean isParameter = parameterNumber != -1;
        String[] format = FormattingHelper.NO_FORMATTING;
        RootTypeResult.Builder builder = RootTypeResult.builder();
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType paramReturnType = (ParameterizedType)genericReturnType;
            Type actualTypeArgument = paramReturnType.getActualTypeArguments()[index];
            while (actualTypeArgument instanceof ParameterizedType) {
                ++level;
                ParameterizedType parameterizedType2 = (ParameterizedType)actualTypeArgument;
                actualTypeArgument = parameterizedType2.getActualTypeArguments()[index];
            }
            Class<?> clazz = actualTypeArgument.getClass();
            boolean hasAnnotation = false;
            if (isParameter) {
                Parameter parameter = method.getParameters()[parameterNumber];
                hasAnnotation = SchemaGeneratorHelper.getAnnotationValue(SchemaGeneratorHelper.getParameterAnnotations(parameter, 0), NonNull.class) != null;
            } else {
                format = FormattingHelper.getMethodFormat(method, 0);
            }
            boolean isReturnTypeMandatory = hasAnnotation || SchemaGeneratorHelper.isPrimitive(clazz.getName());
            return builder.rootTypeName(((Class)actualTypeArgument).getName()).levels(level).arrayReturnTypeMandatory(isReturnTypeMandatory).format(format).build();
        }
        Class<?> clazz = genericReturnType.getClass();
        boolean isReturnTypeMandatory = clazz.getAnnotation(NonNull.class) != null || SchemaGeneratorHelper.isPrimitive(clazz.getName());
        return builder.rootTypeName(((Class)genericReturnType).getName()).levels(level).arrayReturnTypeMandatory(isReturnTypeMandatory).format(format).build();
    }

    protected JandexUtils getJandexUtils() {
        return this.jandexUtils;
    }

    public static class RootTypeResult {
        private final String rootTypeName;
        private final int levels;
        private boolean isArrayReturnTypeMandatory;
        private final String[] format;

        private RootTypeResult(Builder builder) {
            this.rootTypeName = builder.rootTypeName;
            this.levels = builder.levels;
            this.isArrayReturnTypeMandatory = builder.isArrayReturnTypeMandatory;
            this.format = builder.format;
        }

        public static Builder builder() {
            return new Builder();
        }

        public String rootTypeName() {
            return this.rootTypeName;
        }

        public int levels() {
            return this.levels;
        }

        public boolean isArrayReturnTypeMandatory() {
            return this.isArrayReturnTypeMandatory;
        }

        public String[] format() {
            if (this.format == null) {
                return null;
            }
            String[] copy = new String[this.format.length];
            System.arraycopy(this.format, 0, copy, 0, copy.length);
            return copy;
        }

        public static class Builder
        implements io.helidon.common.Builder<RootTypeResult> {
            private String rootTypeName;
            private int levels;
            private boolean isArrayReturnTypeMandatory;
            private String[] format;

            public Builder rootTypeName(String rootTypeName) {
                this.rootTypeName = rootTypeName;
                return this;
            }

            public Builder levels(int levels) {
                this.levels = levels;
                return this;
            }

            public Builder arrayReturnTypeMandatory(boolean isArrayReturnTypeMandatory) {
                this.isArrayReturnTypeMandatory = isArrayReturnTypeMandatory;
                return this;
            }

            public Builder format(String[] format) {
                if (format == null) {
                    this.format = null;
                } else {
                    this.format = new String[format.length];
                    System.arraycopy(format, 0, this.format, 0, this.format.length);
                }
                return this;
            }

            public RootTypeResult build() {
                return new RootTypeResult(this);
            }
        }
    }

    public static class ReturnType {
        private String returnClass;
        private boolean isArrayType = false;
        private boolean isMap = false;
        private String collectionType;
        private int arrayLevels = 0;
        private boolean isReturnTypeMandatory;
        private String[] format;

        private ReturnType() {
        }

        public static ReturnType create() {
            return new ReturnType();
        }

        public String returnClass() {
            return this.returnClass;
        }

        public void returnClass(String returnClass) {
            this.returnClass = returnClass;
        }

        public boolean isArrayType() {
            return this.isArrayType;
        }

        public void arrayType(boolean arrayType) {
            this.isArrayType = arrayType;
        }

        public boolean isMap() {
            return this.isMap;
        }

        public void map(boolean map) {
            this.isMap = map;
        }

        public String collectionType() {
            return this.collectionType;
        }

        public void collectionType(String collectionType) {
            this.collectionType = collectionType;
        }

        public int arrayLevels() {
            return this.arrayLevels;
        }

        public void arrayLevels(int arrayLevels) {
            this.arrayLevels = arrayLevels;
        }

        public boolean isReturnTypeMandatory() {
            return this.isReturnTypeMandatory;
        }

        public void returnTypeMandatory(boolean returnTypeMandatory) {
            this.isReturnTypeMandatory = returnTypeMandatory;
        }

        public String[] format() {
            if (this.format == null) {
                return null;
            }
            String[] copy = new String[this.format.length];
            System.arraycopy(this.format, 0, copy, 0, copy.length);
            return copy;
        }

        public void format(String[] format) {
            if (format == null) {
                this.format = null;
            } else {
                this.format = new String[format.length];
                System.arraycopy(format, 0, this.format, 0, this.format.length);
            }
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<SchemaGenerator> {
        private final Set<Class<?>> collectedApis = new HashSet();

        public SchemaGenerator build() {
            return new SchemaGenerator(this);
        }

        public Builder classes(Set<Class<?>> collectedApis) {
            this.collectedApis.addAll(collectedApis);
            return this;
        }
    }
}

