/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.graphql.server;

import io.helidon.microprofile.graphql.server.ElementGenerator;
import io.helidon.microprofile.graphql.server.SchemaArgument;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SchemaDirective
implements ElementGenerator {
    private final String name;
    private final List<SchemaArgument> listSchemaArguments;
    private final Set<String> setLocations;

    private SchemaDirective(Builder builder) {
        this.name = builder.name;
        this.listSchemaArguments = builder.listSchemaArguments;
        this.setLocations = builder.setLocations;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getSchemaAsString() {
        StringBuilder sb = new StringBuilder("directive @" + this.name());
        if (this.listSchemaArguments.size() > 0) {
            sb.append("(");
            AtomicBoolean isFirst = new AtomicBoolean(true);
            this.listSchemaArguments.forEach(a -> {
                String delim = isFirst.getAndSet(false) ? "" : ", ";
                sb.append(delim).append(a.argumentName()).append(": ").append(a.argumentType());
                if (a.mandatory()) {
                    sb.append('!');
                }
            });
            sb.append(")");
        }
        sb.append(" on ").append(((Stream)this.setLocations.stream().sequential()).collect(Collectors.joining("|")));
        return sb.toString();
    }

    public void addArgument(SchemaArgument schemaArgument) {
        this.listSchemaArguments.add(schemaArgument);
    }

    public void addLocation(String location) {
        this.setLocations.add(location);
    }

    public String name() {
        return this.name;
    }

    public List<SchemaArgument> arguments() {
        return this.listSchemaArguments;
    }

    public Set<String> locations() {
        return this.setLocations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaDirective schemaDirective = (SchemaDirective)o;
        return Objects.equals(this.name, schemaDirective.name) && Objects.equals(this.listSchemaArguments, schemaDirective.listSchemaArguments) && Objects.equals(this.setLocations, schemaDirective.setLocations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.listSchemaArguments, this.setLocations);
    }

    public String toString() {
        return "Directive{name='" + this.name + "', listArguments=" + this.listSchemaArguments + ", setLocations=" + this.setLocations + "}";
    }

    public static class Builder
    implements io.helidon.common.Builder<SchemaDirective> {
        private String name;
        private List<SchemaArgument> listSchemaArguments = new ArrayList<SchemaArgument>();
        private Set<String> setLocations = new LinkedHashSet<String>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addArgument(SchemaArgument argument) {
            this.listSchemaArguments.add(argument);
            return this;
        }

        public Builder addLocation(String location) {
            this.setLocations.add(location);
            return this;
        }

        public SchemaDirective build() {
            Objects.requireNonNull(this.name, "Name must be specified");
            return new SchemaDirective(this);
        }
    }
}

