/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jsonrpc.core;

import io.helidon.common.LazyValue;
import jakarta.json.Json;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class JsonUtil {
    public static final JsonBuilderFactory JSON_BUILDER_FACTORY = Json.createBuilderFactory(Map.of());
    static final LazyValue<Jsonb> JSONB_BUILDER = LazyValue.create(JsonbBuilder::create);
    static final LazyValue<JsonReaderFactory> JSON_READER_FACTORY = LazyValue.create(() -> Json.createReaderFactory(Map.of()));
    static final LazyValue<JsonWriterFactory> JSON_WRITER_FACTORY = LazyValue.create(() -> Json.createWriterFactory(Map.of()));

    private JsonUtil() {
    }

    public static JsonObject jsonbToJsonp(Object object) {
        Objects.requireNonNull(object, "json object is null");
        String serialized = ((Jsonb)JSONB_BUILDER.get()).toJson(object);
        ByteArrayInputStream stream = new ByteArrayInputStream(serialized.getBytes(StandardCharsets.UTF_8));
        try (JsonReader reader = ((JsonReaderFactory)JSON_READER_FACTORY.get()).createReader((InputStream)stream);){
            JsonObject jsonObject = reader.readValue().asJsonObject();
            return jsonObject;
        }
    }

    public static <T> T jsonpToJsonb(JsonObject object, Class<T> type) {
        Objects.requireNonNull(object, "json object is null");
        Objects.requireNonNull(type, "type is null");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (JsonWriter writer = ((JsonWriterFactory)JSON_WRITER_FACTORY.get()).createWriter((OutputStream)os, StandardCharsets.UTF_8);){
            writer.writeObject(object);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        return (T)((Jsonb)JSONB_BUILDER.get()).fromJson((InputStream)is, type);
    }
}

