/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jsonrpc.core;

import io.helidon.jsonrpc.core.JsonRpcParams;
import io.helidon.jsonrpc.core.JsonUtil;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.Objects;
import java.util.Optional;

class JsonRpcParamsImpl
implements JsonRpcParams {
    private final JsonStructure params;

    JsonRpcParamsImpl(JsonStructure params) {
        this.params = Objects.requireNonNull(params);
    }

    @Override
    public JsonStructure asJsonStructure() {
        return this.params;
    }

    @Override
    public JsonObject asJsonObject() {
        return this.params.asJsonObject();
    }

    @Override
    public JsonArray asJsonArray() {
        return this.params.asJsonArray();
    }

    @Override
    public JsonValue get(String name) {
        JsonValue value = (JsonValue)this.asJsonObject().get((Object)name);
        if (value == null) {
            throw new IllegalArgumentException("Unable to find param " + name);
        }
        return value;
    }

    @Override
    public String getString(String name) {
        return ((JsonString)this.get(name)).getString();
    }

    @Override
    public Optional<JsonValue> find(String name) {
        return Optional.ofNullable((JsonValue)this.asJsonObject().get((Object)name));
    }

    @Override
    public JsonValue get(int index) {
        return (JsonValue)this.asJsonArray().get(index);
    }

    @Override
    public String getString(int index) {
        return ((JsonString)this.get(index)).getString();
    }

    @Override
    public Optional<JsonValue> find(int index) {
        JsonArray array = this.asJsonArray();
        if (index >= 0 && index < array.size()) {
            return Optional.of((JsonValue)array.get(index));
        }
        return Optional.empty();
    }

    @Override
    public <T> T as(Class<T> type) {
        return JsonUtil.jsonpToJsonb(this.asJsonObject(), type);
    }
}

