/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jsonrpc.core;

import io.helidon.jsonrpc.core.JsonRpcError;
import io.helidon.jsonrpc.core.JsonUtil;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Objects;
import java.util.Optional;

class JsonRpcErrorImpl
implements JsonRpcError {
    private final JsonObject error;

    JsonRpcErrorImpl(JsonObject error) {
        this.error = Objects.requireNonNull(error);
    }

    @Override
    public int code() {
        return this.error.getInt("code");
    }

    @Override
    public String message() {
        return this.error.getString("message");
    }

    @Override
    public Optional<JsonValue> data() {
        return Optional.ofNullable((JsonValue)this.error.get((Object)"data"));
    }

    @Override
    public <T> Optional<T> dataAs(Class<T> type) {
        JsonValue data = (JsonValue)this.error.get((Object)"data");
        return data == null ? Optional.empty() : Optional.of(JsonUtil.jsonpToJsonb(data.asJsonObject(), type));
    }

    @Override
    public JsonObject asJsonObject() {
        return this.error;
    }
}

