/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.jsonrpc.core;

import io.helidon.jsonrpc.core.JsonRpcErrorImpl;
import io.helidon.jsonrpc.core.JsonUtil;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Objects;
import java.util.Optional;

public interface JsonRpcError {
    public static final int PARSE_ERROR = -32700;
    public static final int INVALID_REQUEST = -32600;
    public static final int METHOD_NOT_FOUND = -32601;
    public static final int INVALID_PARAMS = -32602;
    public static final int INTERNAL_ERROR = -32603;

    public static JsonRpcError create(JsonObject error) {
        return new JsonRpcErrorImpl(error);
    }

    public static JsonRpcError create(int code, String message) {
        Objects.requireNonNull(message, "message is null");
        JsonObjectBuilder builder = JsonUtil.JSON_BUILDER_FACTORY.createObjectBuilder();
        builder.add("code", code);
        builder.add("message", message);
        return new JsonRpcErrorImpl(builder.build());
    }

    public static JsonRpcError create(int code, String message, JsonValue data) {
        Objects.requireNonNull(message, "message is null");
        Objects.requireNonNull(data, "data is null");
        JsonObjectBuilder builder = JsonUtil.JSON_BUILDER_FACTORY.createObjectBuilder();
        builder.add("code", code);
        builder.add("message", message);
        builder.add("data", data);
        return new JsonRpcErrorImpl(builder.build());
    }

    public int code();

    public String message();

    public Optional<JsonValue> data();

    public <T> Optional<T> dataAs(Class<T> var1);

    public JsonObject asJsonObject();
}

