/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.json.schema.JsonSchemaException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum SchemaType {
    OBJECT("object"),
    ARRAY("array"),
    STRING("string"),
    NUMBER("number"),
    INTEGER("integer"),
    BOOLEAN("boolean"),
    NULL("null");

    private static final Map<String, SchemaType> TYPE_TO_ENUM;
    private final String type;

    private SchemaType(String type) {
        this.type = type;
    }

    String type() {
        return this.type;
    }

    static SchemaType fromType(String type) {
        return Optional.ofNullable(TYPE_TO_ENUM.get(type)).orElseThrow(() -> new JsonSchemaException("Unsupported type in schema: " + type));
    }

    static {
        HashMap<String, SchemaType> map = new HashMap<String, SchemaType>();
        for (SchemaType type : SchemaType.values()) {
            map.put(type.type(), type);
        }
        TYPE_TO_ENUM = Map.copyOf(map);
    }
}

