/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Prototype;
import io.helidon.json.schema.JsonSchemaException;
import io.helidon.json.schema.Schema;
import io.helidon.json.schema.SchemaArray;
import io.helidon.json.schema.SchemaBoolean;
import io.helidon.json.schema.SchemaInteger;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaNull;
import io.helidon.json.schema.SchemaNumber;
import io.helidon.json.schema.SchemaObject;
import io.helidon.json.schema.SchemaString;
import io.helidon.json.schema.SchemaType;
import io.helidon.json.schema.spi.JsonSchemaProvider;
import io.helidon.metadata.hson.Hson;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Services;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;

final class SchemaSupport {
    private SchemaSupport() {
    }

    static class SchemaObjectDecorator
    implements Prototype.BuilderDecorator<SchemaObject.BuilderBase<?, ?>> {
        SchemaObjectDecorator() {
        }

        public void decorate(SchemaObject.BuilderBase<?, ?> target) {
            target.integerProperties().forEach(target.properties()::putIfAbsent);
            target.numberProperties().forEach(target.properties()::putIfAbsent);
            target.stringProperties().forEach(target.properties()::putIfAbsent);
            target.booleanProperties().forEach(target.properties()::putIfAbsent);
            target.objectProperties().forEach(target.properties()::putIfAbsent);
            target.arrayProperties().forEach(target.properties()::putIfAbsent);
            target.nullProperties().forEach(target.properties()::putIfAbsent);
        }
    }

    static class SchemaObjectCustomMethods {
        private SchemaObjectCustomMethods() {
        }

        @Prototype.BuilderMethod
        static void addSchema(SchemaObject.BuilderBase<?, ?> target, String name, Schema schema) {
            SchemaItem root = schema.root();
            switch (root.schemaType()) {
                case OBJECT: {
                    target.addObjectProperty(name, (SchemaObject)root);
                    break;
                }
                case ARRAY: {
                    target.addArrayProperty(name, (SchemaArray)root);
                    break;
                }
                case NUMBER: {
                    target.addNumberProperty(name, (SchemaNumber)root);
                    break;
                }
                case INTEGER: {
                    target.addIntegerProperty(name, (SchemaInteger)root);
                    break;
                }
                case BOOLEAN: {
                    target.addBooleanProperty(name, (SchemaBoolean)root);
                    break;
                }
                case STRING: {
                    target.addStringProperty(name, (SchemaString)root);
                    break;
                }
                case NULL: {
                    target.addNullProperty(name, (SchemaNull)root);
                    break;
                }
                default: {
                    throw new JsonSchemaException("Unsupported schema type: " + String.valueOf((Object)root.schemaType()));
                }
            }
        }
    }

    static class SchemaNumberDecorator
    implements Prototype.BuilderDecorator<SchemaNumber.BuilderBase<?, ?>> {
        SchemaNumberDecorator() {
        }

        public void decorate(SchemaNumber.BuilderBase<?, ?> target) {
            Optional<Double> minimum = target.minimum();
            Optional<Double> exclusiveMinimum = target.exclusiveMinimum();
            Optional<Double> maximum = target.maximum();
            Optional<Double> exclusiveMaximum = target.exclusiveMaximum();
            if (minimum.isPresent() && exclusiveMinimum.isPresent()) {
                throw new JsonSchemaException("Both minimum and exclusive minimum cannot be set at the same time");
            }
            if (maximum.isPresent() && exclusiveMaximum.isPresent()) {
                throw new JsonSchemaException("Both maximum and exclusive maximum cannot be set at the same time");
            }
            Optional<Double> minimumNumber = minimum.or(() -> exclusiveMinimum);
            Optional<Double> maximumNumber = maximum.or(() -> exclusiveMaximum);
            if (minimumNumber.isPresent() && maximumNumber.isPresent() && minimumNumber.get() > maximumNumber.get()) {
                throw new JsonSchemaException("Minimum value cannot be greater than the maximum value");
            }
            if (minimumNumber.isPresent() && minimumNumber.get() < 0.0) {
                throw new JsonSchemaException("Minimum value cannot be lower than 0");
            }
            if (maximumNumber.isPresent() && maximumNumber.get() < 0.0) {
                throw new JsonSchemaException("Maximum value cannot be lower than 0");
            }
        }
    }

    static class SchemaIntegerDecorator
    implements Prototype.BuilderDecorator<SchemaInteger.BuilderBase<?, ?>> {
        SchemaIntegerDecorator() {
        }

        public void decorate(SchemaInteger.BuilderBase<?, ?> target) {
            Optional<Long> minimum = target.minimum();
            Optional<Long> exclusiveMinimum = target.exclusiveMinimum();
            Optional<Long> maximum = target.maximum();
            Optional<Long> exclusiveMaximum = target.exclusiveMaximum();
            if (minimum.isPresent() && exclusiveMinimum.isPresent()) {
                throw new JsonSchemaException("Both minimum and exclusive minimum cannot be set at the same time");
            }
            if (maximum.isPresent() && exclusiveMaximum.isPresent()) {
                throw new JsonSchemaException("Both maximum and exclusive maximum cannot be set at the same time");
            }
            Optional<Long> minimumNumber = minimum.or(() -> exclusiveMinimum);
            Optional<Long> maximumNumber = maximum.or(() -> exclusiveMaximum);
            if (minimumNumber.isPresent() && maximumNumber.isPresent() && minimumNumber.get() > maximumNumber.get()) {
                throw new JsonSchemaException("Minimum value cannot be greater than the maximum value");
            }
            if (minimumNumber.isPresent() && minimumNumber.get() < 0L) {
                throw new JsonSchemaException("Minimum value cannot be lower than 0");
            }
            if (maximumNumber.isPresent() && maximumNumber.get() < 0L) {
                throw new JsonSchemaException("Maximum value cannot be lower than 0");
            }
        }
    }

    static class SchemaIntegerCustomMethods {
        private SchemaIntegerCustomMethods() {
        }

        @Prototype.BuilderMethod
        static void multipleOf(SchemaInteger.BuilderBase<?, ?> builder, int value) {
            builder.multipleOf((long)value);
        }

        @Prototype.BuilderMethod
        static void minimum(SchemaInteger.BuilderBase<?, ?> builder, int value) {
            builder.minimum((long)value);
        }

        @Prototype.BuilderMethod
        static void maximum(SchemaInteger.BuilderBase<?, ?> builder, int value) {
            builder.maximum((long)value);
        }

        @Prototype.BuilderMethod
        static void exclusiveMaximum(SchemaInteger.BuilderBase<?, ?> builder, int value) {
            builder.exclusiveMaximum((long)value);
        }

        @Prototype.BuilderMethod
        static void exclusiveMinimum(SchemaInteger.BuilderBase<?, ?> builder, int value) {
            builder.exclusiveMinimum((long)value);
        }
    }

    static class SchemaArrayDecorator
    implements Prototype.BuilderDecorator<SchemaArray.BuilderBase<?, ?>> {
        SchemaArrayDecorator() {
        }

        public void decorate(SchemaArray.BuilderBase<?, ?> target) {
            target.schemaType(SchemaType.ARRAY);
            target.itemsObject().ifPresent(target::items);
            SchemaArrayDecorator.addRoot(target, target.itemsArray());
            SchemaArrayDecorator.addRoot(target, target.itemsInteger());
            SchemaArrayDecorator.addRoot(target, target.itemsNumber());
            SchemaArrayDecorator.addRoot(target, target.itemsString());
            SchemaArrayDecorator.addRoot(target, target.itemsBoolean());
            SchemaArrayDecorator.addRoot(target, target.itemsNull());
            Optional<Integer> minItems = target.minItems();
            Optional<Integer> maxItems = target.maxItems();
            if (minItems.isPresent() && maxItems.isPresent() && minItems.get() > maxItems.get()) {
                throw new JsonSchemaException("Minimum items value cannot be greater than the maximum value");
            }
            if (minItems.isPresent() && minItems.get() < 0) {
                throw new JsonSchemaException("Minimum items cannot be lower than 0");
            }
            if (maxItems.isPresent() && maxItems.get() < 0) {
                throw new JsonSchemaException("Maximum items cannot be lower than 0");
            }
        }

        private static void addRoot(SchemaArray.BuilderBase<?, ?> target, Optional<? extends SchemaItem> item) {
            if (target.items().isEmpty()) {
                item.ifPresent(target::items);
            } else if (item.isPresent()) {
                throw new JsonSchemaException("Only one array items type is supported");
            }
        }
    }

    static class SchemaDecorator
    implements Prototype.BuilderDecorator<Schema.BuilderBase<?, ?>> {
        SchemaDecorator() {
        }

        public void decorate(Schema.BuilderBase<?, ?> target) {
            target.rootObject().ifPresent(target::root);
            SchemaDecorator.addRoot(target, target.rootArray());
            SchemaDecorator.addRoot(target, target.rootInteger());
            SchemaDecorator.addRoot(target, target.rootNumber());
            SchemaDecorator.addRoot(target, target.rootString());
            SchemaDecorator.addRoot(target, target.rootBoolean());
            SchemaDecorator.addRoot(target, target.rootNull());
        }

        private static void addRoot(Schema.BuilderBase<?, ?> target, Optional<? extends SchemaItem> item) {
            if (target.root().isEmpty()) {
                item.ifPresent(target::root);
            } else if (item.isPresent()) {
                throw new JsonSchemaException("Only one root type is supported");
            }
        }
    }

    static class SchemaCustomMethods {
        private SchemaCustomMethods() {
        }

        @Prototype.BuilderMethod
        static void rootFromSchema(Schema.BuilderBase<?, ?> target, Schema schema) {
            SchemaItem root = schema.root();
            switch (root.schemaType()) {
                case OBJECT: {
                    target.rootObject((SchemaObject)root);
                    break;
                }
                case ARRAY: {
                    target.rootArray((SchemaArray)root);
                    break;
                }
                case NUMBER: {
                    target.rootNumber((SchemaNumber)root);
                    break;
                }
                case INTEGER: {
                    target.rootInteger((SchemaInteger)root);
                    break;
                }
                case BOOLEAN: {
                    target.rootBoolean((SchemaBoolean)root);
                    break;
                }
                case STRING: {
                    target.rootString((SchemaString)root);
                    break;
                }
                case NULL: {
                    target.rootNull((SchemaNull)root);
                    break;
                }
                default: {
                    throw new JsonSchemaException("Unsupported schema type: " + String.valueOf((Object)root.schemaType()));
                }
            }
        }

        @Prototype.PrototypeMethod
        static String generate(Schema schema) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintWriter writer = new PrintWriter(baos, true, StandardCharsets.UTF_8);){
                SchemaCustomMethods.generateObject(schema).write(writer, true);
            }
            return baos.toString(StandardCharsets.UTF_8);
        }

        @Prototype.PrototypeMethod
        static String generateNoKeywords(Schema schema) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintWriter writer = new PrintWriter(baos, true, StandardCharsets.UTF_8);){
                SchemaCustomMethods.generateObjectNoKeywords(schema).write(writer, true);
            }
            return baos.toString(StandardCharsets.UTF_8);
        }

        static Hson.Struct generateObject(Schema schema) {
            Hson.Struct.Builder builder = Hson.structBuilder();
            builder.set("$schema", "https://json-schema.org/draft/2020-12/schema");
            schema.id().ifPresent(id -> builder.set("$id", id.toString()));
            schema.root().generate(builder);
            return (Hson.Struct)builder.build();
        }

        static Hson.Struct generateObjectNoKeywords(Schema schema) {
            Hson.Struct.Builder builder = Hson.structBuilder();
            schema.root().generate(builder);
            return (Hson.Struct)builder.build();
        }

        @Prototype.FactoryMethod
        static Optional<Schema> find(Class<?> clazz) {
            return Services.first(JsonSchemaProvider.class, (Qualifier[])new Qualifier[]{Qualifier.createNamed(clazz)}).map(JsonSchemaProvider::schema);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Prototype.FactoryMethod
        static Schema parse(String jsonSchema) {
            Schema.Builder builder = Schema.builder();
            try (ByteArrayInputStream is = new ByteArrayInputStream(jsonSchema.getBytes(StandardCharsets.UTF_8));){
                Hson.Value parsed = Hson.parse((InputStream)is);
                Hson.Struct struct = parsed.asStruct();
                struct.stringValue("$id").map(URI::create).ifPresent(builder::id);
                SchemaType type = SchemaCustomMethods.type(struct);
                switch (type) {
                    case STRING: {
                        builder.rootString(stringBuilder -> SchemaCustomMethods.parseString(stringBuilder, struct));
                        return builder.build();
                    }
                    case INTEGER: {
                        builder.rootInteger(integerBuilder -> SchemaCustomMethods.parseInteger(integerBuilder, struct));
                        return builder.build();
                    }
                    case NUMBER: {
                        builder.rootNumber(numberBuilder -> SchemaCustomMethods.parseNumber(numberBuilder, struct));
                        return builder.build();
                    }
                    case BOOLEAN: {
                        builder.rootBoolean(booleanBuilder -> SchemaCustomMethods.parseCommon(booleanBuilder, struct));
                        return builder.build();
                    }
                    case OBJECT: {
                        builder.rootObject(objectBuilder -> SchemaCustomMethods.parseObject(objectBuilder, struct));
                        return builder.build();
                    }
                    case ARRAY: {
                        builder.rootArray(arrayBuilder -> SchemaCustomMethods.parseArray(arrayBuilder, struct));
                        return builder.build();
                    }
                    case NULL: {
                        builder.rootNull(nullBuilder -> SchemaCustomMethods.parseCommon(nullBuilder, struct));
                        return builder.build();
                    }
                    default: {
                        throw new JsonSchemaException("Unsupported root type: " + String.valueOf((Object)type));
                    }
                }
            }
            catch (IOException e) {
                throw new JsonSchemaException("Failed to parse JSON Schema", e);
            }
        }

        private static void parseCommon(SchemaItem.BuilderBase<?, ?> itemBuilder, Hson.Struct jsonObject) {
            jsonObject.stringValue("description").ifPresent(itemBuilder::description);
            jsonObject.stringValue("title").ifPresent(itemBuilder::title);
        }

        private static void parseString(SchemaString.Builder stringBuilder, Hson.Struct jsonObject) {
            SchemaCustomMethods.parseCommon(stringBuilder, jsonObject);
            jsonObject.numberValue("maxLength").ifPresent(it -> stringBuilder.maxLength(it.longValue()));
            jsonObject.numberValue("minLength").ifPresent(it -> stringBuilder.minLength(it.longValue()));
            jsonObject.stringValue("pattern").ifPresent(stringBuilder::pattern);
        }

        private static void parseInteger(SchemaInteger.Builder integerBuilder, Hson.Struct jsonObject) {
            SchemaCustomMethods.parseCommon(integerBuilder, jsonObject);
            jsonObject.numberValue("multipleOf").ifPresent(it -> integerBuilder.multipleOf(it.longValue()));
            jsonObject.numberValue("minimum").ifPresent(it -> integerBuilder.minimum(it.longValue()));
            jsonObject.numberValue("maximum").ifPresent(it -> integerBuilder.maximum(it.longValue()));
            jsonObject.numberValue("exclusiveMaximum").ifPresent(it -> integerBuilder.exclusiveMaximum(it.longValue()));
            jsonObject.numberValue("exclusiveMinimum").ifPresent(it -> integerBuilder.exclusiveMinimum(it.longValue()));
        }

        private static void parseNumber(SchemaNumber.Builder numberBuilder, Hson.Struct jsonObject) {
            SchemaCustomMethods.parseCommon(numberBuilder, jsonObject);
            jsonObject.doubleValue("multipleOf").ifPresent(numberBuilder::multipleOf);
            jsonObject.doubleValue("minimum").ifPresent(numberBuilder::minimum);
            jsonObject.doubleValue("maximum").ifPresent(numberBuilder::maximum);
            jsonObject.doubleValue("exclusiveMinimum").ifPresent(numberBuilder::exclusiveMinimum);
            jsonObject.doubleValue("exclusiveMaximum").ifPresent(numberBuilder::exclusiveMaximum);
        }

        private static void parseArray(SchemaArray.Builder arrayBuilder, Hson.Struct jsonObject) {
            SchemaCustomMethods.parseCommon(arrayBuilder, jsonObject);
            jsonObject.intValue("maxItems").ifPresent(arrayBuilder::maxItems);
            jsonObject.intValue("minItems").ifPresent(arrayBuilder::minItems);
            jsonObject.booleanValue("uniqueItems").ifPresent(arrayBuilder::uniqueItems);
            jsonObject.structValue("items").ifPresent(items -> {
                SchemaType type = SchemaCustomMethods.type(items);
                switch (type) {
                    case STRING: {
                        arrayBuilder.itemsString(stringBuilder -> SchemaCustomMethods.parseString(stringBuilder, items));
                        break;
                    }
                    case INTEGER: {
                        arrayBuilder.itemsInteger(integerBuilder -> SchemaCustomMethods.parseInteger(integerBuilder, items));
                        break;
                    }
                    case NUMBER: {
                        arrayBuilder.itemsNumber(numberBuilder -> SchemaCustomMethods.parseNumber(numberBuilder, items));
                        break;
                    }
                    case BOOLEAN: {
                        arrayBuilder.itemsBoolean(booleanBuilder -> SchemaCustomMethods.parseCommon(booleanBuilder, items));
                        break;
                    }
                    case OBJECT: {
                        arrayBuilder.itemsObject(objectBuilder -> SchemaCustomMethods.parseObject(objectBuilder, items));
                        break;
                    }
                    case ARRAY: {
                        arrayBuilder.itemsArray(arrayBuilder2 -> SchemaCustomMethods.parseArray(arrayBuilder2, items));
                        break;
                    }
                    case NULL: {
                        arrayBuilder.itemsNull(nullBuilder -> SchemaCustomMethods.parseCommon(nullBuilder, items));
                        break;
                    }
                    default: {
                        throw new JsonSchemaException("Unsupported type: " + String.valueOf((Object)type));
                    }
                }
            });
        }

        private static void parseObject(SchemaObject.Builder objectBuilder, Hson.Struct jsonObject) {
            SchemaCustomMethods.parseCommon(objectBuilder, jsonObject);
            jsonObject.intValue("maxProperties").ifPresent(objectBuilder::maxProperties);
            jsonObject.intValue("minProperties").ifPresent(objectBuilder::minProperties);
            jsonObject.booleanValue("additionalProperties").ifPresent(objectBuilder::additionalProperties);
            jsonObject.structValue("properties").ifPresent(properties -> {
                List requiredProperties = jsonObject.stringArray("required").orElse(List.of());
                properties.keys().forEach(key -> {
                    Hson.Struct object = (Hson.Struct)properties.structValue(key).orElseThrow(() -> new JsonSchemaException("Missing required property '" + key + "'"));
                    SchemaType type = SchemaCustomMethods.type(object);
                    switch (type) {
                        case OBJECT: {
                            objectBuilder.addObjectProperty((String)key, objectBuilder2 -> {
                                SchemaCustomMethods.parseObject(objectBuilder2, object);
                                objectBuilder2.required(requiredProperties.contains(key));
                            });
                            break;
                        }
                        case ARRAY: {
                            objectBuilder.addArrayProperty((String)key, arrayBuilder -> {
                                SchemaCustomMethods.parseArray(arrayBuilder, object);
                                arrayBuilder.required(requiredProperties.contains(key));
                            });
                            break;
                        }
                        case STRING: {
                            objectBuilder.addStringProperty((String)key, stringBuilder -> {
                                SchemaCustomMethods.parseString(stringBuilder, object);
                                stringBuilder.required(requiredProperties.contains(key));
                            });
                            break;
                        }
                        case NUMBER: {
                            objectBuilder.addNumberProperty((String)key, numberBuilder -> {
                                SchemaCustomMethods.parseNumber(numberBuilder, object);
                                numberBuilder.required(requiredProperties.contains(key));
                            });
                            break;
                        }
                        case INTEGER: {
                            objectBuilder.addIntegerProperty((String)key, integerBuilder -> {
                                SchemaCustomMethods.parseInteger(integerBuilder, object);
                                integerBuilder.required(requiredProperties.contains(key));
                            });
                            break;
                        }
                        case BOOLEAN: {
                            objectBuilder.addBooleanProperty((String)key, booleanBuilder -> {
                                SchemaCustomMethods.parseCommon(booleanBuilder, object);
                                booleanBuilder.required(requiredProperties.contains(key));
                            });
                            break;
                        }
                        case NULL: {
                            objectBuilder.addNullProperty((String)key, nullBuilder -> {
                                SchemaCustomMethods.parseCommon(nullBuilder, object);
                                nullBuilder.required(requiredProperties.contains(key));
                            });
                            break;
                        }
                        default: {
                            throw new JsonSchemaException("Unsupported type: " + String.valueOf((Object)type));
                        }
                    }
                });
            });
        }

        private static SchemaType type(Hson.Struct struct) {
            return struct.stringValue("type").map(SchemaType::fromType).orElseThrow(() -> new JsonSchemaException("Required property 'type' missing in an object property."));
        }
    }
}

