/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.json.schema.SchemaItemBlueprint;
import io.helidon.json.schema.SchemaType;
import io.helidon.metadata.hson.Hson;
import java.util.Optional;

@Prototype.Blueprint
interface SchemaStringBlueprint
extends SchemaItemBlueprint {
    public Optional<Long> maxLength();

    public Optional<Long> minLength();

    public Optional<String> pattern();

    @Override
    @Option.Access(value="")
    @Option.Default(value={"STRING"})
    public SchemaType schemaType();

    @Override
    default public void generate(Hson.Struct.Builder builder) {
        SchemaItemBlueprint.super.generate(builder);
        this.maxLength().ifPresent(maxLength -> builder.set("maxLength", maxLength.longValue()));
        this.minLength().ifPresent(minLength -> builder.set("minLength", minLength.longValue()));
        this.pattern().ifPresent(pattern -> builder.set("pattern", pattern));
    }
}

