/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaStringBlueprint;
import io.helidon.json.schema.SchemaType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.json.schema.SchemaStringBlueprint")
public interface SchemaString
extends SchemaStringBlueprint,
Prototype.Api,
SchemaItem {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaString instance) {
        return (Builder)SchemaString.builder().from(instance);
    }

    public static SchemaString create() {
        return SchemaString.builder().buildPrototype();
    }

    @Override
    public Optional<Long> maxLength();

    @Override
    public Optional<Long> minLength();

    @Override
    public Optional<String> pattern();

    public static class Builder
    extends BuilderBase<Builder, SchemaString>
    implements io.helidon.common.Builder<Builder, SchemaString> {
        private Builder() {
        }

        public SchemaString buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SchemaStringImpl(this);
        }

        public SchemaString build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SchemaString>
    extends SchemaItem.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Long maxLength;
        private Long minLength;
        private String pattern;

        protected BuilderBase() {
            this.schemaType(SchemaType.STRING);
        }

        public BUILDER from(SchemaString prototype) {
            super.from(prototype);
            this.maxLength(prototype.maxLength());
            this.minLength(prototype.minLength());
            this.pattern(prototype.pattern());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.maxLength().ifPresent(this::maxLength);
            builder.minLength().ifPresent(this::minLength);
            builder.pattern().ifPresent(this::pattern);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaxLength() {
            this.maxLength = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxLength(long maxLength) {
            Objects.requireNonNull(maxLength);
            this.maxLength = maxLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMinLength() {
            this.minLength = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minLength(long minLength) {
            Objects.requireNonNull(minLength);
            this.minLength = minLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPattern() {
            this.pattern = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER pattern(String pattern) {
            Objects.requireNonNull(pattern);
            this.pattern = pattern;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Long> maxLength() {
            return Optional.ofNullable(this.maxLength);
        }

        public Optional<Long> minLength() {
            return Optional.ofNullable(this.minLength);
        }

        public Optional<String> pattern() {
            return Optional.ofNullable(this.pattern);
        }

        @Override
        public String toString() {
            return "SchemaStringBuilder{maxLength=" + this.maxLength + ",minLength=" + this.minLength + ",pattern=" + this.pattern + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER maxLength(Optional<Long> maxLength) {
            Objects.requireNonNull(maxLength);
            this.maxLength = maxLength.map(Long.class::cast).orElse(this.maxLength);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER minLength(Optional<Long> minLength) {
            Objects.requireNonNull(minLength);
            this.minLength = minLength.map(Long.class::cast).orElse(this.minLength);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER pattern(Optional<String> pattern) {
            Objects.requireNonNull(pattern);
            this.pattern = pattern.map(String.class::cast).orElse(this.pattern);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class SchemaStringImpl
        extends SchemaItem.BuilderBase.SchemaItemImpl
        implements SchemaString {
            private final Optional<Long> maxLength;
            private final Optional<Long> minLength;
            private final Optional<String> pattern;

            protected SchemaStringImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.maxLength = builder.maxLength().map(Function.identity());
                this.minLength = builder.minLength().map(Function.identity());
                this.pattern = builder.pattern().map(Function.identity());
            }

            @Override
            public Optional<Long> maxLength() {
                return this.maxLength;
            }

            @Override
            public Optional<Long> minLength() {
                return this.minLength;
            }

            @Override
            public Optional<String> pattern() {
                return this.pattern;
            }

            @Override
            public String toString() {
                return "SchemaString{maxLength=" + String.valueOf(this.maxLength) + ",minLength=" + String.valueOf(this.minLength) + ",pattern=" + String.valueOf(this.pattern) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SchemaString)) {
                    return false;
                }
                SchemaString other = (SchemaString)o;
                return super.equals(other) && Objects.equals(this.maxLength, other.maxLength()) && Objects.equals(this.minLength, other.minLength()) && Objects.equals(this.pattern, other.pattern());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.maxLength, this.minLength, this.pattern);
            }
        }
    }
}

