/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.json.schema.SchemaArray;
import io.helidon.json.schema.SchemaBoolean;
import io.helidon.json.schema.SchemaInteger;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaItemBlueprint;
import io.helidon.json.schema.SchemaNull;
import io.helidon.json.schema.SchemaNumber;
import io.helidon.json.schema.SchemaObject;
import io.helidon.json.schema.SchemaString;
import io.helidon.json.schema.SchemaSupport;
import io.helidon.json.schema.SchemaType;
import io.helidon.metadata.hson.Hson;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Prototype.Blueprint(decorator=SchemaSupport.SchemaObjectDecorator.class)
@Prototype.CustomMethods(value=SchemaSupport.SchemaObjectCustomMethods.class)
interface SchemaObjectBlueprint
extends SchemaItemBlueprint {
    public Optional<Integer> maxProperties();

    public Optional<Integer> minProperties();

    public Optional<Boolean> additionalProperties();

    @Option.Singular(value="property")
    @Option.Access(value="")
    public Map<String, SchemaItem> properties();

    @Option.Singular(value="addStringProperty", withPrefix=false)
    public Map<String, SchemaString> stringProperties();

    @Option.Singular(value="addObjectProperty", withPrefix=false)
    public Map<String, SchemaObject> objectProperties();

    @Option.Singular(value="addArrayProperty", withPrefix=false)
    public Map<String, SchemaArray> arrayProperties();

    @Option.Singular(value="addNumberProperty", withPrefix=false)
    public Map<String, SchemaNumber> numberProperties();

    @Option.Singular(value="addIntegerProperty", withPrefix=false)
    public Map<String, SchemaInteger> integerProperties();

    @Option.Singular(value="addBooleanProperty", withPrefix=false)
    public Map<String, SchemaBoolean> booleanProperties();

    @Option.Singular(value="addNullProperty", withPrefix=false)
    public Map<String, SchemaNull> nullProperties();

    @Override
    @Option.Access(value="")
    @Option.Default(value={"OBJECT"})
    public SchemaType schemaType();

    @Override
    default public void generate(Hson.Struct.Builder builder) {
        SchemaItemBlueprint.super.generate(builder);
        this.maxProperties().ifPresent(maxProperties -> builder.set("maxProperties", maxProperties.intValue()));
        this.minProperties().ifPresent(minProperties -> builder.set("minProperties", minProperties.intValue()));
        this.additionalProperties().ifPresent(additionalProperties -> builder.set("additionalProperties", additionalProperties.booleanValue()));
        HashSet<String> requiredProperties = new HashSet<String>();
        Map<String, SchemaItem> properties = this.properties();
        if (!properties.isEmpty()) {
            Hson.Struct.Builder objectBuilder = Hson.structBuilder();
            for (Map.Entry<String, SchemaItem> entry : properties.entrySet()) {
                SchemaItem schemaItem = entry.getValue();
                Hson.Struct.Builder itemBuilder = Hson.structBuilder();
                schemaItem.generate(itemBuilder);
                objectBuilder.set(entry.getKey(), (Hson.Value)itemBuilder.build());
                if (!schemaItem.required()) continue;
                requiredProperties.add(entry.getKey());
            }
            builder.set("properties", (Hson.Value)objectBuilder.build());
        }
        if (!requiredProperties.isEmpty()) {
            builder.setStrings("required", List.copyOf(requiredProperties));
        }
    }
}

