/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.json.schema.Schema;
import io.helidon.json.schema.SchemaArray;
import io.helidon.json.schema.SchemaBoolean;
import io.helidon.json.schema.SchemaInteger;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaNull;
import io.helidon.json.schema.SchemaNumber;
import io.helidon.json.schema.SchemaObjectBlueprint;
import io.helidon.json.schema.SchemaString;
import io.helidon.json.schema.SchemaSupport;
import io.helidon.json.schema.SchemaType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.json.schema.SchemaObjectBlueprint")
public interface SchemaObject
extends SchemaObjectBlueprint,
Prototype.Api,
SchemaItem {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaObject instance) {
        return (Builder)SchemaObject.builder().from(instance);
    }

    public static SchemaObject create() {
        return SchemaObject.builder().buildPrototype();
    }

    @Override
    public Optional<Integer> maxProperties();

    @Override
    public Optional<Integer> minProperties();

    @Override
    public Optional<Boolean> additionalProperties();

    @Override
    public Map<String, SchemaItem> properties();

    @Override
    public Map<String, SchemaString> stringProperties();

    @Override
    public Map<String, SchemaObject> objectProperties();

    @Override
    public Map<String, SchemaArray> arrayProperties();

    @Override
    public Map<String, SchemaNumber> numberProperties();

    @Override
    public Map<String, SchemaInteger> integerProperties();

    @Override
    public Map<String, SchemaBoolean> booleanProperties();

    @Override
    public Map<String, SchemaNull> nullProperties();

    public static class Builder
    extends BuilderBase<Builder, SchemaObject>
    implements io.helidon.common.Builder<Builder, SchemaObject> {
        private Builder() {
        }

        public SchemaObject buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SchemaObjectImpl(this);
        }

        public SchemaObject build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SchemaObject>
    extends SchemaItem.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Map<String, SchemaArray> arrayProperties = new LinkedHashMap<String, SchemaArray>();
        private final Map<String, SchemaBoolean> booleanProperties = new LinkedHashMap<String, SchemaBoolean>();
        private final Map<String, SchemaInteger> integerProperties = new LinkedHashMap<String, SchemaInteger>();
        private final Map<String, SchemaItem> properties = new LinkedHashMap<String, SchemaItem>();
        private final Map<String, SchemaNull> nullProperties = new LinkedHashMap<String, SchemaNull>();
        private final Map<String, SchemaNumber> numberProperties = new LinkedHashMap<String, SchemaNumber>();
        private final Map<String, SchemaObject> objectProperties = new LinkedHashMap<String, SchemaObject>();
        private final Map<String, SchemaString> stringProperties = new LinkedHashMap<String, SchemaString>();
        private Boolean additionalProperties;
        private Integer maxProperties;
        private Integer minProperties;

        protected BuilderBase() {
            this.schemaType(SchemaType.OBJECT);
        }

        public BUILDER from(SchemaObject prototype) {
            super.from(prototype);
            this.maxProperties(prototype.maxProperties());
            this.minProperties(prototype.minProperties());
            this.additionalProperties(prototype.additionalProperties());
            this.addProperties(prototype.properties());
            this.addStringProperties(prototype.stringProperties());
            this.addObjectProperties(prototype.objectProperties());
            this.addArrayProperties(prototype.arrayProperties());
            this.addNumberProperties(prototype.numberProperties());
            this.addIntegerProperties(prototype.integerProperties());
            this.addBooleanProperties(prototype.booleanProperties());
            this.addNullProperties(prototype.nullProperties());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.maxProperties().ifPresent(this::maxProperties);
            builder.minProperties().ifPresent(this::minProperties);
            builder.additionalProperties().ifPresent(this::additionalProperties);
            this.addProperties(builder.properties);
            this.addStringProperties(builder.stringProperties);
            this.addObjectProperties(builder.objectProperties);
            this.addArrayProperties(builder.arrayProperties);
            this.addNumberProperties(builder.numberProperties);
            this.addIntegerProperties(builder.integerProperties);
            this.addBooleanProperties(builder.booleanProperties);
            this.addNullProperties(builder.nullProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSchema(String name, Schema schema) {
            SchemaSupport.SchemaObjectCustomMethods.addSchema(this, name, schema);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaxProperties() {
            this.maxProperties = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxProperties(int maxProperties) {
            Objects.requireNonNull(maxProperties);
            this.maxProperties = maxProperties;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMinProperties() {
            this.minProperties = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minProperties(int minProperties) {
            Objects.requireNonNull(minProperties);
            this.minProperties = minProperties;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearAdditionalProperties() {
            this.additionalProperties = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER additionalProperties(boolean additionalProperties) {
            Objects.requireNonNull(additionalProperties);
            this.additionalProperties = additionalProperties;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER stringProperties(Map<String, ? extends SchemaString> stringProperties) {
            Objects.requireNonNull(stringProperties);
            this.stringProperties.clear();
            this.stringProperties.putAll(stringProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addStringProperties(Map<String, ? extends SchemaString> stringProperties) {
            Objects.requireNonNull(stringProperties);
            this.stringProperties.putAll(stringProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addStringProperty(String key, SchemaString addStringProperty) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(addStringProperty);
            this.stringProperties.put(key, addStringProperty);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addStringProperty(String key, Consumer<SchemaString.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            SchemaString.Builder builder = SchemaString.builder();
            consumer.accept(builder);
            this.addStringProperty(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER objectProperties(Map<String, ? extends SchemaObject> objectProperties) {
            Objects.requireNonNull(objectProperties);
            this.objectProperties.clear();
            this.objectProperties.putAll(objectProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addObjectProperties(Map<String, ? extends SchemaObject> objectProperties) {
            Objects.requireNonNull(objectProperties);
            this.objectProperties.putAll(objectProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addObjectProperty(String key, SchemaObject addObjectProperty) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(addObjectProperty);
            this.objectProperties.put(key, addObjectProperty);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addObjectProperty(String key, Consumer<Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            Builder builder = SchemaObject.builder();
            consumer.accept(builder);
            this.addObjectProperty(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER arrayProperties(Map<String, ? extends SchemaArray> arrayProperties) {
            Objects.requireNonNull(arrayProperties);
            this.arrayProperties.clear();
            this.arrayProperties.putAll(arrayProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addArrayProperties(Map<String, ? extends SchemaArray> arrayProperties) {
            Objects.requireNonNull(arrayProperties);
            this.arrayProperties.putAll(arrayProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addArrayProperty(String key, SchemaArray addArrayProperty) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(addArrayProperty);
            this.arrayProperties.put(key, addArrayProperty);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addArrayProperty(String key, Consumer<SchemaArray.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            SchemaArray.Builder builder = SchemaArray.builder();
            consumer.accept(builder);
            this.addArrayProperty(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER numberProperties(Map<String, ? extends SchemaNumber> numberProperties) {
            Objects.requireNonNull(numberProperties);
            this.numberProperties.clear();
            this.numberProperties.putAll(numberProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addNumberProperties(Map<String, ? extends SchemaNumber> numberProperties) {
            Objects.requireNonNull(numberProperties);
            this.numberProperties.putAll(numberProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addNumberProperty(String key, SchemaNumber addNumberProperty) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(addNumberProperty);
            this.numberProperties.put(key, addNumberProperty);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addNumberProperty(String key, Consumer<SchemaNumber.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            SchemaNumber.Builder builder = SchemaNumber.builder();
            consumer.accept(builder);
            this.addNumberProperty(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER integerProperties(Map<String, ? extends SchemaInteger> integerProperties) {
            Objects.requireNonNull(integerProperties);
            this.integerProperties.clear();
            this.integerProperties.putAll(integerProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addIntegerProperties(Map<String, ? extends SchemaInteger> integerProperties) {
            Objects.requireNonNull(integerProperties);
            this.integerProperties.putAll(integerProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addIntegerProperty(String key, SchemaInteger addIntegerProperty) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(addIntegerProperty);
            this.integerProperties.put(key, addIntegerProperty);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addIntegerProperty(String key, Consumer<SchemaInteger.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            SchemaInteger.Builder builder = SchemaInteger.builder();
            consumer.accept(builder);
            this.addIntegerProperty(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER booleanProperties(Map<String, ? extends SchemaBoolean> booleanProperties) {
            Objects.requireNonNull(booleanProperties);
            this.booleanProperties.clear();
            this.booleanProperties.putAll(booleanProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addBooleanProperties(Map<String, ? extends SchemaBoolean> booleanProperties) {
            Objects.requireNonNull(booleanProperties);
            this.booleanProperties.putAll(booleanProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addBooleanProperty(String key, SchemaBoolean addBooleanProperty) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(addBooleanProperty);
            this.booleanProperties.put(key, addBooleanProperty);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addBooleanProperty(String key, Consumer<SchemaBoolean.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            SchemaBoolean.Builder builder = SchemaBoolean.builder();
            consumer.accept(builder);
            this.addBooleanProperty(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER nullProperties(Map<String, ? extends SchemaNull> nullProperties) {
            Objects.requireNonNull(nullProperties);
            this.nullProperties.clear();
            this.nullProperties.putAll(nullProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addNullProperties(Map<String, ? extends SchemaNull> nullProperties) {
            Objects.requireNonNull(nullProperties);
            this.nullProperties.putAll(nullProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addNullProperty(String key, SchemaNull addNullProperty) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(addNullProperty);
            this.nullProperties.put(key, addNullProperty);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addNullProperty(String key, Consumer<SchemaNull.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            SchemaNull.Builder builder = SchemaNull.builder();
            consumer.accept(builder);
            this.addNullProperty(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Integer> maxProperties() {
            return Optional.ofNullable(this.maxProperties);
        }

        public Optional<Integer> minProperties() {
            return Optional.ofNullable(this.minProperties);
        }

        public Optional<Boolean> additionalProperties() {
            return Optional.ofNullable(this.additionalProperties);
        }

        public Map<String, SchemaString> stringProperties() {
            return this.stringProperties;
        }

        public Map<String, SchemaObject> objectProperties() {
            return this.objectProperties;
        }

        public Map<String, SchemaArray> arrayProperties() {
            return this.arrayProperties;
        }

        public Map<String, SchemaNumber> numberProperties() {
            return this.numberProperties;
        }

        public Map<String, SchemaInteger> integerProperties() {
            return this.integerProperties;
        }

        public Map<String, SchemaBoolean> booleanProperties() {
            return this.booleanProperties;
        }

        public Map<String, SchemaNull> nullProperties() {
            return this.nullProperties;
        }

        @Override
        public String toString() {
            return "SchemaObjectBuilder{maxProperties=" + this.maxProperties + ",minProperties=" + this.minProperties + ",additionalProperties=" + this.additionalProperties + ",properties=" + String.valueOf(this.properties) + ",stringProperties=" + String.valueOf(this.stringProperties) + ",objectProperties=" + String.valueOf(this.objectProperties) + ",arrayProperties=" + String.valueOf(this.arrayProperties) + ",numberProperties=" + String.valueOf(this.numberProperties) + ",integerProperties=" + String.valueOf(this.integerProperties) + ",booleanProperties=" + String.valueOf(this.booleanProperties) + ",nullProperties=" + String.valueOf(this.nullProperties) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            new SchemaSupport.SchemaObjectDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER maxProperties(Optional<Integer> maxProperties) {
            Objects.requireNonNull(maxProperties);
            this.maxProperties = maxProperties.map(Integer.class::cast).orElse(this.maxProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER minProperties(Optional<Integer> minProperties) {
            Objects.requireNonNull(minProperties);
            this.minProperties = minProperties.map(Integer.class::cast).orElse(this.minProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER additionalProperties(Optional<Boolean> additionalProperties) {
            Objects.requireNonNull(additionalProperties);
            this.additionalProperties = additionalProperties.map(Boolean.class::cast).orElse(this.additionalProperties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER properties(Map<String, ? extends SchemaItem> properties) {
            Objects.requireNonNull(properties);
            this.properties.clear();
            this.properties.putAll(properties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER addProperties(Map<String, ? extends SchemaItem> properties) {
            Objects.requireNonNull(properties);
            this.properties.putAll(properties);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER putProperty(String key, SchemaItem property) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(property);
            this.properties.put(key, property);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER putProperty(String key, Consumer<SchemaItem.Builder> consumer) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(consumer);
            SchemaItem.Builder builder = SchemaItem.builder();
            consumer.accept(builder);
            this.putProperty(key, builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        Map<String, SchemaItem> properties() {
            return this.properties;
        }

        protected static class SchemaObjectImpl
        extends SchemaItem.BuilderBase.SchemaItemImpl
        implements SchemaObject {
            private final Map<String, SchemaArray> arrayProperties;
            private final Map<String, SchemaBoolean> booleanProperties;
            private final Map<String, SchemaInteger> integerProperties;
            private final Map<String, SchemaItem> properties;
            private final Map<String, SchemaNull> nullProperties;
            private final Map<String, SchemaNumber> numberProperties;
            private final Map<String, SchemaObject> objectProperties;
            private final Map<String, SchemaString> stringProperties;
            private final Optional<Boolean> additionalProperties;
            private final Optional<Integer> maxProperties;
            private final Optional<Integer> minProperties;

            protected SchemaObjectImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.maxProperties = builder.maxProperties().map(Function.identity());
                this.minProperties = builder.minProperties().map(Function.identity());
                this.additionalProperties = builder.additionalProperties().map(Function.identity());
                this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, SchemaItem>(builder.properties()));
                this.stringProperties = Collections.unmodifiableMap(new LinkedHashMap<String, SchemaString>(builder.stringProperties()));
                this.objectProperties = Collections.unmodifiableMap(new LinkedHashMap<String, SchemaObject>(builder.objectProperties()));
                this.arrayProperties = Collections.unmodifiableMap(new LinkedHashMap<String, SchemaArray>(builder.arrayProperties()));
                this.numberProperties = Collections.unmodifiableMap(new LinkedHashMap<String, SchemaNumber>(builder.numberProperties()));
                this.integerProperties = Collections.unmodifiableMap(new LinkedHashMap<String, SchemaInteger>(builder.integerProperties()));
                this.booleanProperties = Collections.unmodifiableMap(new LinkedHashMap<String, SchemaBoolean>(builder.booleanProperties()));
                this.nullProperties = Collections.unmodifiableMap(new LinkedHashMap<String, SchemaNull>(builder.nullProperties()));
            }

            @Override
            public Optional<Integer> maxProperties() {
                return this.maxProperties;
            }

            @Override
            public Optional<Integer> minProperties() {
                return this.minProperties;
            }

            @Override
            public Optional<Boolean> additionalProperties() {
                return this.additionalProperties;
            }

            @Override
            public Map<String, SchemaItem> properties() {
                return this.properties;
            }

            @Override
            public Map<String, SchemaString> stringProperties() {
                return this.stringProperties;
            }

            @Override
            public Map<String, SchemaObject> objectProperties() {
                return this.objectProperties;
            }

            @Override
            public Map<String, SchemaArray> arrayProperties() {
                return this.arrayProperties;
            }

            @Override
            public Map<String, SchemaNumber> numberProperties() {
                return this.numberProperties;
            }

            @Override
            public Map<String, SchemaInteger> integerProperties() {
                return this.integerProperties;
            }

            @Override
            public Map<String, SchemaBoolean> booleanProperties() {
                return this.booleanProperties;
            }

            @Override
            public Map<String, SchemaNull> nullProperties() {
                return this.nullProperties;
            }

            @Override
            public String toString() {
                return "SchemaObject{maxProperties=" + String.valueOf(this.maxProperties) + ",minProperties=" + String.valueOf(this.minProperties) + ",additionalProperties=" + String.valueOf(this.additionalProperties) + ",properties=" + String.valueOf(this.properties) + ",stringProperties=" + String.valueOf(this.stringProperties) + ",objectProperties=" + String.valueOf(this.objectProperties) + ",arrayProperties=" + String.valueOf(this.arrayProperties) + ",numberProperties=" + String.valueOf(this.numberProperties) + ",integerProperties=" + String.valueOf(this.integerProperties) + ",booleanProperties=" + String.valueOf(this.booleanProperties) + ",nullProperties=" + String.valueOf(this.nullProperties) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SchemaObject)) {
                    return false;
                }
                SchemaObject other = (SchemaObject)o;
                return super.equals(other) && Objects.equals(this.maxProperties, other.maxProperties()) && Objects.equals(this.minProperties, other.minProperties()) && Objects.equals(this.additionalProperties, other.additionalProperties()) && Objects.equals(this.properties, other.properties()) && Objects.equals(this.stringProperties, other.stringProperties()) && Objects.equals(this.objectProperties, other.objectProperties()) && Objects.equals(this.arrayProperties, other.arrayProperties()) && Objects.equals(this.numberProperties, other.numberProperties()) && Objects.equals(this.integerProperties, other.integerProperties()) && Objects.equals(this.booleanProperties, other.booleanProperties()) && Objects.equals(this.nullProperties, other.nullProperties());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.maxProperties, this.minProperties, this.additionalProperties, this.properties, this.stringProperties, this.objectProperties, this.arrayProperties, this.numberProperties, this.integerProperties, this.booleanProperties, this.nullProperties);
            }
        }
    }
}

