/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaNumberBlueprint;
import io.helidon.json.schema.SchemaSupport;
import io.helidon.json.schema.SchemaType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.json.schema.SchemaNumberBlueprint")
public interface SchemaNumber
extends SchemaNumberBlueprint,
Prototype.Api,
SchemaItem {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaNumber instance) {
        return (Builder)SchemaNumber.builder().from(instance);
    }

    public static SchemaNumber create() {
        return SchemaNumber.builder().buildPrototype();
    }

    @Override
    public Optional<Double> multipleOf();

    @Override
    public Optional<Double> minimum();

    @Override
    public Optional<Double> maximum();

    @Override
    public Optional<Double> exclusiveMaximum();

    @Override
    public Optional<Double> exclusiveMinimum();

    public static class Builder
    extends BuilderBase<Builder, SchemaNumber>
    implements io.helidon.common.Builder<Builder, SchemaNumber> {
        private Builder() {
        }

        public SchemaNumber buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SchemaNumberImpl(this);
        }

        public SchemaNumber build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SchemaNumber>
    extends SchemaItem.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Double exclusiveMaximum;
        private Double exclusiveMinimum;
        private Double maximum;
        private Double minimum;
        private Double multipleOf;

        protected BuilderBase() {
            this.schemaType(SchemaType.NUMBER);
        }

        public BUILDER from(SchemaNumber prototype) {
            super.from(prototype);
            this.multipleOf(prototype.multipleOf());
            this.minimum(prototype.minimum());
            this.maximum(prototype.maximum());
            this.exclusiveMaximum(prototype.exclusiveMaximum());
            this.exclusiveMinimum(prototype.exclusiveMinimum());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.multipleOf().ifPresent(this::multipleOf);
            builder.minimum().ifPresent(this::minimum);
            builder.maximum().ifPresent(this::maximum);
            builder.exclusiveMaximum().ifPresent(this::exclusiveMaximum);
            builder.exclusiveMinimum().ifPresent(this::exclusiveMinimum);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMultipleOf() {
            this.multipleOf = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER multipleOf(double multipleOf) {
            Objects.requireNonNull(multipleOf);
            this.multipleOf = multipleOf;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMinimum() {
            this.minimum = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minimum(double minimum) {
            Objects.requireNonNull(minimum);
            this.minimum = minimum;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaximum() {
            this.maximum = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maximum(double maximum) {
            Objects.requireNonNull(maximum);
            this.maximum = maximum;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExclusiveMaximum() {
            this.exclusiveMaximum = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exclusiveMaximum(double exclusiveMaximum) {
            Objects.requireNonNull(exclusiveMaximum);
            this.exclusiveMaximum = exclusiveMaximum;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExclusiveMinimum() {
            this.exclusiveMinimum = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exclusiveMinimum(double exclusiveMinimum) {
            Objects.requireNonNull(exclusiveMinimum);
            this.exclusiveMinimum = exclusiveMinimum;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Double> multipleOf() {
            return Optional.ofNullable(this.multipleOf);
        }

        public Optional<Double> minimum() {
            return Optional.ofNullable(this.minimum);
        }

        public Optional<Double> maximum() {
            return Optional.ofNullable(this.maximum);
        }

        public Optional<Double> exclusiveMaximum() {
            return Optional.ofNullable(this.exclusiveMaximum);
        }

        public Optional<Double> exclusiveMinimum() {
            return Optional.ofNullable(this.exclusiveMinimum);
        }

        @Override
        public String toString() {
            return "SchemaNumberBuilder{multipleOf=" + this.multipleOf + ",minimum=" + this.minimum + ",maximum=" + this.maximum + ",exclusiveMaximum=" + this.exclusiveMaximum + ",exclusiveMinimum=" + this.exclusiveMinimum + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            new SchemaSupport.SchemaNumberDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER multipleOf(Optional<Double> multipleOf) {
            Objects.requireNonNull(multipleOf);
            this.multipleOf = multipleOf.map(Double.class::cast).orElse(this.multipleOf);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER minimum(Optional<Double> minimum) {
            Objects.requireNonNull(minimum);
            this.minimum = minimum.map(Double.class::cast).orElse(this.minimum);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER maximum(Optional<Double> maximum) {
            Objects.requireNonNull(maximum);
            this.maximum = maximum.map(Double.class::cast).orElse(this.maximum);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER exclusiveMaximum(Optional<Double> exclusiveMaximum) {
            Objects.requireNonNull(exclusiveMaximum);
            this.exclusiveMaximum = exclusiveMaximum.map(Double.class::cast).orElse(this.exclusiveMaximum);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER exclusiveMinimum(Optional<Double> exclusiveMinimum) {
            Objects.requireNonNull(exclusiveMinimum);
            this.exclusiveMinimum = exclusiveMinimum.map(Double.class::cast).orElse(this.exclusiveMinimum);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class SchemaNumberImpl
        extends SchemaItem.BuilderBase.SchemaItemImpl
        implements SchemaNumber {
            private final Optional<Double> exclusiveMaximum;
            private final Optional<Double> exclusiveMinimum;
            private final Optional<Double> maximum;
            private final Optional<Double> minimum;
            private final Optional<Double> multipleOf;

            protected SchemaNumberImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.multipleOf = builder.multipleOf().map(Function.identity());
                this.minimum = builder.minimum().map(Function.identity());
                this.maximum = builder.maximum().map(Function.identity());
                this.exclusiveMaximum = builder.exclusiveMaximum().map(Function.identity());
                this.exclusiveMinimum = builder.exclusiveMinimum().map(Function.identity());
            }

            @Override
            public Optional<Double> multipleOf() {
                return this.multipleOf;
            }

            @Override
            public Optional<Double> minimum() {
                return this.minimum;
            }

            @Override
            public Optional<Double> maximum() {
                return this.maximum;
            }

            @Override
            public Optional<Double> exclusiveMaximum() {
                return this.exclusiveMaximum;
            }

            @Override
            public Optional<Double> exclusiveMinimum() {
                return this.exclusiveMinimum;
            }

            @Override
            public String toString() {
                return "SchemaNumber{multipleOf=" + String.valueOf(this.multipleOf) + ",minimum=" + String.valueOf(this.minimum) + ",maximum=" + String.valueOf(this.maximum) + ",exclusiveMaximum=" + String.valueOf(this.exclusiveMaximum) + ",exclusiveMinimum=" + String.valueOf(this.exclusiveMinimum) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SchemaNumber)) {
                    return false;
                }
                SchemaNumber other = (SchemaNumber)o;
                return super.equals(other) && Objects.equals(this.multipleOf, other.multipleOf()) && Objects.equals(this.minimum, other.minimum()) && Objects.equals(this.maximum, other.maximum()) && Objects.equals(this.exclusiveMaximum, other.exclusiveMaximum()) && Objects.equals(this.exclusiveMinimum, other.exclusiveMinimum());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.multipleOf, this.minimum, this.maximum, this.exclusiveMaximum, this.exclusiveMinimum);
            }
        }
    }
}

