/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.json.schema.SchemaItemBlueprint;
import io.helidon.json.schema.SchemaType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.json.schema.SchemaItemBlueprint")
public interface SchemaItem
extends SchemaItemBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaItem instance) {
        return (Builder)SchemaItem.builder().from(instance);
    }

    public static SchemaItem create() {
        return SchemaItem.builder().buildPrototype();
    }

    @Override
    public Optional<String> title();

    @Override
    public Optional<String> description();

    @Override
    public boolean required();

    @Override
    public SchemaType schemaType();

    public static class Builder
    extends BuilderBase<Builder, SchemaItem>
    implements io.helidon.common.Builder<Builder, SchemaItem> {
        private Builder() {
        }

        public SchemaItem buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SchemaItemImpl(this);
        }

        public SchemaItem build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SchemaItem>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean required;
        private SchemaType schemaType;
        private String description;
        private String title;

        protected BuilderBase() {
        }

        public BUILDER from(SchemaItem prototype) {
            this.title(prototype.title());
            this.description(prototype.description());
            this.required(prototype.required());
            this.schemaType(prototype.schemaType());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.title().ifPresent(this::title);
            builder.description().ifPresent(this::description);
            this.required(builder.required());
            builder.schemaType().ifPresent(this::schemaType);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTitle() {
            this.title = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER title(String title) {
            Objects.requireNonNull(title);
            this.title = title;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDescription() {
            this.description = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER description(String description) {
            Objects.requireNonNull(description);
            this.description = description;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER required(boolean required) {
            this.required = required;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> title() {
            return Optional.ofNullable(this.title);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public boolean required() {
            return this.required;
        }

        public String toString() {
            return "SchemaItemBuilder{title=" + this.title + ",description=" + this.description + ",required=" + this.required + ",schemaType=" + String.valueOf((Object)this.schemaType) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.schemaType == null) {
                collector.fatal(this.getClass(), "Property \"schemaType\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER title(Optional<String> title) {
            Objects.requireNonNull(title);
            this.title = title.map(String.class::cast).orElse(this.title);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER description(Optional<String> description) {
            Objects.requireNonNull(description);
            this.description = description.map(String.class::cast).orElse(this.description);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER schemaType(SchemaType schemaType) {
            Objects.requireNonNull(schemaType);
            this.schemaType = schemaType;
            return (BUILDER)((BuilderBase)this.self());
        }

        Optional<SchemaType> schemaType() {
            return Optional.ofNullable(this.schemaType);
        }

        protected static class SchemaItemImpl
        implements SchemaItem {
            private final boolean required;
            private final Optional<String> description;
            private final Optional<String> title;
            private final SchemaType schemaType;

            protected SchemaItemImpl(BuilderBase<?, ?> builder) {
                this.title = builder.title().map(Function.identity());
                this.description = builder.description().map(Function.identity());
                this.required = builder.required();
                this.schemaType = builder.schemaType().get();
            }

            @Override
            public Optional<String> title() {
                return this.title;
            }

            @Override
            public Optional<String> description() {
                return this.description;
            }

            @Override
            public boolean required() {
                return this.required;
            }

            @Override
            public SchemaType schemaType() {
                return this.schemaType;
            }

            public String toString() {
                return "SchemaItem{title=" + String.valueOf(this.title) + ",description=" + String.valueOf(this.description) + ",required=" + this.required + ",schemaType=" + String.valueOf((Object)this.schemaType) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SchemaItem)) {
                    return false;
                }
                SchemaItem other = (SchemaItem)o;
                return Objects.equals(this.title, other.title()) && Objects.equals(this.description, other.description()) && this.required == other.required() && Objects.equals((Object)this.schemaType, (Object)other.schemaType());
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.title, this.description, this.required, this.schemaType});
            }
        }
    }
}

