/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.json.schema.SchemaItemBlueprint;
import io.helidon.json.schema.SchemaSupport;
import io.helidon.json.schema.SchemaType;
import io.helidon.metadata.hson.Hson;
import java.util.Optional;

@Prototype.Blueprint(decorator=SchemaSupport.SchemaIntegerDecorator.class)
@Prototype.CustomMethods(value=SchemaSupport.SchemaIntegerCustomMethods.class)
interface SchemaIntegerBlueprint
extends SchemaItemBlueprint {
    public Optional<Long> multipleOf();

    public Optional<Long> minimum();

    public Optional<Long> maximum();

    public Optional<Long> exclusiveMaximum();

    public Optional<Long> exclusiveMinimum();

    @Override
    @Option.Access(value="")
    @Option.Default(value={"INTEGER"})
    public SchemaType schemaType();

    @Override
    default public void generate(Hson.Struct.Builder builder) {
        SchemaItemBlueprint.super.generate(builder);
        this.multipleOf().ifPresent(multipleOf -> builder.set("multipleOf", multipleOf.longValue()));
        this.minimum().ifPresent(minimum -> builder.set("minimum", minimum.longValue()));
        this.maximum().ifPresent(maximum -> builder.set("maximum", maximum.longValue()));
        this.exclusiveMaximum().ifPresent(exclusiveMaximum -> builder.set("exclusiveMaximum", exclusiveMaximum.longValue()));
        this.exclusiveMinimum().ifPresent(exclusiveMinimum -> builder.set("exclusiveMinimum", exclusiveMinimum.longValue()));
    }
}

