/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.json.schema.SchemaIntegerBlueprint;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaSupport;
import io.helidon.json.schema.SchemaType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.json.schema.SchemaIntegerBlueprint")
public interface SchemaInteger
extends SchemaIntegerBlueprint,
Prototype.Api,
SchemaItem {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaInteger instance) {
        return (Builder)SchemaInteger.builder().from(instance);
    }

    public static SchemaInteger create() {
        return SchemaInteger.builder().buildPrototype();
    }

    @Override
    public Optional<Long> multipleOf();

    @Override
    public Optional<Long> minimum();

    @Override
    public Optional<Long> maximum();

    @Override
    public Optional<Long> exclusiveMaximum();

    @Override
    public Optional<Long> exclusiveMinimum();

    public static class Builder
    extends BuilderBase<Builder, SchemaInteger>
    implements io.helidon.common.Builder<Builder, SchemaInteger> {
        private Builder() {
        }

        public SchemaInteger buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SchemaIntegerImpl(this);
        }

        public SchemaInteger build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SchemaInteger>
    extends SchemaItem.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Long exclusiveMaximum;
        private Long exclusiveMinimum;
        private Long maximum;
        private Long minimum;
        private Long multipleOf;

        protected BuilderBase() {
            this.schemaType(SchemaType.INTEGER);
        }

        public BUILDER from(SchemaInteger prototype) {
            super.from(prototype);
            this.multipleOf(prototype.multipleOf());
            this.minimum(prototype.minimum());
            this.maximum(prototype.maximum());
            this.exclusiveMaximum(prototype.exclusiveMaximum());
            this.exclusiveMinimum(prototype.exclusiveMinimum());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.multipleOf().ifPresent(this::multipleOf);
            builder.minimum().ifPresent(this::minimum);
            builder.maximum().ifPresent(this::maximum);
            builder.exclusiveMaximum().ifPresent(this::exclusiveMaximum);
            builder.exclusiveMinimum().ifPresent(this::exclusiveMinimum);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER multipleOf(int value) {
            SchemaSupport.SchemaIntegerCustomMethods.multipleOf(this, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minimum(int value) {
            SchemaSupport.SchemaIntegerCustomMethods.minimum(this, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maximum(int value) {
            SchemaSupport.SchemaIntegerCustomMethods.maximum(this, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exclusiveMaximum(int value) {
            SchemaSupport.SchemaIntegerCustomMethods.exclusiveMaximum(this, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exclusiveMinimum(int value) {
            SchemaSupport.SchemaIntegerCustomMethods.exclusiveMinimum(this, value);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMultipleOf() {
            this.multipleOf = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER multipleOf(long multipleOf) {
            Objects.requireNonNull(multipleOf);
            this.multipleOf = multipleOf;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMinimum() {
            this.minimum = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minimum(long minimum) {
            Objects.requireNonNull(minimum);
            this.minimum = minimum;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaximum() {
            this.maximum = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maximum(long maximum) {
            Objects.requireNonNull(maximum);
            this.maximum = maximum;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExclusiveMaximum() {
            this.exclusiveMaximum = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exclusiveMaximum(long exclusiveMaximum) {
            Objects.requireNonNull(exclusiveMaximum);
            this.exclusiveMaximum = exclusiveMaximum;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExclusiveMinimum() {
            this.exclusiveMinimum = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exclusiveMinimum(long exclusiveMinimum) {
            Objects.requireNonNull(exclusiveMinimum);
            this.exclusiveMinimum = exclusiveMinimum;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Long> multipleOf() {
            return Optional.ofNullable(this.multipleOf);
        }

        public Optional<Long> minimum() {
            return Optional.ofNullable(this.minimum);
        }

        public Optional<Long> maximum() {
            return Optional.ofNullable(this.maximum);
        }

        public Optional<Long> exclusiveMaximum() {
            return Optional.ofNullable(this.exclusiveMaximum);
        }

        public Optional<Long> exclusiveMinimum() {
            return Optional.ofNullable(this.exclusiveMinimum);
        }

        @Override
        public String toString() {
            return "SchemaIntegerBuilder{multipleOf=" + this.multipleOf + ",minimum=" + this.minimum + ",maximum=" + this.maximum + ",exclusiveMaximum=" + this.exclusiveMaximum + ",exclusiveMinimum=" + this.exclusiveMinimum + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            new SchemaSupport.SchemaIntegerDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER multipleOf(Optional<Long> multipleOf) {
            Objects.requireNonNull(multipleOf);
            this.multipleOf = multipleOf.map(Long.class::cast).orElse(this.multipleOf);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER minimum(Optional<Long> minimum) {
            Objects.requireNonNull(minimum);
            this.minimum = minimum.map(Long.class::cast).orElse(this.minimum);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER maximum(Optional<Long> maximum) {
            Objects.requireNonNull(maximum);
            this.maximum = maximum.map(Long.class::cast).orElse(this.maximum);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER exclusiveMaximum(Optional<Long> exclusiveMaximum) {
            Objects.requireNonNull(exclusiveMaximum);
            this.exclusiveMaximum = exclusiveMaximum.map(Long.class::cast).orElse(this.exclusiveMaximum);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER exclusiveMinimum(Optional<Long> exclusiveMinimum) {
            Objects.requireNonNull(exclusiveMinimum);
            this.exclusiveMinimum = exclusiveMinimum.map(Long.class::cast).orElse(this.exclusiveMinimum);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class SchemaIntegerImpl
        extends SchemaItem.BuilderBase.SchemaItemImpl
        implements SchemaInteger {
            private final Optional<Long> exclusiveMaximum;
            private final Optional<Long> exclusiveMinimum;
            private final Optional<Long> maximum;
            private final Optional<Long> minimum;
            private final Optional<Long> multipleOf;

            protected SchemaIntegerImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.multipleOf = builder.multipleOf().map(Function.identity());
                this.minimum = builder.minimum().map(Function.identity());
                this.maximum = builder.maximum().map(Function.identity());
                this.exclusiveMaximum = builder.exclusiveMaximum().map(Function.identity());
                this.exclusiveMinimum = builder.exclusiveMinimum().map(Function.identity());
            }

            @Override
            public Optional<Long> multipleOf() {
                return this.multipleOf;
            }

            @Override
            public Optional<Long> minimum() {
                return this.minimum;
            }

            @Override
            public Optional<Long> maximum() {
                return this.maximum;
            }

            @Override
            public Optional<Long> exclusiveMaximum() {
                return this.exclusiveMaximum;
            }

            @Override
            public Optional<Long> exclusiveMinimum() {
                return this.exclusiveMinimum;
            }

            @Override
            public String toString() {
                return "SchemaInteger{multipleOf=" + String.valueOf(this.multipleOf) + ",minimum=" + String.valueOf(this.minimum) + ",maximum=" + String.valueOf(this.maximum) + ",exclusiveMaximum=" + String.valueOf(this.exclusiveMaximum) + ",exclusiveMinimum=" + String.valueOf(this.exclusiveMinimum) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SchemaInteger)) {
                    return false;
                }
                SchemaInteger other = (SchemaInteger)o;
                return super.equals(other) && Objects.equals(this.multipleOf, other.multipleOf()) && Objects.equals(this.minimum, other.minimum()) && Objects.equals(this.maximum, other.maximum()) && Objects.equals(this.exclusiveMaximum, other.exclusiveMaximum()) && Objects.equals(this.exclusiveMinimum, other.exclusiveMinimum());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.multipleOf, this.minimum, this.maximum, this.exclusiveMaximum, this.exclusiveMinimum);
            }
        }
    }
}

