/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.json.schema.SchemaArray;
import io.helidon.json.schema.SchemaBoolean;
import io.helidon.json.schema.SchemaInteger;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaItemBlueprint;
import io.helidon.json.schema.SchemaNull;
import io.helidon.json.schema.SchemaNumber;
import io.helidon.json.schema.SchemaObject;
import io.helidon.json.schema.SchemaString;
import io.helidon.json.schema.SchemaSupport;
import io.helidon.json.schema.SchemaType;
import io.helidon.metadata.hson.Hson;
import java.util.Optional;

@Prototype.Blueprint(decorator=SchemaSupport.SchemaArrayDecorator.class)
interface SchemaArrayBlueprint
extends SchemaItemBlueprint {
    public Optional<Integer> maxItems();

    public Optional<Integer> minItems();

    public Optional<Boolean> uniqueItems();

    @Option.Access(value="")
    public Optional<SchemaItem> items();

    public Optional<SchemaObject> itemsObject();

    public Optional<SchemaArray> itemsArray();

    public Optional<SchemaNumber> itemsNumber();

    public Optional<SchemaInteger> itemsInteger();

    public Optional<SchemaString> itemsString();

    public Optional<SchemaBoolean> itemsBoolean();

    public Optional<SchemaNull> itemsNull();

    @Override
    @Option.Access(value="")
    @Option.Default(value={"ARRAY"})
    public SchemaType schemaType();

    @Override
    default public void generate(Hson.Struct.Builder builder) {
        SchemaItemBlueprint.super.generate(builder);
        this.maxItems().ifPresent(maxItems -> builder.set("maxItems", maxItems.intValue()));
        this.minItems().ifPresent(minItems -> builder.set("minItems", minItems.intValue()));
        this.uniqueItems().ifPresent(uniqueItems -> builder.set("uniqueItems", uniqueItems.booleanValue()));
        this.items().ifPresent(items -> {
            Hson.Struct.Builder objectBuilder = Hson.structBuilder();
            items.generate(objectBuilder);
            builder.set("items", (Hson.Value)objectBuilder.build());
        });
    }
}

