/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.json.schema.SchemaArrayBlueprint;
import io.helidon.json.schema.SchemaBoolean;
import io.helidon.json.schema.SchemaInteger;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaNull;
import io.helidon.json.schema.SchemaNumber;
import io.helidon.json.schema.SchemaObject;
import io.helidon.json.schema.SchemaString;
import io.helidon.json.schema.SchemaSupport;
import io.helidon.json.schema.SchemaType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.json.schema.SchemaArrayBlueprint")
public interface SchemaArray
extends SchemaArrayBlueprint,
Prototype.Api,
SchemaItem {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SchemaArray instance) {
        return (Builder)SchemaArray.builder().from(instance);
    }

    public static SchemaArray create() {
        return SchemaArray.builder().buildPrototype();
    }

    @Override
    public Optional<Integer> maxItems();

    @Override
    public Optional<Integer> minItems();

    @Override
    public Optional<Boolean> uniqueItems();

    @Override
    public Optional<SchemaItem> items();

    @Override
    public Optional<SchemaObject> itemsObject();

    @Override
    public Optional<SchemaArray> itemsArray();

    @Override
    public Optional<SchemaNumber> itemsNumber();

    @Override
    public Optional<SchemaInteger> itemsInteger();

    @Override
    public Optional<SchemaString> itemsString();

    @Override
    public Optional<SchemaBoolean> itemsBoolean();

    @Override
    public Optional<SchemaNull> itemsNull();

    public static class Builder
    extends BuilderBase<Builder, SchemaArray>
    implements io.helidon.common.Builder<Builder, SchemaArray> {
        private Builder() {
        }

        public SchemaArray buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SchemaArrayImpl(this);
        }

        public SchemaArray build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends SchemaArray>
    extends SchemaItem.BuilderBase<BUILDER, PROTOTYPE>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Boolean uniqueItems;
        private Integer maxItems;
        private Integer minItems;
        private SchemaArray itemsArray;
        private SchemaBoolean itemsBoolean;
        private SchemaInteger itemsInteger;
        private SchemaItem items;
        private SchemaNull itemsNull;
        private SchemaNumber itemsNumber;
        private SchemaObject itemsObject;
        private SchemaString itemsString;

        protected BuilderBase() {
            this.schemaType(SchemaType.ARRAY);
        }

        public BUILDER from(SchemaArray prototype) {
            super.from(prototype);
            this.maxItems(prototype.maxItems());
            this.minItems(prototype.minItems());
            this.uniqueItems(prototype.uniqueItems());
            this.items(prototype.items());
            this.itemsObject(prototype.itemsObject());
            this.itemsArray(prototype.itemsArray());
            this.itemsNumber(prototype.itemsNumber());
            this.itemsInteger(prototype.itemsInteger());
            this.itemsString(prototype.itemsString());
            this.itemsBoolean(prototype.itemsBoolean());
            this.itemsNull(prototype.itemsNull());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Override
        public BUILDER from(BuilderBase<?, ?> builder) {
            super.from(builder);
            builder.maxItems().ifPresent(this::maxItems);
            builder.minItems().ifPresent(this::minItems);
            builder.uniqueItems().ifPresent(this::uniqueItems);
            builder.items().ifPresent(this::items);
            builder.itemsObject().ifPresent(this::itemsObject);
            builder.itemsArray().ifPresent(this::itemsArray);
            builder.itemsNumber().ifPresent(this::itemsNumber);
            builder.itemsInteger().ifPresent(this::itemsInteger);
            builder.itemsString().ifPresent(this::itemsString);
            builder.itemsBoolean().ifPresent(this::itemsBoolean);
            builder.itemsNull().ifPresent(this::itemsNull);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaxItems() {
            this.maxItems = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxItems(int maxItems) {
            Objects.requireNonNull(maxItems);
            this.maxItems = maxItems;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMinItems() {
            this.minItems = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minItems(int minItems) {
            Objects.requireNonNull(minItems);
            this.minItems = minItems;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearUniqueItems() {
            this.uniqueItems = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER uniqueItems(boolean uniqueItems) {
            Objects.requireNonNull(uniqueItems);
            this.uniqueItems = uniqueItems;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearItemsObject() {
            this.itemsObject = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsObject(SchemaObject itemsObject) {
            Objects.requireNonNull(itemsObject);
            this.itemsObject = itemsObject;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsObject(Consumer<SchemaObject.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaObject.Builder builder = SchemaObject.builder();
            consumer.accept(builder);
            this.itemsObject(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearItemsArray() {
            this.itemsArray = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsArray(SchemaArray itemsArray) {
            Objects.requireNonNull(itemsArray);
            this.itemsArray = itemsArray;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsArray(Consumer<Builder> consumer) {
            Objects.requireNonNull(consumer);
            Builder builder = SchemaArray.builder();
            consumer.accept(builder);
            this.itemsArray(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearItemsNumber() {
            this.itemsNumber = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsNumber(SchemaNumber itemsNumber) {
            Objects.requireNonNull(itemsNumber);
            this.itemsNumber = itemsNumber;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsNumber(Consumer<SchemaNumber.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaNumber.Builder builder = SchemaNumber.builder();
            consumer.accept(builder);
            this.itemsNumber(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearItemsInteger() {
            this.itemsInteger = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsInteger(SchemaInteger itemsInteger) {
            Objects.requireNonNull(itemsInteger);
            this.itemsInteger = itemsInteger;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsInteger(Consumer<SchemaInteger.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaInteger.Builder builder = SchemaInteger.builder();
            consumer.accept(builder);
            this.itemsInteger(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearItemsString() {
            this.itemsString = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsString(SchemaString itemsString) {
            Objects.requireNonNull(itemsString);
            this.itemsString = itemsString;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsString(Consumer<SchemaString.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaString.Builder builder = SchemaString.builder();
            consumer.accept(builder);
            this.itemsString(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearItemsBoolean() {
            this.itemsBoolean = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsBoolean(SchemaBoolean itemsBoolean) {
            Objects.requireNonNull(itemsBoolean);
            this.itemsBoolean = itemsBoolean;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsBoolean(Consumer<SchemaBoolean.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaBoolean.Builder builder = SchemaBoolean.builder();
            consumer.accept(builder);
            this.itemsBoolean(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearItemsNull() {
            this.itemsNull = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsNull(SchemaNull itemsNull) {
            Objects.requireNonNull(itemsNull);
            this.itemsNull = itemsNull;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER itemsNull(Consumer<SchemaNull.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaNull.Builder builder = SchemaNull.builder();
            consumer.accept(builder);
            this.itemsNull(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Integer> maxItems() {
            return Optional.ofNullable(this.maxItems);
        }

        public Optional<Integer> minItems() {
            return Optional.ofNullable(this.minItems);
        }

        public Optional<Boolean> uniqueItems() {
            return Optional.ofNullable(this.uniqueItems);
        }

        public Optional<SchemaObject> itemsObject() {
            return Optional.ofNullable(this.itemsObject);
        }

        public Optional<SchemaArray> itemsArray() {
            return Optional.ofNullable(this.itemsArray);
        }

        public Optional<SchemaNumber> itemsNumber() {
            return Optional.ofNullable(this.itemsNumber);
        }

        public Optional<SchemaInteger> itemsInteger() {
            return Optional.ofNullable(this.itemsInteger);
        }

        public Optional<SchemaString> itemsString() {
            return Optional.ofNullable(this.itemsString);
        }

        public Optional<SchemaBoolean> itemsBoolean() {
            return Optional.ofNullable(this.itemsBoolean);
        }

        public Optional<SchemaNull> itemsNull() {
            return Optional.ofNullable(this.itemsNull);
        }

        @Override
        public String toString() {
            return "SchemaArrayBuilder{maxItems=" + this.maxItems + ",minItems=" + this.minItems + ",uniqueItems=" + this.uniqueItems + ",items=" + String.valueOf(this.items) + ",itemsObject=" + String.valueOf(this.itemsObject) + ",itemsArray=" + String.valueOf(this.itemsArray) + ",itemsNumber=" + String.valueOf(this.itemsNumber) + ",itemsInteger=" + String.valueOf(this.itemsInteger) + ",itemsString=" + String.valueOf(this.itemsString) + ",itemsBoolean=" + String.valueOf(this.itemsBoolean) + ",itemsNull=" + String.valueOf(this.itemsNull) + "};" + super.toString();
        }

        @Override
        protected void preBuildPrototype() {
            super.preBuildPrototype();
            new SchemaSupport.SchemaArrayDecorator().decorate(this);
        }

        @Override
        protected void validatePrototype() {
            super.validatePrototype();
        }

        BUILDER maxItems(Optional<Integer> maxItems) {
            Objects.requireNonNull(maxItems);
            this.maxItems = maxItems.map(Integer.class::cast).orElse(this.maxItems);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER minItems(Optional<Integer> minItems) {
            Objects.requireNonNull(minItems);
            this.minItems = minItems.map(Integer.class::cast).orElse(this.minItems);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER uniqueItems(Optional<Boolean> uniqueItems) {
            Objects.requireNonNull(uniqueItems);
            this.uniqueItems = uniqueItems.map(Boolean.class::cast).orElse(this.uniqueItems);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER items(Optional<? extends SchemaItem> items) {
            Objects.requireNonNull(items);
            this.items = items.map(SchemaItem.class::cast).orElse(this.items);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER clearItems() {
            this.items = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER items(SchemaItem items) {
            Objects.requireNonNull(items);
            this.items = items;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER items(Consumer<SchemaItem.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaItem.Builder builder = SchemaItem.builder();
            consumer.accept(builder);
            this.items(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER itemsObject(Optional<? extends SchemaObject> itemsObject) {
            Objects.requireNonNull(itemsObject);
            this.itemsObject = itemsObject.map(SchemaObject.class::cast).orElse(this.itemsObject);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER itemsArray(Optional<? extends SchemaArray> itemsArray) {
            Objects.requireNonNull(itemsArray);
            this.itemsArray = itemsArray.map(SchemaArray.class::cast).orElse(this.itemsArray);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER itemsNumber(Optional<? extends SchemaNumber> itemsNumber) {
            Objects.requireNonNull(itemsNumber);
            this.itemsNumber = itemsNumber.map(SchemaNumber.class::cast).orElse(this.itemsNumber);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER itemsInteger(Optional<? extends SchemaInteger> itemsInteger) {
            Objects.requireNonNull(itemsInteger);
            this.itemsInteger = itemsInteger.map(SchemaInteger.class::cast).orElse(this.itemsInteger);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER itemsString(Optional<? extends SchemaString> itemsString) {
            Objects.requireNonNull(itemsString);
            this.itemsString = itemsString.map(SchemaString.class::cast).orElse(this.itemsString);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER itemsBoolean(Optional<? extends SchemaBoolean> itemsBoolean) {
            Objects.requireNonNull(itemsBoolean);
            this.itemsBoolean = itemsBoolean.map(SchemaBoolean.class::cast).orElse(this.itemsBoolean);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER itemsNull(Optional<? extends SchemaNull> itemsNull) {
            Objects.requireNonNull(itemsNull);
            this.itemsNull = itemsNull.map(SchemaNull.class::cast).orElse(this.itemsNull);
            return (BUILDER)((BuilderBase)this.self());
        }

        Optional<SchemaItem> items() {
            return Optional.ofNullable(this.items);
        }

        protected static class SchemaArrayImpl
        extends SchemaItem.BuilderBase.SchemaItemImpl
        implements SchemaArray {
            private final Optional<SchemaArray> itemsArray;
            private final Optional<SchemaBoolean> itemsBoolean;
            private final Optional<SchemaInteger> itemsInteger;
            private final Optional<SchemaItem> items;
            private final Optional<SchemaNull> itemsNull;
            private final Optional<SchemaNumber> itemsNumber;
            private final Optional<SchemaObject> itemsObject;
            private final Optional<SchemaString> itemsString;
            private final Optional<Boolean> uniqueItems;
            private final Optional<Integer> maxItems;
            private final Optional<Integer> minItems;

            protected SchemaArrayImpl(BuilderBase<?, ?> builder) {
                super(builder);
                this.maxItems = builder.maxItems().map(Function.identity());
                this.minItems = builder.minItems().map(Function.identity());
                this.uniqueItems = builder.uniqueItems().map(Function.identity());
                this.items = builder.items().map(Function.identity());
                this.itemsObject = builder.itemsObject().map(Function.identity());
                this.itemsArray = builder.itemsArray().map(Function.identity());
                this.itemsNumber = builder.itemsNumber().map(Function.identity());
                this.itemsInteger = builder.itemsInteger().map(Function.identity());
                this.itemsString = builder.itemsString().map(Function.identity());
                this.itemsBoolean = builder.itemsBoolean().map(Function.identity());
                this.itemsNull = builder.itemsNull().map(Function.identity());
            }

            @Override
            public Optional<Integer> maxItems() {
                return this.maxItems;
            }

            @Override
            public Optional<Integer> minItems() {
                return this.minItems;
            }

            @Override
            public Optional<Boolean> uniqueItems() {
                return this.uniqueItems;
            }

            @Override
            public Optional<SchemaItem> items() {
                return this.items;
            }

            @Override
            public Optional<SchemaObject> itemsObject() {
                return this.itemsObject;
            }

            @Override
            public Optional<SchemaArray> itemsArray() {
                return this.itemsArray;
            }

            @Override
            public Optional<SchemaNumber> itemsNumber() {
                return this.itemsNumber;
            }

            @Override
            public Optional<SchemaInteger> itemsInteger() {
                return this.itemsInteger;
            }

            @Override
            public Optional<SchemaString> itemsString() {
                return this.itemsString;
            }

            @Override
            public Optional<SchemaBoolean> itemsBoolean() {
                return this.itemsBoolean;
            }

            @Override
            public Optional<SchemaNull> itemsNull() {
                return this.itemsNull;
            }

            @Override
            public String toString() {
                return "SchemaArray{maxItems=" + String.valueOf(this.maxItems) + ",minItems=" + String.valueOf(this.minItems) + ",uniqueItems=" + String.valueOf(this.uniqueItems) + ",items=" + String.valueOf(this.items) + ",itemsObject=" + String.valueOf(this.itemsObject) + ",itemsArray=" + String.valueOf(this.itemsArray) + ",itemsNumber=" + String.valueOf(this.itemsNumber) + ",itemsInteger=" + String.valueOf(this.itemsInteger) + ",itemsString=" + String.valueOf(this.itemsString) + ",itemsBoolean=" + String.valueOf(this.itemsBoolean) + ",itemsNull=" + String.valueOf(this.itemsNull) + "};" + super.toString();
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SchemaArray)) {
                    return false;
                }
                SchemaArray other = (SchemaArray)o;
                return super.equals(other) && Objects.equals(this.maxItems, other.maxItems()) && Objects.equals(this.minItems, other.minItems()) && Objects.equals(this.uniqueItems, other.uniqueItems()) && Objects.equals(this.items, other.items()) && Objects.equals(this.itemsObject, other.itemsObject()) && Objects.equals(this.itemsArray, other.itemsArray()) && Objects.equals(this.itemsNumber, other.itemsNumber()) && Objects.equals(this.itemsInteger, other.itemsInteger()) && Objects.equals(this.itemsString, other.itemsString()) && Objects.equals(this.itemsBoolean, other.itemsBoolean()) && Objects.equals(this.itemsNull, other.itemsNull());
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + Objects.hash(this.maxItems, this.minItems, this.uniqueItems, this.items, this.itemsObject, this.itemsArray, this.itemsNumber, this.itemsInteger, this.itemsString, this.itemsBoolean, this.itemsNull);
            }
        }
    }
}

