/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.schema;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.json.schema.SchemaArray;
import io.helidon.json.schema.SchemaBlueprint;
import io.helidon.json.schema.SchemaBoolean;
import io.helidon.json.schema.SchemaInteger;
import io.helidon.json.schema.SchemaItem;
import io.helidon.json.schema.SchemaNull;
import io.helidon.json.schema.SchemaNumber;
import io.helidon.json.schema.SchemaObject;
import io.helidon.json.schema.SchemaString;
import io.helidon.json.schema.SchemaSupport;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.json.schema.SchemaBlueprint")
public interface Schema
extends SchemaBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Schema instance) {
        return (Builder)Schema.builder().from(instance);
    }

    public static Optional<Schema> find(Class<?> clazz) {
        return SchemaSupport.SchemaCustomMethods.find(clazz);
    }

    public static Schema parse(String jsonSchema) {
        return SchemaSupport.SchemaCustomMethods.parse(jsonSchema);
    }

    public String generate();

    public String generateNoKeywords();

    @Override
    public Optional<URI> id();

    @Override
    public SchemaItem root();

    @Override
    public Optional<SchemaObject> rootObject();

    @Override
    public Optional<SchemaArray> rootArray();

    @Override
    public Optional<SchemaNumber> rootNumber();

    @Override
    public Optional<SchemaInteger> rootInteger();

    @Override
    public Optional<SchemaString> rootString();

    @Override
    public Optional<SchemaBoolean> rootBoolean();

    @Override
    public Optional<SchemaNull> rootNull();

    public static class Builder
    extends BuilderBase<Builder, Schema>
    implements io.helidon.common.Builder<Builder, Schema> {
        private Builder() {
        }

        public Schema buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.SchemaImpl(this);
        }

        public Schema build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Schema>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private SchemaArray rootArray;
        private SchemaBoolean rootBoolean;
        private SchemaInteger rootInteger;
        private SchemaItem root;
        private SchemaNull rootNull;
        private SchemaNumber rootNumber;
        private SchemaObject rootObject;
        private SchemaString rootString;
        private URI id;

        protected BuilderBase() {
        }

        public BUILDER from(Schema prototype) {
            this.id(prototype.id());
            this.root(prototype.root());
            this.rootObject(prototype.rootObject());
            this.rootArray(prototype.rootArray());
            this.rootNumber(prototype.rootNumber());
            this.rootInteger(prototype.rootInteger());
            this.rootString(prototype.rootString());
            this.rootBoolean(prototype.rootBoolean());
            this.rootNull(prototype.rootNull());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.id().ifPresent(this::id);
            builder.root().ifPresent(this::root);
            builder.rootObject().ifPresent(this::rootObject);
            builder.rootArray().ifPresent(this::rootArray);
            builder.rootNumber().ifPresent(this::rootNumber);
            builder.rootInteger().ifPresent(this::rootInteger);
            builder.rootString().ifPresent(this::rootString);
            builder.rootBoolean().ifPresent(this::rootBoolean);
            builder.rootNull().ifPresent(this::rootNull);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootFromSchema(Schema schema) {
            SchemaSupport.SchemaCustomMethods.rootFromSchema(this, schema);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearId() {
            this.id = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER id(URI id) {
            Objects.requireNonNull(id);
            this.id = id;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRootObject() {
            this.rootObject = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootObject(SchemaObject rootObject) {
            Objects.requireNonNull(rootObject);
            this.rootObject = rootObject;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootObject(Consumer<SchemaObject.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaObject.Builder builder = SchemaObject.builder();
            consumer.accept(builder);
            this.rootObject(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRootArray() {
            this.rootArray = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootArray(SchemaArray rootArray) {
            Objects.requireNonNull(rootArray);
            this.rootArray = rootArray;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootArray(Consumer<SchemaArray.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaArray.Builder builder = SchemaArray.builder();
            consumer.accept(builder);
            this.rootArray(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRootNumber() {
            this.rootNumber = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootNumber(SchemaNumber rootNumber) {
            Objects.requireNonNull(rootNumber);
            this.rootNumber = rootNumber;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootNumber(Consumer<SchemaNumber.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaNumber.Builder builder = SchemaNumber.builder();
            consumer.accept(builder);
            this.rootNumber(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRootInteger() {
            this.rootInteger = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootInteger(SchemaInteger rootInteger) {
            Objects.requireNonNull(rootInteger);
            this.rootInteger = rootInteger;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootInteger(Consumer<SchemaInteger.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaInteger.Builder builder = SchemaInteger.builder();
            consumer.accept(builder);
            this.rootInteger(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRootString() {
            this.rootString = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootString(SchemaString rootString) {
            Objects.requireNonNull(rootString);
            this.rootString = rootString;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootString(Consumer<SchemaString.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaString.Builder builder = SchemaString.builder();
            consumer.accept(builder);
            this.rootString(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRootBoolean() {
            this.rootBoolean = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootBoolean(SchemaBoolean rootBoolean) {
            Objects.requireNonNull(rootBoolean);
            this.rootBoolean = rootBoolean;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootBoolean(Consumer<SchemaBoolean.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaBoolean.Builder builder = SchemaBoolean.builder();
            consumer.accept(builder);
            this.rootBoolean(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRootNull() {
            this.rootNull = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootNull(SchemaNull rootNull) {
            Objects.requireNonNull(rootNull);
            this.rootNull = rootNull;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rootNull(Consumer<SchemaNull.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaNull.Builder builder = SchemaNull.builder();
            consumer.accept(builder);
            this.rootNull(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<URI> id() {
            return Optional.ofNullable(this.id);
        }

        public Optional<SchemaObject> rootObject() {
            return Optional.ofNullable(this.rootObject);
        }

        public Optional<SchemaArray> rootArray() {
            return Optional.ofNullable(this.rootArray);
        }

        public Optional<SchemaNumber> rootNumber() {
            return Optional.ofNullable(this.rootNumber);
        }

        public Optional<SchemaInteger> rootInteger() {
            return Optional.ofNullable(this.rootInteger);
        }

        public Optional<SchemaString> rootString() {
            return Optional.ofNullable(this.rootString);
        }

        public Optional<SchemaBoolean> rootBoolean() {
            return Optional.ofNullable(this.rootBoolean);
        }

        public Optional<SchemaNull> rootNull() {
            return Optional.ofNullable(this.rootNull);
        }

        public String toString() {
            return "SchemaBuilder{id=" + String.valueOf(this.id) + ",root=" + String.valueOf(this.root) + ",rootObject=" + String.valueOf(this.rootObject) + ",rootArray=" + String.valueOf(this.rootArray) + ",rootNumber=" + String.valueOf(this.rootNumber) + ",rootInteger=" + String.valueOf(this.rootInteger) + ",rootString=" + String.valueOf(this.rootString) + ",rootBoolean=" + String.valueOf(this.rootBoolean) + ",rootNull=" + String.valueOf(this.rootNull) + "}";
        }

        protected void preBuildPrototype() {
            new SchemaSupport.SchemaDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.root == null) {
                collector.fatal(this.getClass(), "Property \"root\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER id(Optional<? extends URI> id) {
            Objects.requireNonNull(id);
            this.id = id.map(URI.class::cast).orElse(this.id);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER root(SchemaItem root) {
            Objects.requireNonNull(root);
            this.root = root;
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER root(Consumer<SchemaItem.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SchemaItem.Builder builder = SchemaItem.builder();
            consumer.accept(builder);
            this.root(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER root(Supplier<? extends SchemaItem> supplier) {
            Objects.requireNonNull(supplier);
            this.root(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER rootObject(Optional<? extends SchemaObject> rootObject) {
            Objects.requireNonNull(rootObject);
            this.rootObject = rootObject.map(SchemaObject.class::cast).orElse(this.rootObject);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER rootArray(Optional<? extends SchemaArray> rootArray) {
            Objects.requireNonNull(rootArray);
            this.rootArray = rootArray.map(SchemaArray.class::cast).orElse(this.rootArray);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER rootNumber(Optional<? extends SchemaNumber> rootNumber) {
            Objects.requireNonNull(rootNumber);
            this.rootNumber = rootNumber.map(SchemaNumber.class::cast).orElse(this.rootNumber);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER rootInteger(Optional<? extends SchemaInteger> rootInteger) {
            Objects.requireNonNull(rootInteger);
            this.rootInteger = rootInteger.map(SchemaInteger.class::cast).orElse(this.rootInteger);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER rootString(Optional<? extends SchemaString> rootString) {
            Objects.requireNonNull(rootString);
            this.rootString = rootString.map(SchemaString.class::cast).orElse(this.rootString);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER rootBoolean(Optional<? extends SchemaBoolean> rootBoolean) {
            Objects.requireNonNull(rootBoolean);
            this.rootBoolean = rootBoolean.map(SchemaBoolean.class::cast).orElse(this.rootBoolean);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER rootNull(Optional<? extends SchemaNull> rootNull) {
            Objects.requireNonNull(rootNull);
            this.rootNull = rootNull.map(SchemaNull.class::cast).orElse(this.rootNull);
            return (BUILDER)((BuilderBase)this.self());
        }

        Optional<SchemaItem> root() {
            return Optional.ofNullable(this.root);
        }

        protected static class SchemaImpl
        implements Schema {
            private final Optional<SchemaArray> rootArray;
            private final Optional<SchemaBoolean> rootBoolean;
            private final Optional<SchemaInteger> rootInteger;
            private final Optional<SchemaNull> rootNull;
            private final Optional<SchemaNumber> rootNumber;
            private final Optional<SchemaObject> rootObject;
            private final Optional<SchemaString> rootString;
            private final Optional<URI> id;
            private final SchemaItem root;

            protected SchemaImpl(BuilderBase<?, ?> builder) {
                this.id = builder.id().map(Function.identity());
                this.root = builder.root().get();
                this.rootObject = builder.rootObject().map(Function.identity());
                this.rootArray = builder.rootArray().map(Function.identity());
                this.rootNumber = builder.rootNumber().map(Function.identity());
                this.rootInteger = builder.rootInteger().map(Function.identity());
                this.rootString = builder.rootString().map(Function.identity());
                this.rootBoolean = builder.rootBoolean().map(Function.identity());
                this.rootNull = builder.rootNull().map(Function.identity());
            }

            @Override
            public String generate() {
                return SchemaSupport.SchemaCustomMethods.generate(this);
            }

            @Override
            public String generateNoKeywords() {
                return SchemaSupport.SchemaCustomMethods.generateNoKeywords(this);
            }

            @Override
            public Optional<URI> id() {
                return this.id;
            }

            @Override
            public SchemaItem root() {
                return this.root;
            }

            @Override
            public Optional<SchemaObject> rootObject() {
                return this.rootObject;
            }

            @Override
            public Optional<SchemaArray> rootArray() {
                return this.rootArray;
            }

            @Override
            public Optional<SchemaNumber> rootNumber() {
                return this.rootNumber;
            }

            @Override
            public Optional<SchemaInteger> rootInteger() {
                return this.rootInteger;
            }

            @Override
            public Optional<SchemaString> rootString() {
                return this.rootString;
            }

            @Override
            public Optional<SchemaBoolean> rootBoolean() {
                return this.rootBoolean;
            }

            @Override
            public Optional<SchemaNull> rootNull() {
                return this.rootNull;
            }

            public String toString() {
                return "Schema{id=" + String.valueOf(this.id) + ",root=" + String.valueOf(this.root) + ",rootObject=" + String.valueOf(this.rootObject) + ",rootArray=" + String.valueOf(this.rootArray) + ",rootNumber=" + String.valueOf(this.rootNumber) + ",rootInteger=" + String.valueOf(this.rootInteger) + ",rootString=" + String.valueOf(this.rootString) + ",rootBoolean=" + String.valueOf(this.rootBoolean) + ",rootNull=" + String.valueOf(this.rootNull) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Schema)) {
                    return false;
                }
                Schema other = (Schema)o;
                return Objects.equals(this.id, other.id()) && Objects.equals(this.root, other.root()) && Objects.equals(this.rootObject, other.rootObject()) && Objects.equals(this.rootArray, other.rootArray()) && Objects.equals(this.rootNumber, other.rootNumber()) && Objects.equals(this.rootInteger, other.rootInteger()) && Objects.equals(this.rootString, other.rootString()) && Objects.equals(this.rootBoolean, other.rootBoolean()) && Objects.equals(this.rootNull, other.rootNull());
            }

            public int hashCode() {
                return Objects.hash(this.id, this.root, this.rootObject, this.rootArray, this.rootNumber, this.rootInteger, this.rootString, this.rootBoolean, this.rootNull);
            }
        }
    }
}

