/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.types.TypeName;
import io.helidon.json.codegen.FormatInfo;
import io.helidon.json.codegen.JsonPropertyBlueprint;
import io.helidon.json.codegen.JsonPropertyCustomMethods;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.json.codegen.JsonPropertyBlueprint")
interface JsonProperty
extends JsonPropertyBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(JsonProperty instance) {
        return (Builder)JsonProperty.builder().from(instance);
    }

    public static JsonProperty create() {
        return JsonProperty.builder().buildPrototype();
    }

    @Override
    public Optional<String> fieldName();

    @Override
    public Optional<String> getterName();

    @Override
    public Optional<String> setterName();

    @Override
    public Optional<String> deserializationName();

    @Override
    public Optional<String> serializationName();

    @Override
    public Optional<TypeName> deserializationType();

    @Override
    public Optional<TypeName> serializationType();

    @Override
    public Optional<TypeName> deserializer();

    @Override
    public Optional<TypeName> serializer();

    @Override
    public Optional<FormatInfo> dateFormat();

    @Override
    public Optional<FormatInfo> numberFormat();

    @Override
    public boolean fieldIgnored();

    @Override
    public boolean required();

    @Override
    public Optional<Boolean> getterIgnored();

    @Override
    public Optional<Boolean> setterIgnored();

    @Override
    public boolean usedInCreator();

    @Override
    public boolean usedInBuilder();

    @Override
    public boolean directFieldWrite();

    @Override
    public boolean directFieldRead();

    @Override
    public boolean nullable();

    public static class Builder
    extends BuilderBase<Builder, JsonProperty>
    implements io.helidon.common.Builder<Builder, JsonProperty> {
        private Builder() {
        }

        public JsonProperty buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.JsonPropertyImpl(this);
        }

        public JsonProperty build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends JsonProperty>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private Boolean getterIgnored;
        private Boolean setterIgnored;
        private boolean directFieldRead;
        private boolean directFieldWrite;
        private boolean fieldIgnored;
        private boolean nullable;
        private boolean required;
        private boolean usedInBuilder;
        private boolean usedInCreator;
        private FormatInfo dateFormat;
        private FormatInfo numberFormat;
        private String deserializationName;
        private String fieldName;
        private String getterName;
        private String serializationName;
        private String setterName;
        private TypeName deserializationType;
        private TypeName deserializer;
        private TypeName serializationType;
        private TypeName serializer;

        protected BuilderBase() {
        }

        public BUILDER from(JsonProperty prototype) {
            this.fieldName(prototype.fieldName());
            this.getterName(prototype.getterName());
            this.setterName(prototype.setterName());
            this.deserializationName(prototype.deserializationName());
            this.serializationName(prototype.serializationName());
            this.deserializationType(prototype.deserializationType());
            this.serializationType(prototype.serializationType());
            this.deserializer(prototype.deserializer());
            this.serializer(prototype.serializer());
            this.dateFormat(prototype.dateFormat());
            this.numberFormat(prototype.numberFormat());
            this.fieldIgnored(prototype.fieldIgnored());
            this.required(prototype.required());
            this.getterIgnored(prototype.getterIgnored());
            this.setterIgnored(prototype.setterIgnored());
            this.usedInCreator(prototype.usedInCreator());
            this.usedInBuilder(prototype.usedInBuilder());
            this.directFieldWrite(prototype.directFieldWrite());
            this.directFieldRead(prototype.directFieldRead());
            this.nullable(prototype.nullable());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.fieldName().ifPresent(this::fieldName);
            builder.getterName().ifPresent(this::getterName);
            builder.setterName().ifPresent(this::setterName);
            builder.deserializationName().ifPresent(this::deserializationName);
            builder.serializationName().ifPresent(this::serializationName);
            builder.deserializationType().ifPresent(this::deserializationType);
            builder.serializationType().ifPresent(this::serializationType);
            builder.deserializer().ifPresent(this::deserializer);
            builder.serializer().ifPresent(this::serializer);
            builder.dateFormat().ifPresent(this::dateFormat);
            builder.numberFormat().ifPresent(this::numberFormat);
            this.fieldIgnored(builder.fieldIgnored());
            this.required(builder.required());
            builder.getterIgnored().ifPresent(this::getterIgnored);
            builder.setterIgnored().ifPresent(this::setterIgnored);
            this.usedInCreator(builder.usedInCreator());
            this.usedInBuilder(builder.usedInBuilder());
            this.directFieldWrite(builder.directFieldWrite());
            this.directFieldRead(builder.directFieldRead());
            this.nullable(builder.nullable());
            return (BUILDER)((BuilderBase)this.self());
        }

        public <T> BUILDER deserializationNameIfNotSet(String deserializationName) {
            JsonPropertyCustomMethods.deserializationNameIfNotSet(this, deserializationName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public <T> BUILDER serializationNameIfNotSet(String serializationName) {
            JsonPropertyCustomMethods.serializationNameIfNotSet(this, serializationName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFieldName() {
            this.fieldName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fieldName(String fieldName) {
            Objects.requireNonNull(fieldName);
            this.fieldName = fieldName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearGetterName() {
            this.getterName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER getterName(String getterName) {
            Objects.requireNonNull(getterName);
            this.getterName = getterName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSetterName() {
            this.setterName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER setterName(String setterName) {
            Objects.requireNonNull(setterName);
            this.setterName = setterName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDeserializationName() {
            this.deserializationName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deserializationName(String deserializationName) {
            Objects.requireNonNull(deserializationName);
            this.deserializationName = deserializationName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSerializationName() {
            this.serializationName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serializationName(String serializationName) {
            Objects.requireNonNull(serializationName);
            this.serializationName = serializationName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDeserializationType() {
            this.deserializationType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deserializationType(TypeName deserializationType) {
            Objects.requireNonNull(deserializationType);
            this.deserializationType = deserializationType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deserializationType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.deserializationType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deserializationType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.deserializationType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSerializationType() {
            this.serializationType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serializationType(TypeName serializationType) {
            Objects.requireNonNull(serializationType);
            this.serializationType = serializationType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serializationType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.serializationType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serializationType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.serializationType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDeserializer() {
            this.deserializer = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deserializer(TypeName deserializer) {
            Objects.requireNonNull(deserializer);
            this.deserializer = deserializer;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deserializer(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.deserializer(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deserializer(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.deserializer(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSerializer() {
            this.serializer = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serializer(TypeName serializer) {
            Objects.requireNonNull(serializer);
            this.serializer = serializer;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serializer(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.serializer(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serializer(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.serializer(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDateFormat() {
            this.dateFormat = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dateFormat(FormatInfo dateFormat) {
            Objects.requireNonNull(dateFormat);
            this.dateFormat = dateFormat;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearNumberFormat() {
            this.numberFormat = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER numberFormat(FormatInfo numberFormat) {
            Objects.requireNonNull(numberFormat);
            this.numberFormat = numberFormat;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fieldIgnored(boolean fieldIgnored) {
            this.fieldIgnored = fieldIgnored;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER required(boolean required) {
            this.required = required;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearGetterIgnored() {
            this.getterIgnored = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER getterIgnored(boolean getterIgnored) {
            this.getterIgnored = getterIgnored;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSetterIgnored() {
            this.setterIgnored = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER setterIgnored(boolean setterIgnored) {
            this.setterIgnored = setterIgnored;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER usedInCreator(boolean usedInCreator) {
            this.usedInCreator = usedInCreator;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER usedInBuilder(boolean usedInBuilder) {
            this.usedInBuilder = usedInBuilder;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER directFieldWrite(boolean directFieldWrite) {
            this.directFieldWrite = directFieldWrite;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER directFieldRead(boolean directFieldRead) {
            this.directFieldRead = directFieldRead;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER nullable(boolean nullable) {
            this.nullable = nullable;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> fieldName() {
            return Optional.ofNullable(this.fieldName);
        }

        public Optional<String> getterName() {
            return Optional.ofNullable(this.getterName);
        }

        public Optional<String> setterName() {
            return Optional.ofNullable(this.setterName);
        }

        public Optional<String> deserializationName() {
            return Optional.ofNullable(this.deserializationName);
        }

        public Optional<String> serializationName() {
            return Optional.ofNullable(this.serializationName);
        }

        public Optional<TypeName> deserializationType() {
            return Optional.ofNullable(this.deserializationType);
        }

        public Optional<TypeName> serializationType() {
            return Optional.ofNullable(this.serializationType);
        }

        public Optional<TypeName> deserializer() {
            return Optional.ofNullable(this.deserializer);
        }

        public Optional<TypeName> serializer() {
            return Optional.ofNullable(this.serializer);
        }

        public Optional<FormatInfo> dateFormat() {
            return Optional.ofNullable(this.dateFormat);
        }

        public Optional<FormatInfo> numberFormat() {
            return Optional.ofNullable(this.numberFormat);
        }

        public boolean fieldIgnored() {
            return this.fieldIgnored;
        }

        public boolean required() {
            return this.required;
        }

        public Optional<Boolean> getterIgnored() {
            return Optional.ofNullable(this.getterIgnored);
        }

        public Optional<Boolean> setterIgnored() {
            return Optional.ofNullable(this.setterIgnored);
        }

        public boolean usedInCreator() {
            return this.usedInCreator;
        }

        public boolean usedInBuilder() {
            return this.usedInBuilder;
        }

        public boolean directFieldWrite() {
            return this.directFieldWrite;
        }

        public boolean directFieldRead() {
            return this.directFieldRead;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public String toString() {
            return "JsonPropertyBuilder{fieldName=" + this.fieldName + ",getterName=" + this.getterName + ",setterName=" + this.setterName + ",deserializationName=" + this.deserializationName + ",serializationName=" + this.serializationName + ",deserializationType=" + String.valueOf(this.deserializationType) + ",serializationType=" + String.valueOf(this.serializationType) + ",deserializer=" + String.valueOf(this.deserializer) + ",serializer=" + String.valueOf(this.serializer) + ",dateFormat=" + String.valueOf(this.dateFormat) + ",numberFormat=" + String.valueOf(this.numberFormat) + ",fieldIgnored=" + this.fieldIgnored + ",required=" + this.required + ",getterIgnored=" + this.getterIgnored + ",setterIgnored=" + this.setterIgnored + ",usedInCreator=" + this.usedInCreator + ",usedInBuilder=" + this.usedInBuilder + ",directFieldWrite=" + this.directFieldWrite + ",directFieldRead=" + this.directFieldRead + ",nullable=" + this.nullable + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER fieldName(Optional<String> fieldName) {
            Objects.requireNonNull(fieldName);
            this.fieldName = fieldName.orElse(this.fieldName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER getterName(Optional<String> getterName) {
            Objects.requireNonNull(getterName);
            this.getterName = getterName.orElse(this.getterName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER setterName(Optional<String> setterName) {
            Objects.requireNonNull(setterName);
            this.setterName = setterName.orElse(this.setterName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER deserializationName(Optional<String> deserializationName) {
            Objects.requireNonNull(deserializationName);
            this.deserializationName = deserializationName.orElse(this.deserializationName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER serializationName(Optional<String> serializationName) {
            Objects.requireNonNull(serializationName);
            this.serializationName = serializationName.orElse(this.serializationName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER deserializationType(Optional<? extends TypeName> deserializationType) {
            Objects.requireNonNull(deserializationType);
            this.deserializationType = deserializationType.map(TypeName.class::cast).orElse(this.deserializationType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER serializationType(Optional<? extends TypeName> serializationType) {
            Objects.requireNonNull(serializationType);
            this.serializationType = serializationType.map(TypeName.class::cast).orElse(this.serializationType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER deserializer(Optional<? extends TypeName> deserializer) {
            Objects.requireNonNull(deserializer);
            this.deserializer = deserializer.map(TypeName.class::cast).orElse(this.deserializer);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER serializer(Optional<? extends TypeName> serializer) {
            Objects.requireNonNull(serializer);
            this.serializer = serializer.map(TypeName.class::cast).orElse(this.serializer);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER dateFormat(Optional<? extends FormatInfo> dateFormat) {
            Objects.requireNonNull(dateFormat);
            this.dateFormat = dateFormat.map(FormatInfo.class::cast).orElse(this.dateFormat);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER numberFormat(Optional<? extends FormatInfo> numberFormat) {
            Objects.requireNonNull(numberFormat);
            this.numberFormat = numberFormat.map(FormatInfo.class::cast).orElse(this.numberFormat);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER getterIgnored(Optional<Boolean> getterIgnored) {
            Objects.requireNonNull(getterIgnored);
            this.getterIgnored = getterIgnored.orElse(this.getterIgnored);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER setterIgnored(Optional<Boolean> setterIgnored) {
            Objects.requireNonNull(setterIgnored);
            this.setterIgnored = setterIgnored.orElse(this.setterIgnored);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class JsonPropertyImpl
        implements JsonProperty {
            private final boolean directFieldRead;
            private final boolean directFieldWrite;
            private final boolean fieldIgnored;
            private final boolean nullable;
            private final boolean required;
            private final boolean usedInBuilder;
            private final boolean usedInCreator;
            private final Optional<TypeName> deserializationType;
            private final Optional<TypeName> deserializer;
            private final Optional<TypeName> serializationType;
            private final Optional<TypeName> serializer;
            private final Optional<FormatInfo> dateFormat;
            private final Optional<FormatInfo> numberFormat;
            private final Optional<Boolean> getterIgnored;
            private final Optional<Boolean> setterIgnored;
            private final Optional<String> deserializationName;
            private final Optional<String> fieldName;
            private final Optional<String> getterName;
            private final Optional<String> serializationName;
            private final Optional<String> setterName;

            protected JsonPropertyImpl(BuilderBase<?, ?> builder) {
                this.fieldName = builder.fieldName().map(Function.identity());
                this.getterName = builder.getterName().map(Function.identity());
                this.setterName = builder.setterName().map(Function.identity());
                this.deserializationName = builder.deserializationName().map(Function.identity());
                this.serializationName = builder.serializationName().map(Function.identity());
                this.deserializationType = builder.deserializationType().map(Function.identity());
                this.serializationType = builder.serializationType().map(Function.identity());
                this.deserializer = builder.deserializer().map(Function.identity());
                this.serializer = builder.serializer().map(Function.identity());
                this.dateFormat = builder.dateFormat().map(Function.identity());
                this.numberFormat = builder.numberFormat().map(Function.identity());
                this.fieldIgnored = builder.fieldIgnored();
                this.required = builder.required();
                this.getterIgnored = builder.getterIgnored().map(Function.identity());
                this.setterIgnored = builder.setterIgnored().map(Function.identity());
                this.usedInCreator = builder.usedInCreator();
                this.usedInBuilder = builder.usedInBuilder();
                this.directFieldWrite = builder.directFieldWrite();
                this.directFieldRead = builder.directFieldRead();
                this.nullable = builder.nullable();
            }

            @Override
            public Optional<String> fieldName() {
                return this.fieldName;
            }

            @Override
            public Optional<String> getterName() {
                return this.getterName;
            }

            @Override
            public Optional<String> setterName() {
                return this.setterName;
            }

            @Override
            public Optional<String> deserializationName() {
                return this.deserializationName;
            }

            @Override
            public Optional<String> serializationName() {
                return this.serializationName;
            }

            @Override
            public Optional<TypeName> deserializationType() {
                return this.deserializationType;
            }

            @Override
            public Optional<TypeName> serializationType() {
                return this.serializationType;
            }

            @Override
            public Optional<TypeName> deserializer() {
                return this.deserializer;
            }

            @Override
            public Optional<TypeName> serializer() {
                return this.serializer;
            }

            @Override
            public Optional<FormatInfo> dateFormat() {
                return this.dateFormat;
            }

            @Override
            public Optional<FormatInfo> numberFormat() {
                return this.numberFormat;
            }

            @Override
            public boolean fieldIgnored() {
                return this.fieldIgnored;
            }

            @Override
            public boolean required() {
                return this.required;
            }

            @Override
            public Optional<Boolean> getterIgnored() {
                return this.getterIgnored;
            }

            @Override
            public Optional<Boolean> setterIgnored() {
                return this.setterIgnored;
            }

            @Override
            public boolean usedInCreator() {
                return this.usedInCreator;
            }

            @Override
            public boolean usedInBuilder() {
                return this.usedInBuilder;
            }

            @Override
            public boolean directFieldWrite() {
                return this.directFieldWrite;
            }

            @Override
            public boolean directFieldRead() {
                return this.directFieldRead;
            }

            @Override
            public boolean nullable() {
                return this.nullable;
            }

            public String toString() {
                return "JsonProperty{fieldName=" + String.valueOf(this.fieldName) + ",getterName=" + String.valueOf(this.getterName) + ",setterName=" + String.valueOf(this.setterName) + ",deserializationName=" + String.valueOf(this.deserializationName) + ",serializationName=" + String.valueOf(this.serializationName) + ",deserializationType=" + String.valueOf(this.deserializationType) + ",serializationType=" + String.valueOf(this.serializationType) + ",deserializer=" + String.valueOf(this.deserializer) + ",serializer=" + String.valueOf(this.serializer) + ",dateFormat=" + String.valueOf(this.dateFormat) + ",numberFormat=" + String.valueOf(this.numberFormat) + ",fieldIgnored=" + this.fieldIgnored + ",required=" + this.required + ",getterIgnored=" + String.valueOf(this.getterIgnored) + ",setterIgnored=" + String.valueOf(this.setterIgnored) + ",usedInCreator=" + this.usedInCreator + ",usedInBuilder=" + this.usedInBuilder + ",directFieldWrite=" + this.directFieldWrite + ",directFieldRead=" + this.directFieldRead + ",nullable=" + this.nullable + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof JsonProperty)) {
                    return false;
                }
                JsonProperty other = (JsonProperty)o;
                return Objects.equals(this.fieldName, other.fieldName()) && Objects.equals(this.getterName, other.getterName()) && Objects.equals(this.setterName, other.setterName()) && Objects.equals(this.deserializationName, other.deserializationName()) && Objects.equals(this.serializationName, other.serializationName()) && Objects.equals(this.deserializationType, other.deserializationType()) && Objects.equals(this.serializationType, other.serializationType()) && Objects.equals(this.deserializer, other.deserializer()) && Objects.equals(this.serializer, other.serializer()) && Objects.equals(this.dateFormat, other.dateFormat()) && Objects.equals(this.numberFormat, other.numberFormat()) && this.fieldIgnored == other.fieldIgnored() && this.required == other.required() && Objects.equals(this.getterIgnored, other.getterIgnored()) && Objects.equals(this.setterIgnored, other.setterIgnored()) && this.usedInCreator == other.usedInCreator() && this.usedInBuilder == other.usedInBuilder() && this.directFieldWrite == other.directFieldWrite() && this.directFieldRead == other.directFieldRead() && this.nullable == other.nullable();
            }

            public int hashCode() {
                return Objects.hash(this.fieldName, this.getterName, this.setterName, this.deserializationName, this.serializationName, this.deserializationType, this.serializationType, this.deserializer, this.serializer, this.dateFormat, this.numberFormat, this.fieldIgnored, this.required, this.getterIgnored, this.setterIgnored, this.usedInCreator, this.usedInBuilder, this.directFieldWrite, this.directFieldRead, this.nullable);
            }
        }
    }
}

