/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.codegen;

import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.Executable;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.json.codegen.BuilderInfo;
import io.helidon.json.codegen.ConvertedTypeInfo;
import io.helidon.json.codegen.CreatorInfo;
import io.helidon.json.codegen.JsonProperty;
import io.helidon.json.codegen.JsonTypes;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class JsonConverterGenerator {
    static final String CONFIGURE_PARAM = "jsonBindingConfigurator";
    private static final int FNV_OFFSET_BASIS = -2128831035;
    private static final int FNV_PRIME = 16777619;
    private static final String PROPERTY_NAME_SUFFIX = "_";
    private static final String MISSING_SUFFIX = "_missing";
    private static final Supplier<?> DEFAULT_TYPE_VALUE = () -> null;
    private static final Map<TypeName, Supplier<?>> DEFAULT_TYPE_VALUES = Map.of(TypeNames.PRIMITIVE_BOOLEAN, () -> false, TypeNames.PRIMITIVE_BYTE, () -> 0, TypeNames.PRIMITIVE_SHORT, () -> 0, TypeNames.PRIMITIVE_INT, () -> 0, TypeNames.PRIMITIVE_LONG, () -> 0, TypeNames.PRIMITIVE_FLOAT, () -> "0.0F", TypeNames.PRIMITIVE_DOUBLE, () -> "0.0");
    private static final String WRITE_NULLS = "writeNulls";

    private JsonConverterGenerator() {
    }

    static void generateConverter(ClassBase.Builder<?, ?> classBuilder, ConvertedTypeInfo converterInfo, boolean factory) {
        TypeName converterInterfaceType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JsonTypes.JSON_CONVERTER_TYPE)).addTypeArgument(converterInfo.wildcardsGenerics())).build();
        HashMap toConfigure = new HashMap();
        ((ClassBase.Builder)classBuilder.name(converterInfo.converterType().className())).addInterface(converterInterfaceType).javadoc(Javadoc.builder().add("Json converter for {@link " + converterInfo.originalType().fqName() + "}.").build()).addMethod(method -> JsonConverterGenerator.generateToJsonMethod(classBuilder, method, converterInfo, toConfigure)).addMethod(method -> JsonConverterGenerator.generateFromJsonMethod(classBuilder, method, converterInfo, toConfigure));
        if (factory) {
            classBuilder.addMethod(method -> JsonConverterGenerator.addConfigurationFactory(method, toConfigure, converterInfo));
            classBuilder.addMethod(method -> JsonConverterGenerator.addTypeMethodFactory(method, converterInfo));
        } else {
            classBuilder.addMethod(method -> JsonConverterGenerator.addConfigurationMethod(method, toConfigure));
            classBuilder.addMethod(method -> JsonConverterGenerator.addTypeMethod(method, converterInfo));
        }
    }

    private static void addConfigurationMethod(Method.Builder method, Map<String, TypeToConfigure> toConfigure) {
        ((Method.Builder)((Method.Builder)method.name("configure")).addAnnotation(Annotation.create(Override.class))).addParameter(param -> param.type(JsonTypes.JSON_BINDING_CONFIGURATOR).name(CONFIGURE_PARAM));
        JsonConverterGenerator.initializeNoRuntimeResolving(method, toConfigure);
    }

    private static void addConfigurationFactory(Method.Builder method, Map<String, TypeToConfigure> toConfigure, ConvertedTypeInfo convertedTypeInfo) {
        String obtainMethod;
        TypeName typeName;
        String fieldName;
        ((Method.Builder)((Method.Builder)method.name("configure")).addAnnotation(Annotation.create(Override.class))).addParameter(builder -> builder.type(JsonTypes.JSON_BINDING_CONFIGURATOR).name(CONFIGURE_PARAM));
        JsonConverterGenerator.initializeNoRuntimeResolving(method, toConfigure);
        List<TypeToConfigure> needsRuntimeResolving = toConfigure.values().stream().filter(it -> ConvertedTypeInfo.needsResolving(it.resolved)).toList();
        ((Method.Builder)((Method.Builder)method.addContent("if (type instanceof ")).addContent(ParameterizedType.class)).addContentLine(" parameterizedType) {");
        HashMap<String, Consumer<Method.Builder>> createdTypeSetters = new HashMap<String, Consumer<Method.Builder>>();
        MethodNameCounter counter = new MethodNameCounter();
        Map<TypeName, Integer> paramIndexes = convertedTypeInfo.genericParamsWithIndexes();
        for (TypeToConfigure typeToConfigure : needsRuntimeResolving) {
            Consumer<Method.Builder> builderConsumer;
            fieldName = typeToConfigure.fieldName();
            typeName = typeToConfigure.resolved;
            obtainMethod = typeToConfigure.mode.method;
            if (typeName.generic()) {
                int index = paramIndexes.get(typeName);
                ((Method.Builder)method.addContent(fieldName + " = jsonBindingConfigurator." + obtainMethod + "(")).addContentLine("parameterizedType.getActualTypeArguments()[" + index + "]);");
                continue;
            }
            if (createdTypeSetters.containsKey(typeName.resolvedName())) {
                builderConsumer = (Consumer<Method.Builder>)createdTypeSetters.get(typeName.resolvedName());
            } else {
                builderConsumer = JsonConverterGenerator.constructComplexGenericType(method, typeName, createdTypeSetters, counter, convertedTypeInfo);
                createdTypeSetters.put(typeName.resolvedName(), builderConsumer);
            }
            method.addContent(fieldName + " = jsonBindingConfigurator." + obtainMethod + "(");
            builderConsumer.accept(method);
            method.addContentLine(");");
        }
        ((Method.Builder)method.addContent("}")).addContentLine(" else {");
        for (TypeToConfigure typeToConfigure : needsRuntimeResolving) {
            fieldName = typeToConfigure.fieldName();
            typeName = typeToConfigure.resolved;
            obtainMethod = typeToConfigure.mode.method;
            if (typeName.typeArguments().isEmpty()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(fieldName + " = (")).addContent(typeToConfigure.fieldType)).addContent(") jsonBindingConfigurator." + obtainMethod + "(")).addContent(Object.class)).addContentLine(".class);");
                continue;
            }
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(fieldName + " = jsonBindingConfigurator." + obtainMethod + "(")).addContent("new ")).addContent(TypeNames.GENERIC_TYPE)).addContent("<");
            JsonConverterGenerator.buildSimpleGenericTypeWithObject(method, typeName);
            method.addContentLine(">() {});");
        }
        method.addContentLine("}");
    }

    private static void buildSimpleGenericTypeWithObject(Method.Builder method, TypeName typeName) {
        if (typeName.typeArguments().isEmpty()) {
            method.addContent(typeName);
        } else {
            boolean first = true;
            ((Method.Builder)method.addContent(typeName.genericTypeName())).addContent("<");
            for (TypeName typeArgument : typeName.typeArguments()) {
                if (first) {
                    first = false;
                } else {
                    method.addContent(",");
                }
                JsonConverterGenerator.buildSimpleGenericTypeWithObject(method, typeArgument);
            }
            method.addContent(">");
        }
    }

    private static Consumer<Method.Builder> constructComplexGenericType(Method.Builder method, TypeName typeName, Map<String, Consumer<Method.Builder>> createdTypeSetters, MethodNameCounter counter, ConvertedTypeInfo convertedTypeInfo) {
        Map<TypeName, Integer> paramIndexes = convertedTypeInfo.genericParamsWithIndexes();
        if (typeName.typeArguments().isEmpty()) {
            if (ConvertedTypeInfo.needsResolving(typeName)) {
                int index = paramIndexes.get(typeName);
                return builder -> ((Method.Builder)builder.addContent(TypeNames.GENERIC_TYPE)).addContent(".create(parameterizedType.getActualTypeArguments()[" + index + "])");
            }
            return builder -> ((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent(TypeNames.GENERIC_TYPE)).addContent(".create(")).addContent(typeName)).addContent(")");
        }
        ArrayList<Consumer> parameterValueSetters = new ArrayList<Consumer>();
        for (TypeName typeArgument : typeName.typeArguments()) {
            if (createdTypeSetters.containsKey(typeArgument.resolvedName())) {
                parameterValueSetters.add(createdTypeSetters.get(typeArgument.resolvedName()));
                continue;
            }
            Consumer parameterValue = JsonConverterGenerator.constructComplexGenericType(method, typeArgument, createdTypeSetters, counter, convertedTypeInfo);
            parameterValueSetters.add(parameterValue);
            createdTypeSetters.putIfAbsent(typeArgument.resolvedName(), parameterValue);
        }
        String variableName = "genericType" + counter.count++;
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent("var " + variableName + " = ")).addContent(TypeNames.GENERIC_TYPE)).addContent(".<")).addContent(typeName)).addContentLine(">builder()")).increaseContentPadding()).increaseContentPadding()).addContent(".baseType(")).addContent(typeName.genericTypeName())).addContentLine(".class)");
        for (Consumer parameterValue : parameterValueSetters) {
            method.addContent(".addGenericParameter(");
            parameterValue.accept(method);
            method.addContentLine(")");
        }
        ((Method.Builder)((Method.Builder)method.addContentLine(".build();")).decreaseContentPadding()).decreaseContentPadding();
        return builder -> builder.addContent(variableName);
    }

    private static void initializeNoRuntimeResolving(Executable.Builder<?, ?> method, Map<String, TypeToConfigure> toConfigure) {
        List<TypeToConfigure> doNotNeedRuntimeResolving = toConfigure.values().stream().filter(Predicate.not(it -> ConvertedTypeInfo.needsResolving(it.resolved))).toList();
        for (TypeToConfigure typeToConfigure : doNotNeedRuntimeResolving) {
            TypeName typeName = typeToConfigure.original;
            String fieldName = typeToConfigure.fieldName();
            String obtainMethod = typeToConfigure.mode.method;
            if (typeName.typeArguments().isEmpty()) {
                method.addContent(fieldName + " = jsonBindingConfigurator." + obtainMethod + "(").addContent(typeName).addContentLine(".class);");
                continue;
            }
            method.addContent(fieldName + " = jsonBindingConfigurator." + obtainMethod + "(new ").addContent(TypeNames.GENERIC_TYPE).addContent("<").addContent(typeName).addContentLine(">() {});");
        }
    }

    private static void generateToJsonMethod(ClassBase.Builder<?, ?> classBuilder, Method.Builder method, ConvertedTypeInfo converterInfo, Map<String, TypeToConfigure> toConfigure) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name("serialize")).addParameter(param -> ((Parameter.Builder)param.name("generator")).type(JsonTypes.JSON_GENERATOR))).addParameter(param -> ((Parameter.Builder)param.name("instance")).type(converterInfo.wildcardsGenerics()))).addParameter(param -> ((Parameter.Builder)param.name(WRITE_NULLS)).type(Boolean.TYPE))).addAnnotation(Annotation.create(Override.class))).addContentLine("generator.writeObjectStart();");
        List<JsonProperty> jsonProperties = converterInfo.jsonProperties().values().stream().filter(JsonConverterGenerator::usableForSerialization).sorted((o1, o2) -> converterInfo.orderedProperties().compare(o1.serializationName().orElseThrow(), o2.serializationName().orElseThrow())).toList();
        HashSet createdSerializers = new HashSet();
        for (JsonProperty jsonProperty : jsonProperties) {
            String fieldName = jsonProperty.serializer().map(serializer -> {
                String constantName = JsonConverterGenerator.constantName(jsonProperty.serializationName().orElseThrow()) + "_SERIALIZER";
                classBuilder.addField(field -> ((Field.Builder)field.name(constantName)).type(serializer).isStatic(true).isFinal(true).addContent("new ").addContent(serializer).addContent("()"));
                return constantName;
            }).orElseGet(() -> {
                TypeName type = jsonProperty.serializationType().orElseThrow();
                TypeName resolved = type.boxed();
                String fn = !resolved.typeArguments().isEmpty() ? "serializer" + JsonConverterGenerator.ensureUpperStart(jsonProperty.serializationName().orElseThrow()) : "serializer" + JsonConverterGenerator.ensureUpperStart(type);
                if (!createdSerializers.contains(fn)) {
                    TypeName serializerArgument = resolved.generic() ? TypeNames.OBJECT : resolved;
                    createdSerializers.add(fn);
                    TypeName converterType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JsonTypes.JSON_SERIALIZER_TYPE)).addTypeArgument(serializerArgument)).build();
                    classBuilder.addField(fieldBuilder -> ((Field.Builder)fieldBuilder.name(fn)).isVolatile(true).type(converterType));
                    toConfigure.putIfAbsent(fn, new TypeToConfigure(TypeConfigMode.SERIALIZATION, fn, resolved, type, converterType));
                }
                return fn;
            });
            String accessor = jsonProperty.getterName().filter(getterName -> jsonProperty.getterIgnored().orElse(false) == false).map(getterName -> getterName + "()").or(jsonProperty::fieldName).orElseThrow();
            String key = jsonProperty.serializationName().orElseThrow();
            ((Method.Builder)method.addContent(JsonTypes.JSON_SERIALIZERS)).addContentLine(".serialize(generator, " + fieldName + ", instance." + accessor + ", \"" + key + "\", " + jsonProperty.nullable() + ");");
        }
        method.addContentLine("generator.writeObjectEnd();");
    }

    private static boolean usableForSerialization(JsonProperty property) {
        if (property.getterIgnored().isPresent() && property.getterIgnored().get().booleanValue() || property.getterName().isEmpty()) {
            return !property.fieldIgnored() && property.directFieldRead();
        }
        if (property.fieldIgnored()) {
            return false;
        }
        return property.getterName().isPresent();
    }

    private static void generateFromJsonMethod(ClassBase.Builder<?, ?> classBuilder, Method.Builder method, ConvertedTypeInfo converterInfo, Map<String, TypeToConfigure> toConfigure) {
        CreatorInfo creatorInfo = converterInfo.creatorInfo();
        ElementKind creatorKind = creatorInfo.creatorKind();
        boolean hasCreator = creatorKind != null && !creatorInfo.parameters().isEmpty();
        boolean hasBuilder = converterInfo.builderInfo().isPresent();
        List<JsonProperty> jsonProperties = converterInfo.jsonProperties().values().stream().filter(JsonConverterGenerator::usableForDeserialization).toList();
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name("deserialize")).returnType(converterInfo.wildcardsGenerics()).addParameter(param -> ((Parameter.Builder)param.name("parser")).type(JsonTypes.JSON_PARSER))).addAnnotation(Annotation.create(Override.class))).addContent(Byte.TYPE)).addContentLine(" lastByte = parser.currentByte();")).addContent("if (lastByte != ")).addContent(JsonTypes.BYTES)).addContentLine(".BRACE_OPEN_BYTE) {")).addContentLine("throw parser.createException(\"Expected '{' to start an object\", lastByte);")).addContentLine("}")).addContentLine("lastByte = parser.nextToken();");
        JsonConverterGenerator.createPreProcessingVariables(method, converterInfo, jsonProperties, hasCreator, creatorKind, creatorInfo, hasBuilder);
        JsonConverterGenerator.earlyReturnForEmptyObjects(method, converterInfo, jsonProperties, hasCreator, creatorKind, creatorInfo, hasBuilder);
        JsonConverterGenerator.propertyProcessing(classBuilder, method, converterInfo, toConfigure, jsonProperties, hasCreator, hasBuilder);
        JsonConverterGenerator.createFinalInstanceCreation(method, converterInfo, jsonProperties, hasCreator, creatorKind, creatorInfo, hasBuilder);
    }

    private static boolean usableForDeserialization(JsonProperty property) {
        if (property.setterIgnored().isPresent() && property.setterIgnored().get().booleanValue() || property.setterName().isEmpty()) {
            if (property.fieldIgnored()) {
                return false;
            }
            if (property.usedInBuilder() || property.usedInCreator()) {
                return true;
            }
            return property.directFieldWrite();
        }
        if (property.fieldIgnored()) {
            return false;
        }
        return property.setterName().isPresent();
    }

    private static void createFinalInstanceCreation(Method.Builder method, ConvertedTypeInfo converterInfo, List<JsonProperty> jsonProperties, boolean hasCreator, ElementKind creatorKind, CreatorInfo creatorInfo, boolean hasBuilder) {
        jsonProperties.stream().filter(JsonProperty::required).forEach(property -> {
            String name = JsonConverterGenerator.convertToMissingName(property);
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContentLine("if (" + name + ") {")).addContent("throw parser.createException(\"Property \\\"")).addContent(property.deserializationName().orElseThrow())).addContentLine("\\\" was required to be present in the JSON, but was missing.\");")).addContentLine("}");
        });
        if (hasCreator) {
            TypeName originalType = converterInfo.objectsGenerics();
            if (creatorKind == ElementKind.METHOD) {
                ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(originalType)).addContent(" instance = ")).addContent(originalType)).addContent("." + creatorInfo.method() + "(");
            } else {
                ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(originalType)).addContent(" instance = new ")).addContent(originalType)).addContent("(");
            }
            String properties = jsonProperties.stream().filter(JsonProperty::usedInCreator).map(property -> property.deserializationName().orElseThrow() + PROPERTY_NAME_SUFFIX).collect(Collectors.joining(", "));
            ((Method.Builder)method.addContent(properties)).addContentLine(");");
            for (JsonProperty property2 : jsonProperties) {
                if (property2.usedInCreator()) continue;
                if (property2.directFieldWrite()) {
                    method.addContentLine("instance." + property2.fieldName().orElseThrow() + " = " + property2.deserializationName().orElseThrow() + "_;");
                    continue;
                }
                method.addContentLine("instance." + property2.setterName().orElseThrow() + "(" + property2.deserializationName().orElseThrow() + "_);");
            }
        } else if (hasBuilder) {
            BuilderInfo builderInfo = converterInfo.builderInfo().get();
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(converterInfo.objectsGenerics())).addContent(" instance = builder.")).addContent(builderInfo.buildMethodName())).addContentLine("();");
            for (JsonProperty property3 : jsonProperties) {
                if (property3.usedInBuilder()) continue;
                if (property3.directFieldWrite()) {
                    method.addContentLine("instance." + property3.fieldName().orElseThrow() + " = " + property3.deserializationName().orElseThrow() + "_;");
                    continue;
                }
                method.addContentLine("instance." + property3.setterName().orElseThrow() + "(" + property3.deserializationName().orElseThrow() + "_);");
            }
        }
        method.addContentLine("return instance;");
    }

    private static void propertyProcessing(ClassBase.Builder<?, ?> classBuilder, Method.Builder method, ConvertedTypeInfo converterInfo, Map<String, TypeToConfigure> toConfigure, List<JsonProperty> jsonProperties, boolean hasCreator, boolean hasBuilder) {
        boolean hasProperties = !jsonProperties.isEmpty();
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContentLine("while(true) {")).addContent("if (lastByte != ")).addContent(JsonTypes.BYTES)).addContentLine(".DOUBLE_QUOTE_BYTE) {")).addContentLine("throw parser.createException(\"Expected '\\\"' as a key start\", lastByte);")).addContentLine("}");
        if (hasProperties) {
            ((Method.Builder)method.addContent(Integer.TYPE)).addContentLine(" hash = parser.readStringAsHash();");
        } else {
            method.addContentLine("parser.skip();");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContentLine("lastByte = parser.nextToken();")).addContent("if (lastByte != ")).addContent(JsonTypes.BYTES)).addContentLine(".COLON_BYTE) {")).addContentLine("throw parser.createException(\"Expected ':' to separate key and value\", lastByte);")).addContentLine("}")).addContentLine("parser.nextToken();");
        if (hasProperties) {
            boolean switchUsed;
            boolean bl = switchUsed = jsonProperties.size() > 9;
            if (switchUsed) {
                method.addContentLine("switch(hash) {");
            }
            Map<Integer, List<JsonProperty>> hashes = jsonProperties.stream().collect(Collectors.groupingBy(jsonProperty -> JsonConverterGenerator.calculateNameHash(jsonProperty.deserializationName().orElseThrow())));
            HashSet<String> processedTypes = new HashSet<String>();
            boolean first = true;
            for (Map.Entry<Integer, List<JsonProperty>> entry : hashes.entrySet()) {
                if (entry.getValue().size() > 1) {
                    throw new UnsupportedOperationException("Naming collision, not implemented yet");
                }
                JsonProperty jsonProperty2 = entry.getValue().getFirst();
                String constantName = JsonConverterGenerator.constantName(jsonProperty2.deserializationName().orElseThrow());
                classBuilder.addField(builder -> ((Field.Builder)builder.isFinal(true).isStatic(true).type(Integer.TYPE).name(constantName)).defaultValue(String.valueOf(entry.getKey())));
                if (switchUsed) {
                    method.addContentLine("case " + constantName + ":");
                    method.increaseContentPadding();
                } else if (first) {
                    method.addContentLine("if (hash == " + constantName + ") {");
                    first = false;
                } else {
                    method.addContentLine(" else if (hash == " + constantName + ") {");
                }
                JsonConverterGenerator.addTypeHandling(jsonProperty2, method, classBuilder, hasCreator, hasBuilder, processedTypes, toConfigure);
                if (!switchUsed) {
                    method.addContent("}");
                    continue;
                }
                method.addContentLine("break;");
                method.decreaseContentPadding();
            }
            if (switchUsed) {
                ((Method.Builder)method.addContentLine("default:")).padContent();
            } else {
                method.addContentLine(" else {");
            }
            if (converterInfo.failOnUnknown()) {
                ((Method.Builder)((Method.Builder)method.addContent("throw parser.createException(\"Unknown properties are not allowed for this type: \" + ")).addContent(converterInfo.converterType())).addContentLine(".class.getName());");
            } else {
                method.addContentLine("parser.skip();");
            }
            method.addContentLine("}");
        } else if (converterInfo.failOnUnknown()) {
            ((Method.Builder)((Method.Builder)method.addContent("throw parser.createException(\"Unknown properties are not allowed for this type: \" + ")).addContent(converterInfo.converterType())).addContentLine(".class.getName());");
        } else {
            method.addContentLine("parser.skip();");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContentLine("lastByte = parser.nextToken();")).addContent("if (lastByte == ")).addContent(JsonTypes.BYTES)).addContentLine(".COMMA_BYTE) {")).addContentLine("lastByte = parser.nextToken();")).addContentLine("continue;")).decreaseContentPadding()).addContent("} else if (lastByte == ")).addContent(JsonTypes.BYTES)).addContentLine(".BRACE_CLOSE_BYTE) {")).addContentLine("break;")).decreaseContentPadding()).addContentLine("} else {")).addContentLine("throw parser.createException(\"Expected ',' or '}'\", lastByte);")).addContentLine("}");
        method.addContentLine("}");
    }

    private static void earlyReturnForEmptyObjects(Method.Builder method, ConvertedTypeInfo converterInfo, List<JsonProperty> jsonProperties, boolean hasCreator, ElementKind creatorKind, CreatorInfo creatorInfo, boolean hasBuilder) {
        ((Method.Builder)((Method.Builder)method.addContent("if (lastByte == ")).addContent(JsonTypes.BYTES)).addContentLine(".BRACE_CLOSE_BYTE) {");
        String required = jsonProperties.stream().filter(JsonProperty::required).map(it -> it.deserializationName().orElseThrow()).collect(Collectors.joining(", "));
        if (!required.isEmpty()) {
            method.addContentLine("throw parser.createException(\"The following properties were required to be present, but none were found: " + required + "\");");
        } else if (hasCreator) {
            TypeName originalType = converterInfo.objectsGenerics();
            method.addContent("return ");
            if (creatorKind == ElementKind.METHOD) {
                ((Method.Builder)method.addContent(originalType)).addContent("." + creatorInfo.method() + "(");
            } else {
                ((Method.Builder)((Method.Builder)method.addContent("new ")).addContent(originalType)).addContent("(");
            }
            String properties = jsonProperties.stream().filter(JsonProperty::usedInCreator).map(property -> property.deserializationName().orElseThrow() + PROPERTY_NAME_SUFFIX).collect(Collectors.joining(", "));
            ((Method.Builder)method.addContent(properties)).addContentLine(");");
        } else if (hasBuilder) {
            BuilderInfo builderInfo = converterInfo.builderInfo().get();
            ((Method.Builder)((Method.Builder)method.addContent("return builder.")).addContent(builderInfo.buildMethodName())).addContentLine("();");
        } else {
            method.addContentLine("return instance;");
        }
        method.addContentLine("}");
    }

    private static void createPreProcessingVariables(Method.Builder method, ConvertedTypeInfo converterInfo, List<JsonProperty> jsonProperties, boolean hasCreator, ElementKind creatorKind, CreatorInfo creatorInfo, boolean hasBuilder) {
        jsonProperties.stream().filter(JsonProperty::required).map(JsonConverterGenerator::convertToMissingName).forEach(name -> ((Method.Builder)method.addContent(Boolean.TYPE)).addContentLine(" " + name + " = true;"));
        if (hasCreator) {
            for (JsonProperty jsonProperty : jsonProperties) {
                TypeName type = jsonProperty.deserializationType().orElseThrow();
                ((Method.Builder)((Method.Builder)method.addContent(type)).addContent(" " + jsonProperty.deserializationName().orElseThrow() + "_ = ")).addContentLine(String.valueOf(DEFAULT_TYPE_VALUES.getOrDefault(type, DEFAULT_TYPE_VALUE).get()) + ";");
            }
        } else if (creatorKind == ElementKind.METHOD) {
            TypeName originalType = converterInfo.objectsGenerics();
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(originalType)).addContent(" instance = ")).addContent(originalType)).addContent("." + creatorInfo.method() + "();");
        } else if (hasBuilder) {
            BuilderInfo builderInfo = converterInfo.builderInfo().get();
            TypeName builder = builderInfo.builderType();
            ((Method.Builder)method.addContent(builder)).addContent(" builder = ");
            if (builderInfo.builderMethodName().isPresent()) {
                TypeName originalType = converterInfo.originalType().genericTypeName();
                ((Method.Builder)method.addContent(originalType)).addContentLine(".builder();");
            } else {
                ((Method.Builder)((Method.Builder)method.addContent("new ")).addContent(builder)).addContentLine("();");
            }
            for (JsonProperty jsonProperty : jsonProperties) {
                String deserializationName = jsonProperty.deserializationName().orElseThrow();
                if (jsonProperty.usedInBuilder()) continue;
                TypeName type = jsonProperty.deserializationType().orElseThrow();
                ((Method.Builder)((Method.Builder)method.addContent(type)).addContent(" " + deserializationName + "_ = ")).addContentLine(String.valueOf(DEFAULT_TYPE_VALUES.getOrDefault(type, DEFAULT_TYPE_VALUE).get()) + ";");
            }
        } else {
            TypeName originalType = converterInfo.objectsGenerics();
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(originalType)).addContent(" instance = new ")).addContent(originalType)).addContentLine("();");
        }
    }

    private static String convertToMissingName(JsonProperty jsonProperty) {
        return jsonProperty.deserializationName().map(it -> it + MISSING_SUFFIX).orElseThrow();
    }

    private static String constantName(String propertyName) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append('_');
            }
            result.append(Character.toUpperCase(c));
        }
        return result.toString();
    }

    private static void addTypeMethodFactory(Method.Builder method, ConvertedTypeInfo converterInfo) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name("type")).returnType(builder -> builder.type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.GENERIC_TYPE)).addTypeArgument(converterInfo.wildcardsGenerics())).build())).addAnnotation(Annotation.create(Override.class))).addContent("return ")).addContent(TypeNames.GENERIC_TYPE)).addContent(".create(type);");
    }

    private static void addTypeMethod(Method.Builder method, ConvertedTypeInfo converterInfo) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name("type")).returnType(builder -> builder.type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.GENERIC_TYPE)).addTypeArgument(converterInfo.wildcardsGenerics())).build())).addAnnotation(Annotation.create(Override.class))).addContent("return ")).addContent(TypeNames.GENERIC_TYPE)).addContent(".create(")).addContent(converterInfo.originalType())).addContentLine(".class);");
    }

    private static void addTypeHandling(JsonProperty jsonProperty, Method.Builder method, ClassBase.Builder<?, ?> classBuilder, boolean hasCreator, boolean hasBuilder, Set<String> processedTypes, Map<String, TypeToConfigure> toConfigure) {
        jsonProperty.deserializer().ifPresentOrElse(deserializer -> JsonConverterGenerator.addUserDeserializer(jsonProperty, deserializer, method, classBuilder, hasCreator, hasBuilder), () -> {
            TypeName type = jsonProperty.deserializationType().orElseThrow();
            JsonConverterGenerator.createTypeDeserializer(jsonProperty, type, method, classBuilder, hasCreator, hasBuilder, processedTypes, toConfigure);
        });
    }

    private static void createTypeDeserializer(JsonProperty jsonProperty, TypeName type, Method.Builder method, ClassBase.Builder<?, ?> classBuilder, boolean hasCreator, boolean hasBuilder, Set<String> processedTypes, Map<String, TypeToConfigure> toConfigure) {
        TypeName resolvedType = type.boxed();
        if (type.typeArguments().isEmpty()) {
            String converterFieldName = "deserializer" + JsonConverterGenerator.ensureUpperStart(type);
            if (!processedTypes.contains(converterFieldName)) {
                processedTypes.add(converterFieldName);
                TypeName deserializerArgument = resolvedType.generic() ? TypeNames.OBJECT : resolvedType;
                TypeName fieldType = ((TypeName.Builder)TypeName.builder((TypeName)JsonTypes.JSON_DESERIALIZER_TYPE).addTypeArgument(deserializerArgument)).build();
                classBuilder.addField(builder -> ((Field.Builder)builder.name(converterFieldName)).isVolatile(true).type(fieldType));
                toConfigure.putIfAbsent(converterFieldName, new TypeToConfigure(TypeConfigMode.DESERIALIZATION, converterFieldName, resolvedType, type, fieldType));
            }
            JsonConverterGenerator.valueWritingMethod(jsonProperty, method, hasCreator, hasBuilder, converterFieldName);
        } else {
            String fieldName = "deserializer" + JsonConverterGenerator.ensureUpperStart(jsonProperty.deserializationName().orElseThrow());
            TypeName fieldType = ((TypeName.Builder)TypeName.builder((TypeName)JsonTypes.JSON_DESERIALIZER_TYPE).addTypeArgument(resolvedType)).build();
            classBuilder.addField(builder -> ((Field.Builder)builder.name(fieldName)).isVolatile(true).type(fieldType));
            toConfigure.putIfAbsent(fieldName, new TypeToConfigure(TypeConfigMode.DESERIALIZATION, fieldName, resolvedType, type, fieldType));
            JsonConverterGenerator.valueWritingMethod(jsonProperty, method, hasCreator, hasBuilder, fieldName);
        }
    }

    private static void addUserDeserializer(JsonProperty property, TypeName deserializer, Method.Builder method, ClassBase.Builder<?, ?> classBuilder, boolean hasCreator, boolean builderInfo) {
        String constantName = JsonConverterGenerator.constantName(property.deserializationName().orElseThrow()) + "_DESERIALIZER";
        classBuilder.addField(field -> ((Field.Builder)field.name(constantName)).type(deserializer).isStatic(true).isFinal(true).addContent("new ").addContent(deserializer).addContent("()"));
        JsonConverterGenerator.valueWritingMethod(property, method, hasCreator, builderInfo, constantName);
    }

    private static void valueWritingMethod(JsonProperty property, Method.Builder method, boolean hasCreator, boolean hasBuilder, String reference) {
        if (hasCreator || hasBuilder && !property.usedInBuilder()) {
            String deserPropertyName = property.deserializationName().orElseThrow();
            ((Method.Builder)method.addContent(deserPropertyName + "_ = ")).addContentLine("parser.checkNull() ? " + reference + ".deserializeNull() : " + reference + ".deserialize(parser);");
        } else {
            String instanceName = hasBuilder ? "builder" : "instance";
            String writingMethod = property.setterName().map(methodName -> instanceName + "." + methodName + "(parser.checkNull() ? " + reference + ".deserializeNull() : " + reference + ".deserialize(parser));").orElseGet(() -> property.fieldName().filter(it -> property.directFieldWrite()).map(fieldName -> instanceName + "." + fieldName + " = parser.checkNull() ? " + reference + ".deserializeNull() : " + reference + ".deserialize(parser);").orElseThrow());
            method.addContentLine(writingMethod);
        }
        if (property.required()) {
            String name = JsonConverterGenerator.convertToMissingName(property);
            method.addContentLine(name + " = false;");
        }
    }

    private static String ensureUpperStart(TypeName typeName) {
        String className = typeName.toString();
        int index = className.lastIndexOf(".");
        if (index > -1) {
            className = className.substring(index + 1);
        }
        return JsonConverterGenerator.ensureUpperStart(className.replaceAll("\\[]", "Array"));
    }

    private static String ensureUpperStart(String str) {
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    private static int calculateNameHash(String name) {
        int fnvHash = -2128831035;
        for (byte b : name.getBytes(StandardCharsets.UTF_8)) {
            fnvHash ^= b & 0xFF;
            fnvHash *= 16777619;
        }
        return fnvHash;
    }

    private static final class MethodNameCounter {
        private int count = 0;

        private MethodNameCounter() {
        }
    }

    private record TypeToConfigure(TypeConfigMode mode, String fieldName, TypeName resolved, TypeName original, TypeName fieldType) {
    }

    private static enum TypeConfigMode {
        SERIALIZATION("serializer"),
        DESERIALIZATION("deserializer");

        private final String method;

        private TypeConfigMode(String method) {
            this.method = method;
        }
    }
}

