/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.json.codegen.ConvertedTypeInfo;
import io.helidon.json.codegen.JsonBindingFactoryGenerator;
import io.helidon.json.codegen.JsonConverterGenerator;
import io.helidon.json.codegen.JsonTypes;
import java.util.Collection;

class JsonCodegen
implements CodegenExtension {
    private final CodegenContext ctx;

    JsonCodegen(CodegenContext ctx) {
        this.ctx = ctx;
    }

    public void process(RoundContext roundContext) {
        Collection typeInfos = roundContext.annotatedTypes(JsonTypes.JSON_ENTITY);
        for (TypeInfo typeInfo : typeInfos) {
            try {
                this.process(typeInfo, roundContext);
            }
            catch (Throwable ex) {
                throw new CodegenException("Failed to generate JSON code for the type: " + String.valueOf(typeInfo), ex, (Object)typeInfo);
            }
        }
    }

    private void process(TypeInfo typeInfo, RoundContext roundContext) {
        ClassModel.Builder builder;
        TypeName generatedType;
        TypeName annotatedTypeName = typeInfo.typeName();
        if (annotatedTypeName.typeArguments().isEmpty()) {
            ConvertedTypeInfo convertedTypeInfo = ConvertedTypeInfo.create(typeInfo, this.ctx);
            generatedType = convertedTypeInfo.converterType();
            builder = (ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().type(generatedType).addAnnotation(b -> b.type(JsonTypes.SERVICE_REGISTRY_PER_LOOKUP))).addAnnotation(Annotation.builder().type(TypeNames.WEIGHT).addParameter("value", (Object)95.0).build());
            JsonConverterGenerator.generateConverter(builder, convertedTypeInfo, false);
        } else {
            String classNameWithEnclosingNames = typeInfo.typeName().classNameWithEnclosingNames();
            String replacedDot = classNameWithEnclosingNames.replace(".", "_");
            String typeBaseName = typeInfo.typeName().fqName().replace(classNameWithEnclosingNames, replacedDot);
            TypeName converterTypeName = TypeName.create((String)(typeBaseName + "_BindingFactory"));
            generatedType = ((TypeName.Builder)TypeName.builder().from(converterTypeName)).build();
            builder = ClassModel.builder().type(generatedType);
            JsonBindingFactoryGenerator.generateBindingFactory(builder, typeInfo, this.ctx);
        }
        roundContext.addGeneratedType(generatedType, builder, annotatedTypeName, new Object[]{typeInfo.originatingElement().orElse(annotatedTypeName)});
    }
}

