/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.json.codegen.ConvertedTypeInfo;
import io.helidon.json.codegen.JsonConverterGenerator;
import io.helidon.json.codegen.JsonTypes;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Supplier;

class JsonBindingFactoryGenerator {
    private JsonBindingFactoryGenerator() {
    }

    static void generateBindingFactory(ClassBase.Builder<?, ?> classBuilder, TypeInfo annotatedType, CodegenContext ctx) {
        ConvertedTypeInfo convertedTypeInfo = ConvertedTypeInfo.create(annotatedType, ctx);
        ((ClassBase.Builder)((ClassBase.Builder)classBuilder.addAnnotation(b -> b.type(JsonTypes.SERVICE_REGISTRY_PER_LOOKUP))).addAnnotation(Annotation.builder().type(TypeNames.WEIGHT).addParameter("value", (Object)95.0).build())).javadoc(Javadoc.builder().add("Json binding factory for {@link " + annotatedType.typeName().fqName() + "}.").build()).addInterface(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JsonTypes.JSON_BINDING_FACTORY)).addTypeArgument(convertedTypeInfo.wildcardsGenerics())).build());
        InnerClass.Builder converterClassBuilder = (InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)InnerClass.builder().name(convertedTypeInfo.converterType().className())).accessModifier(AccessModifier.PRIVATE)).isFinal(true)).isStatic(true).addField(builder -> builder.isFinal(true).type(Type.class).name("type"))).addConstructor(builder -> ((Constructor.Builder)((Constructor.Builder)builder.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addParameter(param -> param.type(Type.class).name("type"))).addContent("this.type = type;"));
        JsonConverterGenerator.generateConverter(converterClassBuilder, convertedTypeInfo, true);
        classBuilder.addInnerClass((Supplier)converterClassBuilder).addMethod(method -> JsonBindingFactoryGenerator.addCreateDeserializerMethodClass(method, convertedTypeInfo)).addMethod(method -> JsonBindingFactoryGenerator.addCreateDeserializerMethodGenerics(method, convertedTypeInfo)).addMethod(method -> JsonBindingFactoryGenerator.addCreateSerializerMethodClass(method, convertedTypeInfo)).addMethod(method -> JsonBindingFactoryGenerator.addCreateSerializerMethodGenerics(method, convertedTypeInfo)).addMethod(method -> JsonBindingFactoryGenerator.addTypeMethod(method, convertedTypeInfo));
    }

    private static void addCreateDeserializerMethodClass(Method.Builder method, ConvertedTypeInfo convertedTypeInfo) {
        TypeName classType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Class.class)).addTypeArgument(it -> ((TypeName.Builder)it.from((TypeName)TypeArgument.create((String)"?"))).addUpperBound(convertedTypeInfo.wildcardsGenerics()))).build();
        JsonBindingFactoryGenerator.addCreateDeserializerMethod(method, convertedTypeInfo, classType, false);
    }

    private static void addCreateDeserializerMethodGenerics(Method.Builder method, ConvertedTypeInfo convertedTypeInfo) {
        TypeName classType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.GENERIC_TYPE)).addTypeArgument(it -> ((TypeName.Builder)it.from((TypeName)TypeArgument.create((String)"?"))).addUpperBound(convertedTypeInfo.wildcardsGenerics()))).build();
        JsonBindingFactoryGenerator.addCreateDeserializerMethod(method, convertedTypeInfo, classType, true);
    }

    private static void addCreateDeserializerMethod(Method.Builder method, ConvertedTypeInfo convertedTypeInfo, TypeName parameter, boolean genericType) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name("createDeserializer")).addAnnotation(Annotation.create(Override.class))).returnType(builder -> builder.type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JsonTypes.JSON_DESERIALIZER_TYPE)).addTypeArgument(convertedTypeInfo.wildcardsGenerics())).build())).addParameter(builder -> builder.type(parameter).name("type"))).addContent("return new ")).addContent(convertedTypeInfo.converterType())).addContentLine(genericType ? "(type.type());" : "(type);");
    }

    private static void addCreateSerializerMethodClass(Method.Builder method, ConvertedTypeInfo convertedTypeInfo) {
        TypeName classType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Class.class)).addTypeArgument(it -> ((TypeName.Builder)it.from((TypeName)TypeArgument.create((String)"?"))).addUpperBound(convertedTypeInfo.wildcardsGenerics()))).build();
        JsonBindingFactoryGenerator.addCreateSerializerMethod(method, convertedTypeInfo, classType, false);
    }

    private static void addCreateSerializerMethodGenerics(Method.Builder method, ConvertedTypeInfo convertedTypeInfo) {
        TypeName classType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeNames.GENERIC_TYPE)).addTypeArgument(it -> ((TypeName.Builder)it.from((TypeName)TypeArgument.create((String)"?"))).addUpperBound(convertedTypeInfo.wildcardsGenerics()))).build();
        JsonBindingFactoryGenerator.addCreateSerializerMethod(method, convertedTypeInfo, classType, true);
    }

    private static void addCreateSerializerMethod(Method.Builder method, ConvertedTypeInfo convertedTypeInfo, TypeName parameter, boolean genericType) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name("createSerializer")).addAnnotation(Annotation.create(Override.class))).returnType(builder -> builder.type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(JsonTypes.JSON_SERIALIZER_TYPE)).addTypeArgument(convertedTypeInfo.wildcardsGenerics())).build())).addParameter(builder -> builder.type(parameter).name("type"))).addContent("return new ")).addContent(convertedTypeInfo.converterType())).addContentLine(genericType ? "(type.type());" : "(type);");
    }

    private static void addTypeMethod(Method.Builder method, ConvertedTypeInfo convertedTypeInfo) {
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.name("supportedTypes")).addAnnotation(Annotation.create(Override.class))).returnType(builder -> builder.type(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Set.class)).addTypeArgument(b -> ((TypeName.Builder)b.type(Class.class)).addTypeArgument((TypeName)TypeArgument.create((String)"?")))).build())).addContent("return ")).addContent(Set.class)).addContent(".of(")).addContent(convertedTypeInfo.originalType().genericTypeName())).addContentLine(".class);");
    }
}

