/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.json.codegen;

import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.AccessorStyle;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.ElementSignature;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.json.codegen.BuilderInfo;
import io.helidon.json.codegen.CreatorInfo;
import io.helidon.json.codegen.JsonCodegenOptions;
import io.helidon.json.codegen.JsonProperty;
import io.helidon.json.codegen.JsonTypes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

record ConvertedTypeInfo(TypeName converterType, TypeName originalType, TypeName wildcardsGenerics, TypeName objectsGenerics, boolean nullable, boolean failOnUnknown, Map<String, JsonProperty> jsonProperties, Comparator<String> orderedProperties, CreatorInfo creatorInfo, Optional<BuilderInfo> builderInfo, Map<TypeName, Integer> genericParamsWithIndexes) {
    private static final Set<ElementSignature> IGNORED_METHODS = Set.of(ElementSignature.createMethod((TypeName)TypeNames.PRIMITIVE_BOOLEAN, (String)"equals", List.of(TypeNames.OBJECT)), ElementSignature.createMethod((TypeName)TypeNames.PRIMITIVE_INT, (String)"hashCode", List.of()), ElementSignature.createMethod((TypeName)TypeNames.STRING, (String)"toString", List.of()));
    private static final Set<TypeName> IGNORED_BUILDER_METHOD_PARAM_TYPES = Set.of(TypeNames.CONSUMER, TypeNames.OPTIONAL, TypeNames.SUPPLIER);
    private static final Map<String, Comparator<String>> PROPERTY_ORDER = Map.of("ALPHABETICAL", Comparator.naturalOrder(), "REVERSE_ALPHABETICAL", Comparator.reverseOrder());

    public static ConvertedTypeInfo create(TypeInfo typeInfo, CodegenContext ctx) {
        String classNameWithEnclosingNames = typeInfo.typeName().classNameWithEnclosingNames();
        String replacedDot = classNameWithEnclosingNames.replace(".", "_");
        String nameBase = typeInfo.typeName().fqName().replace(classNameWithEnclosingNames, replacedDot);
        TypeName converterTypeName = TypeName.create((String)(nameBase + "__GeneratedConverter"));
        AccessorStyle recordAccessors = typeInfo.annotation(JsonTypes.JSON_ENTITY).enumValue("accessorStyle", AccessorStyle.class).orElse(AccessorStyle.AUTO);
        if (typeInfo.kind() == ElementKind.RECORD && recordAccessors.equals((Object)AccessorStyle.AUTO)) {
            recordAccessors = AccessorStyle.RECORD;
        }
        boolean nullable = ConvertedTypeInfo.obtainClassAnnotationFromHierarchy(JsonTypes.JSON_SERIALIZE_NULLS, typeInfo).flatMap(Annotation::booleanValue).orElse((Boolean)JsonCodegenOptions.CODEGEN_JSON_NULL.value(ctx.options()));
        boolean failOnUnknown = ConvertedTypeInfo.obtainClassAnnotationFromHierarchy(JsonTypes.JSON_FAIL_ON_UNKNOWN, typeInfo).flatMap(Annotation::booleanValue).orElse((Boolean)JsonCodegenOptions.CODEGEN_JSON_UNKNOWN.value(ctx.options()));
        String orderStrategy = ConvertedTypeInfo.obtainClassAnnotationFromHierarchy(JsonTypes.JSON_PROPERTY_ORDER, typeInfo).flatMap(Annotation::stringValue).orElse((String)JsonCodegenOptions.CODEGEN_JSON_ORDER.value(ctx.options()));
        LinkedHashMap<String, JsonProperty.Builder> properties = new LinkedHashMap<String, JsonProperty.Builder>();
        LinkedHashMap<String, Map<String, TypeName>> resolvedGenerics = new LinkedHashMap<String, Map<String, TypeName>>();
        Map<TypeName, Integer> genericParamsWithIndexes = ConvertedTypeInfo.obtainGenericParamsWithIndexes(typeInfo);
        ConvertedTypeInfo.discoverAllPossibleGenerics(typeInfo, resolvedGenerics, Map.of());
        ConvertedTypeInfo.discoverFields(properties, typeInfo, nullable, resolvedGenerics);
        ConvertedTypeInfo.discoverGetAndSetMethods(properties, typeInfo, recordAccessors, resolvedGenerics);
        Optional builderAnnotation = typeInfo.findAnnotation(JsonTypes.JSON_BUILDER_INFO);
        Optional<BuilderInfo> builderInfo = builderAnnotation.flatMap(Annotation::stringValue).map(TypeName::create).flatMap(arg_0 -> ((CodegenContext)ctx).typeInfo(arg_0)).flatMap(it -> ConvertedTypeInfo.processBuilderInfoFromClass(it, typeInfo, null, builderAnnotation, properties, resolvedGenerics)).or(() -> ConvertedTypeInfo.processBuilderInfo(typeInfo, properties, ctx, resolvedGenerics));
        CreatorInfo creatorInfo = ConvertedTypeInfo.discoverCreator(properties, typeInfo, resolvedGenerics);
        Map<String, JsonProperty> jsonProperties = ConvertedTypeInfo.finalizeJsonProperties(properties);
        Comparator<String> orderComparator = PROPERTY_ORDER.getOrDefault(orderStrategy, (o1, o2) -> 0);
        return new ConvertedTypeInfo(converterTypeName, typeInfo.typeName(), ConvertedTypeInfo.transformGenerics(typeInfo.typeName(), TypeArgument.create((String)"?")), ConvertedTypeInfo.transformGenerics(typeInfo.typeName(), TypeArgument.create((TypeName)TypeNames.OBJECT)), nullable, failOnUnknown, jsonProperties, orderComparator, creatorInfo, builderInfo, genericParamsWithIndexes);
    }

    private static Map<TypeName, Integer> obtainGenericParamsWithIndexes(TypeInfo typeInfo) {
        List typeArguments = typeInfo.typeName().typeArguments();
        HashMap<TypeName, Integer> argumentsWithIndexes = new HashMap<TypeName, Integer>();
        for (int i = 0; i < typeArguments.size(); ++i) {
            argumentsWithIndexes.put((TypeName)typeArguments.get(i), i);
        }
        return argumentsWithIndexes;
    }

    private static void discoverAllPossibleGenerics(TypeInfo typeInfo, Map<String, Map<String, TypeName>> resolvedGenerics, Map<String, TypeName> childGenerics) {
        HashMap<String, TypeName> typeGenerics = new HashMap<String, TypeName>();
        TypeName typeName = typeInfo.typeName();
        for (int i = 0; i < typeName.typeParameters().size(); ++i) {
            String parameterName = (String)typeName.typeParameters().get(i);
            TypeName typeValue = (TypeName)typeName.typeArguments().get(i);
            if (typeValue.generic()) {
                typeValue = childGenerics.getOrDefault(typeValue.toString(), typeValue);
            }
            typeGenerics.put(parameterName, typeValue);
        }
        resolvedGenerics.put(typeName.fqName(), typeGenerics);
        Optional superTypeInfo = typeInfo.superTypeInfo();
        superTypeInfo.ifPresent(info -> ConvertedTypeInfo.discoverAllPossibleGenerics(info, resolvedGenerics, typeGenerics));
    }

    static boolean needsResolving(TypeName typeName) {
        for (TypeName typeArgument : typeName.typeArguments()) {
            if (!ConvertedTypeInfo.needsResolving(typeArgument)) continue;
            return true;
        }
        return typeName.generic();
    }

    private static Optional<BuilderInfo> processBuilderInfo(TypeInfo createdTypeInfo, Map<String, JsonProperty.Builder> properties, CodegenContext ctx, Map<String, Map<String, TypeName>> resolvedGenerics) {
        Optional<TypedElementInfo> builderMethod = ConvertedTypeInfo.findHelidonBuilderMethod(createdTypeInfo, ctx);
        if (builderMethod.isEmpty()) {
            return Optional.empty();
        }
        TypeName builderTypeName = builderMethod.get().typeName();
        TypeInfo builderTypeInfo = (TypeInfo)ctx.typeInfo(builderTypeName).orElseThrow(() -> new CodegenException("Could not find builder type: " + String.valueOf(builderTypeName), (Object)createdTypeInfo));
        ConvertedTypeInfo.discoverAllPossibleGenerics(builderTypeInfo, resolvedGenerics, Map.of());
        return ConvertedTypeInfo.processBuilderInfoFromClass(builderTypeInfo, createdTypeInfo, builderMethod.get().elementName(), Optional.empty(), properties, resolvedGenerics);
    }

    private static Optional<BuilderInfo> processBuilderInfoFromClass(TypeInfo builderTypeInfo, TypeInfo createdTypeInfo, String builderMethodName, Optional<Annotation> builderAnnotation, Map<String, JsonProperty.Builder> properties, Map<String, Map<String, TypeName>> resolvedGenerics) {
        String builderMethodPrefix = builderAnnotation.flatMap(it -> it.stringValue("methodPrefix")).orElse("");
        String buildMethod = builderAnnotation.flatMap(it -> it.stringValue("buildMethod")).orElse("build");
        if (!ConvertedTypeInfo.checkBuildMethod(builderTypeInfo, createdTypeInfo, buildMethod)) {
            throw new CodegenException("Build method with the name \"" + buildMethod + "\" does not exist or does not return: " + createdTypeInfo.typeName().fqName(), (Object)createdTypeInfo);
        }
        ConvertedTypeInfo.processBuilderMethods(builderTypeInfo, builderTypeInfo, properties, resolvedGenerics, builderMethodPrefix);
        return Optional.of(new BuilderInfo(builderTypeInfo.typeName(), Optional.ofNullable(builderMethodName), buildMethod));
    }

    private static void processBuilderMethods(TypeInfo builderTypeInfo, TypeInfo currentTypeInfo, Map<String, JsonProperty.Builder> properties, Map<String, Map<String, TypeName>> resolvedGenerics, String builderMethodPrefix) {
        currentTypeInfo.superTypeInfo().ifPresent(superType -> ConvertedTypeInfo.processBuilderMethods(builderTypeInfo, superType, properties, resolvedGenerics, builderMethodPrefix));
        for (TypeInfo interf : currentTypeInfo.interfaceTypeInfo()) {
            ConvertedTypeInfo.processBuilderMethods(builderTypeInfo, interf, properties, resolvedGenerics, builderMethodPrefix);
        }
        List<TypedElementInfo> builderMethods = currentTypeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(method -> !method.hasAnnotation(JsonTypes.JSON_IGNORE)).filter(method -> method.elementName().startsWith(builderMethodPrefix)).filter(it -> ConvertedTypeInfo.resolveGenerics(it.typeName(), currentTypeInfo, resolvedGenerics).equals((Object)builderTypeInfo.typeName())).filter(it -> it.parameterArguments().size() == 1).filter(it -> !it.elementName().equals("from")).filter(it -> !it.elementName().equals("config")).filter(it -> !IGNORED_BUILDER_METHOD_PARAM_TYPES.contains(it.typeName().genericTypeName())).filter(Predicate.not(ConvertedTypeInfo::isIgnored)).toList();
        HashSet<String> builderProperties = new HashSet<String>();
        for (TypedElementInfo method2 : builderMethods) {
            String methodName = method2.elementName();
            String propertyName = ConvertedTypeInfo.methodToFieldName(builderMethodPrefix, methodName);
            if (builderProperties.contains(method2.elementName())) continue;
            TypedElementInfo parameter = (TypedElementInfo)method2.parameterArguments().getFirst();
            JsonProperty.Builder jsonPropertyBuilder = properties.computeIfAbsent(propertyName, name -> JsonProperty.builder());
            ((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)jsonPropertyBuilder.usedInBuilder(true)).setterName(methodName)).deserializationNameIfNotSet(propertyName)).deserializationType(ConvertedTypeInfo.resolveGenerics(parameter.typeName(), builderTypeInfo, resolvedGenerics))).deserializationName(ConvertedTypeInfo.obtainStringFromAnnotation(parameter, JsonTypes.JSON_PROPERTY))).deserializer(ConvertedTypeInfo.obtainTypeNameFromAnnotation(parameter, JsonTypes.JSON_CONVERTER))).deserializer(ConvertedTypeInfo.obtainTypeNameFromAnnotation(parameter, JsonTypes.JSON_DESERIALIZER));
            builderProperties.add(propertyName);
        }
    }

    private static boolean checkBuildMethod(TypeInfo builderTypeInfo, TypeInfo originalTypeInfo, String buildMethodName) {
        return builderTypeInfo.elementInfo().stream().filter(it -> it.elementName().equals(buildMethodName)).filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(ElementInfoPredicates::hasNoArgs).anyMatch(it -> it.typeName().equals((Object)originalTypeInfo.typeName()));
    }

    private static Optional<TypedElementInfo> findHelidonBuilderMethod(TypeInfo typeInfo, CodegenContext ctx) {
        return typeInfo.elementInfo().stream().filter(it -> it.elementName().equals("builder")).filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(ElementInfoPredicates::isStatic).filter(Predicate.not(ConvertedTypeInfo::isIgnored)).filter(ElementInfoPredicates::hasNoArgs).filter(it -> ctx.typeInfo(it.typeName()).map(info -> info.findInHierarchy(JsonTypes.BUILDER_TYPE).isPresent()).orElse(false)).findFirst();
    }

    private static void discoverFields(Map<String, JsonProperty.Builder> properties, TypeInfo typeInfo, boolean nullable, Map<String, Map<String, TypeName>> resolvedGenerics) {
        typeInfo.superTypeInfo().ifPresent(superType -> ConvertedTypeInfo.discoverFields(properties, superType, nullable, resolvedGenerics));
        List<TypedElementInfo> fields = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isField).filter(Predicate.not(ElementInfoPredicates::isStatic)).toList();
        for (TypedElementInfo field : fields) {
            String fieldName = field.elementName();
            TypeName fieldType = ConvertedTypeInfo.resolveGenerics(field.typeName(), typeInfo, resolvedGenerics);
            JsonProperty.Builder builder = (JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)JsonProperty.builder().fieldName(fieldName)).deserializationName(fieldName)).serializationName(fieldName)).deserializationType(fieldType)).serializationType(fieldType)).directFieldRead(field.accessModifier() != AccessModifier.PRIVATE)).directFieldWrite(field.accessModifier() != AccessModifier.PRIVATE && !field.elementModifiers().contains(Modifier.FINAL))).nullable(nullable);
            ConvertedTypeInfo.obtainStringFromAnnotation(field, JsonTypes.JSON_PROPERTY).ifPresent(value -> ((JsonProperty.Builder)builder.serializationName((String)value)).deserializationName((String)value));
            ConvertedTypeInfo.obtainTypeNameFromAnnotation(field, JsonTypes.JSON_CONVERTER).ifPresent(value -> ((JsonProperty.Builder)builder.serializer((TypeName)value)).deserializer((TypeName)value));
            ConvertedTypeInfo.obtainTypeNameFromAnnotation(field, JsonTypes.JSON_SERIALIZER).ifPresent(builder::serializer);
            ConvertedTypeInfo.obtainTypeNameFromAnnotation(field, JsonTypes.JSON_DESERIALIZER).ifPresent(builder::deserializer);
            ConvertedTypeInfo.obtainBooleanFromAnnotation(field, JsonTypes.JSON_IGNORE).ifPresent(builder::fieldIgnored);
            field.findAnnotation(JsonTypes.JSON_REQUIRED).ifPresent(annotation -> builder.required(true));
            ConvertedTypeInfo.obtainBooleanFromAnnotation(field, JsonTypes.JSON_SERIALIZE_NULLS).ifPresent(builder::nullable);
            if (field.elementModifiers().contains(Modifier.TRANSIENT)) {
                builder.fieldIgnored(true);
            }
            properties.put(fieldName, builder);
        }
    }

    private static AccessorStyle discoverGetAndSetMethods(Map<String, JsonProperty.Builder> properties, TypeInfo typeInfo, AccessorStyle accessorStyle, Map<String, Map<String, TypeName>> resolvedGenerics) {
        AccessorStyle detectedAccessorStyle = typeInfo.superTypeInfo().map(superType -> ConvertedTypeInfo.discoverGetAndSetMethods(properties, superType, accessorStyle, resolvedGenerics)).orElse(accessorStyle);
        for (TypeInfo interf : typeInfo.interfaceTypeInfo()) {
            ConvertedTypeInfo.discoverGetAndSetMethods(properties, interf, detectedAccessorStyle, resolvedGenerics);
        }
        List<Object> methods = List.of();
        if (detectedAccessorStyle.equals((Object)AccessorStyle.AUTO) || detectedAccessorStyle.equals((Object)AccessorStyle.BEAN)) {
            methods = ConvertedTypeInfo.obtainAllAccessors(typeInfo, AccessorStyle.BEAN);
        }
        if (methods.isEmpty()) {
            if (detectedAccessorStyle.equals((Object)AccessorStyle.AUTO) || detectedAccessorStyle.equals((Object)AccessorStyle.RECORD)) {
                methods = ConvertedTypeInfo.obtainAllAccessors(typeInfo, AccessorStyle.RECORD);
                detectedAccessorStyle = AccessorStyle.RECORD;
            }
        } else {
            detectedAccessorStyle = AccessorStyle.BEAN;
        }
        for (TypedElementInfo typedElementInfo : methods) {
            String propertyName;
            String prefix;
            String methodName = typedElementInfo.elementName();
            if (ConvertedTypeInfo.isGetter(typedElementInfo, detectedAccessorStyle)) {
                prefix = detectedAccessorStyle == AccessorStyle.RECORD ? "" : (typedElementInfo.typeName().equals((Object)TypeNames.PRIMITIVE_BOOLEAN) ? "is" : "get");
                propertyName = ConvertedTypeInfo.methodToFieldName(prefix, methodName);
                JsonProperty.Builder property = (JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)properties.computeIfAbsent(propertyName, name -> JsonProperty.builder()).getterName(methodName)).serializationNameIfNotSet(propertyName)).serializationType(ConvertedTypeInfo.resolveGenerics(typedElementInfo.typeName(), typeInfo, resolvedGenerics))).serializationName(ConvertedTypeInfo.obtainStringFromAnnotation(typedElementInfo, JsonTypes.JSON_PROPERTY))).serializer(ConvertedTypeInfo.obtainTypeNameFromAnnotation(typedElementInfo, JsonTypes.JSON_CONVERTER));
                ConvertedTypeInfo.obtainBooleanFromAnnotation(typedElementInfo, JsonTypes.JSON_IGNORE).ifPresent(property::getterIgnored);
                ConvertedTypeInfo.obtainBooleanFromAnnotation(typedElementInfo, JsonTypes.JSON_SERIALIZE_NULLS).ifPresent(property::nullable);
                typedElementInfo.findAnnotation(JsonTypes.JSON_REQUIRED).ifPresent(annotation -> property.required(true));
                continue;
            }
            if (typeInfo.kind() == ElementKind.RECORD || !ConvertedTypeInfo.isSetter(typedElementInfo, detectedAccessorStyle)) continue;
            prefix = detectedAccessorStyle == AccessorStyle.RECORD ? "" : "set";
            propertyName = ConvertedTypeInfo.methodToFieldName(prefix, methodName);
            TypeName parameterType = ((TypedElementInfo)typedElementInfo.parameterArguments().getFirst()).typeName();
            JsonProperty.Builder property = (JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)properties.computeIfAbsent(propertyName, name -> JsonProperty.builder()).setterName(methodName)).deserializationNameIfNotSet(propertyName)).deserializationType(ConvertedTypeInfo.resolveGenerics(parameterType, typeInfo, resolvedGenerics))).deserializationName(ConvertedTypeInfo.obtainStringFromAnnotation(typedElementInfo, JsonTypes.JSON_PROPERTY))).deserializer(ConvertedTypeInfo.obtainTypeNameFromAnnotation(typedElementInfo, JsonTypes.JSON_CONVERTER));
            ConvertedTypeInfo.obtainBooleanFromAnnotation(typedElementInfo, JsonTypes.JSON_IGNORE).ifPresent(property::setterIgnored);
        }
        return detectedAccessorStyle;
    }

    private static List<TypedElementInfo> obtainAllAccessors(TypeInfo typeInfo, AccessorStyle accessorStyle) {
        return typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(Predicate.not(ElementInfoPredicates::isPrivate)).filter(Predicate.not(ElementInfoPredicates::isStatic)).filter(Predicate.not(ConvertedTypeInfo::isIgnored)).filter(it -> ConvertedTypeInfo.isGetter(it, accessorStyle) || ConvertedTypeInfo.isSetter(it, accessorStyle)).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CreatorInfo discoverCreator(Map<String, JsonProperty.Builder> properties, TypeInfo typeInfo, Map<String, Map<String, TypeName>> resolvedGenerics) {
        TypedElementInfo creator;
        ElementKind creatorKind;
        List<TypedElementInfo> creators = typeInfo.elementInfo().stream().filter(info -> info.hasAnnotation(JsonTypes.JSON_CREATOR)).toList();
        if (creators.isEmpty()) {
            if (typeInfo.kind() != ElementKind.RECORD) return new CreatorInfo(null, "", List.of());
            creators = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isConstructor).toList();
            if (creators.size() > 1) {
                throw new CodegenException("Only one record constructor is allowed. If multiple is needed, one has to be annotated with " + String.valueOf(JsonTypes.JSON_CREATOR), (Object)typeInfo);
            }
        } else if (creators.size() > 1) {
            throw new CodegenException("Only one Creator is allowed to be set", (Object)typeInfo);
        }
        if ((creatorKind = (creator = creators.getFirst()).kind()) == ElementKind.METHOD && !creator.elementModifiers().contains(Modifier.STATIC)) {
            throw new CodegenException("Creator has to be either on constructor or static method", (Object)typeInfo);
        }
        if (creator.accessModifier() == AccessModifier.PRIVATE) {
            throw new CodegenException("Creator has to be non-private", (Object)typeInfo);
        }
        String creatorMethod = creator.elementName();
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (TypedElementInfo parameter : creator.parameterArguments()) {
            String parameterName = parameter.elementName();
            parameterNames.add(parameterName);
            ((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)((JsonProperty.Builder)properties.computeIfAbsent(parameterName, name -> JsonProperty.builder()).usedInCreator(true)).deserializationName(parameterName)).deserializationType(ConvertedTypeInfo.resolveGenerics(parameter.typeName(), typeInfo, resolvedGenerics))).deserializationName(ConvertedTypeInfo.obtainStringFromAnnotation(parameter, JsonTypes.JSON_PROPERTY))).deserializer(ConvertedTypeInfo.obtainTypeNameFromAnnotation(parameter, JsonTypes.JSON_CONVERTER))).deserializer(ConvertedTypeInfo.obtainTypeNameFromAnnotation(parameter, JsonTypes.JSON_DESERIALIZER));
        }
        return new CreatorInfo(creatorKind, creatorMethod, parameterNames);
    }

    private static TypeName resolveGenerics(TypeName elementTypeName, TypeInfo typeInfo, Map<String, Map<String, TypeName>> resolvedGenerics) {
        if (ConvertedTypeInfo.needsResolving(elementTypeName)) {
            if (elementTypeName.generic()) {
                Map typeGenerics = resolvedGenerics.getOrDefault(typeInfo.typeName().fqName(), Map.of());
                return typeGenerics.getOrDefault(elementTypeName.name(), elementTypeName);
            }
            TypeName.Builder builder = (TypeName.Builder)((TypeName.Builder)TypeName.builder().from(elementTypeName)).typeArguments(List.of());
            elementTypeName.typeArguments().forEach(arg -> builder.addTypeArgument(ConvertedTypeInfo.resolveGenerics(arg, typeInfo, resolvedGenerics)));
            return builder.build();
        }
        return elementTypeName;
    }

    private static boolean isGetter(TypedElementInfo typedElementInfo, AccessorStyle accessorStyle) {
        if (accessorStyle == AccessorStyle.RECORD) {
            return typedElementInfo.parameterArguments().isEmpty() && !typedElementInfo.typeName().equals((Object)TypeNames.PRIMITIVE_VOID);
        }
        String methodName = typedElementInfo.elementName();
        int length = -1;
        if (methodName.startsWith("get")) {
            length = 3;
        } else if (methodName.startsWith("is")) {
            length = 2;
        }
        return length > -1 && methodName.length() > length && Character.isUpperCase(methodName.charAt(length)) && typedElementInfo.parameterArguments().isEmpty() && !typedElementInfo.typeName().equals((Object)TypeNames.PRIMITIVE_VOID);
    }

    private static boolean isSetter(TypedElementInfo typedElementInfo, AccessorStyle accessorStyle) {
        if (accessorStyle == AccessorStyle.RECORD) {
            return typedElementInfo.parameterArguments().size() == 1 && typedElementInfo.typeName().equals((Object)TypeNames.PRIMITIVE_VOID);
        }
        String methodName = typedElementInfo.elementName();
        return methodName.startsWith("set") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) && typedElementInfo.parameterArguments().size() == 1 && typedElementInfo.typeName().equals((Object)TypeNames.PRIMITIVE_VOID);
    }

    private static String methodToFieldName(String prefix, String methodName) {
        if (methodName.startsWith(prefix)) {
            String str = methodName.substring(prefix.length());
            if (str.isEmpty()) {
                return methodName;
            }
            if (str.length() == 1) {
                return str.toLowerCase();
            }
            return Character.toLowerCase(str.charAt(0)) + str.substring(1);
        }
        return methodName;
    }

    private static boolean isIgnored(TypedElementInfo elementInfo) {
        return IGNORED_METHODS.contains(elementInfo.signature());
    }

    private static Optional<String> obtainStringFromAnnotation(TypedElementInfo elementInfo, TypeName annotationType) {
        return elementInfo.findAnnotation(annotationType).flatMap(Annotation::stringValue);
    }

    private static Optional<TypeName> obtainTypeNameFromAnnotation(TypedElementInfo elementInfo, TypeName annotationType) {
        return elementInfo.findAnnotation(annotationType).flatMap(Annotation::typeValue);
    }

    private static Optional<Boolean> obtainBooleanFromAnnotation(TypedElementInfo elementInfo, TypeName annotationType) {
        return elementInfo.findAnnotation(annotationType).flatMap(Annotation::booleanValue);
    }

    private static Map<String, JsonProperty> finalizeJsonProperties(Map<String, JsonProperty.Builder> properties) {
        LinkedHashMap<String, JsonProperty> finalProperties = new LinkedHashMap<String, JsonProperty>(properties.size());
        for (Map.Entry<String, JsonProperty.Builder> entry : properties.entrySet()) {
            JsonProperty.Builder builder = entry.getValue();
            if (!builder.directFieldRead() && !builder.directFieldWrite() && builder.setterName().isEmpty() && builder.getterName().isEmpty() && !builder.usedInBuilder() && !builder.usedInCreator()) continue;
            finalProperties.put(entry.getKey(), builder.build());
        }
        return finalProperties;
    }

    private static Optional<Annotation> obtainClassAnnotationFromHierarchy(TypeName annotationType, TypeInfo currentType) {
        if (currentType.hasAnnotation(annotationType)) {
            return currentType.findAnnotation(annotationType);
        }
        return currentType.superTypeInfo().flatMap(superType -> ConvertedTypeInfo.obtainClassAnnotationFromHierarchy(annotationType, superType)).or(() -> {
            for (TypeInfo interf : currentType.interfaceTypeInfo()) {
                Optional<Annotation> annotation = ConvertedTypeInfo.obtainClassAnnotationFromHierarchy(annotationType, interf);
                if (!annotation.isPresent()) continue;
                return annotation;
            }
            return Optional.empty();
        });
    }

    private static TypeName transformGenerics(TypeName typeName, TypeArgument transformTo) {
        TypeName.Builder builder = (TypeName.Builder)TypeName.builder((TypeName)typeName).clearTypeArguments();
        for (int i = 0; i < typeName.typeArguments().size(); ++i) {
            builder.addTypeArgument((TypeName)transformTo);
        }
        return builder.build();
    }
}

