/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.sys;

import io.helidon.integrations.common.rest.ApiJsonBuilder;
import io.helidon.integrations.vault.AuthMethod;
import io.helidon.integrations.vault.VaultApiException;
import io.helidon.integrations.vault.VaultRequest;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.time.Duration;

abstract class MountRequest<T extends MountRequest<T>>
extends VaultRequest<T> {
    private final Config config = new Config();
    private String path;

    protected MountRequest() {
    }

    public T path(String path) {
        this.path = path;
        return (T)((Object)((MountRequest)this.me()));
    }

    public T description(String description) {
        return (T)((Object)((MountRequest)this.add("description", description)));
    }

    public T defaultLeaseTtl(Duration defaultLeaseTtl) {
        this.config.defaultLeaseTtl(defaultLeaseTtl);
        return (T)((Object)((MountRequest)this.me()));
    }

    public T maxLeaseTtl(Duration maxLeaseTtl) {
        this.config.maxLeaseTtl(maxLeaseTtl);
        return (T)((Object)((MountRequest)this.me()));
    }

    public T forceNoCache(boolean forceNoCache) {
        this.config.forceNoCache(forceNoCache);
        return (T)((Object)((MountRequest)this.me()));
    }

    public T addPassThroughHeader(String passThroughHeader) {
        this.config.addPassThroughRequestHeader(passThroughHeader);
        return (T)((Object)((MountRequest)this.me()));
    }

    public T addAllowedResponseHeader(String allowedResponseHeader) {
        this.config.addAllowedResponseHeader(allowedResponseHeader);
        return (T)((Object)((MountRequest)this.me()));
    }

    String path() {
        if (this.path == null) {
            throw new VaultApiException(((Object)((Object)this)).getClass().getSimpleName() + " path must be defined");
        }
        return this.path;
    }

    T authMethod(AuthMethod<?> method) {
        return (T)((Object)((MountRequest)this.add("type", method.type())));
    }

    protected void postBuild(JsonBuilderFactory factory, JsonObjectBuilder payload) {
        JsonObject configJson = (JsonObject)this.config.toJson(factory).get();
        if (configJson.isEmpty()) {
            payload.addNull("config");
        } else {
            payload.add("config", (JsonValue)configJson);
        }
    }

    protected void defaultPath(String defaultMount) {
        if (this.path == null) {
            this.path = defaultMount;
        }
    }

    private static class Config
    extends ApiJsonBuilder<Config> {
        private Config() {
        }

        Config defaultLeaseTtl(Duration duration) {
            return (Config)this.add("default_lease_ttl", VaultRequest.durationToTtl((Duration)duration));
        }

        Config maxLeaseTtl(Duration duration) {
            return (Config)this.add("max_lease_ttl", VaultRequest.durationToTtl((Duration)duration));
        }

        Config forceNoCache(boolean forceNoCache) {
            return (Config)this.add("force_no_cache", forceNoCache);
        }

        Config addPassThroughRequestHeader(String headerName) {
            return (Config)this.addToArray("passthrough_request_headers", headerName);
        }

        Config addAllowedResponseHeader(String headerName) {
            return (Config)this.addToArray("allowed_response_headers", headerName);
        }
    }
}

