/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.integrations.vault.Engine;
import io.helidon.integrations.vault.ListSecrets;
import io.helidon.integrations.vault.Secrets;
import io.helidon.integrations.vault.VaultOptionalResponse;
import io.helidon.integrations.vault.secrets.database.DbConfigure;
import io.helidon.integrations.vault.secrets.database.DbCreateRole;
import io.helidon.integrations.vault.secrets.database.DbCredentials;
import io.helidon.integrations.vault.secrets.database.DbDelete;
import io.helidon.integrations.vault.secrets.database.DbDeleteRole;
import io.helidon.integrations.vault.secrets.database.DbGet;
import java.util.Optional;
import java.util.function.Function;

public interface DbSecrets
extends Secrets {
    public static final Engine<DbSecrets> ENGINE = Engine.create(DbSecrets.class, (String)"database", (String)"database");

    public VaultOptionalResponse<ListSecrets.Response> list(ListSecrets.Request var1);

    default public Optional<DbCredentials> get(String name) {
        return this.get(DbGet.Request.builder().name(name)).entity().map(Function.identity());
    }

    public VaultOptionalResponse<DbGet.Response> get(DbGet.Request var1);

    public DbCreateRole.Response createRole(DbCreateRole.Request var1);

    public DbConfigure.Response configure(DbConfigure.Request<?> var1);

    default public DbDelete.Response delete(String name) {
        return this.delete(DbDelete.Request.builder().name(name));
    }

    public DbDelete.Response delete(DbDelete.Request var1);

    default public DbDeleteRole.Response deleteRole(String name) {
        return this.deleteRole(DbDeleteRole.Request.builder().name(name));
    }

    public DbDeleteRole.Response deleteRole(DbDeleteRole.Request var1);
}

