/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.vault.VaultApiException;
import io.helidon.integrations.vault.VaultRequest;
import java.time.Duration;

public final class DbCreateRole {
    private DbCreateRole() {
    }

    public static final class Response
    extends ApiResponse {
        private Response(Builder builder) {
            super((ApiResponse.Builder)builder);
        }

        static Builder builder() {
            return new Builder();
        }

        static final class Builder
        extends ApiResponse.Builder<Builder, Response> {
            private Builder() {
            }

            public Response build() {
                return new Response(this);
            }
        }
    }

    public static final class Request
    extends VaultRequest<Request> {
        private String name;

        private Request() {
        }

        public static Request builder() {
            return new Request();
        }

        public Request defaultTtl(Duration defaultTtl) {
            return (Request)this.add("default_ttl", defaultTtl);
        }

        public Request maxTtl(Duration maxTtl) {
            return (Request)this.add("max_ttl", maxTtl);
        }

        public Request addCreationStatement(String statement) {
            return (Request)this.addToArray("creation_statements", statement);
        }

        public Request addRevocationStatement(String statement) {
            return (Request)this.addToArray("revocation_statements", statement);
        }

        public Request addRollbackStatement(String statement) {
            return (Request)this.addToArray("rollback_statements", statement);
        }

        public Request addRenewStatement(String statement) {
            return (Request)this.addToArray("renew_statements", statement);
        }

        public Request dbName(String dbName) {
            return (Request)this.add("db_name", dbName);
        }

        public Request name(String name) {
            this.name = name;
            return this;
        }

        String name() {
            if (this.name == null) {
                throw new VaultApiException("DbCreateRole.Request name must be defined");
            }
            return this.name;
        }
    }
}

