/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.integrations.common.rest.ApiResponse;
import io.helidon.integrations.vault.VaultApiException;
import io.helidon.integrations.vault.VaultRequest;

public final class DbConfigure {
    private DbConfigure() {
    }

    public static final class Response
    extends ApiResponse {
        private Response(Builder builder) {
            super((ApiResponse.Builder)builder);
        }

        static Builder builder() {
            return new Builder();
        }

        static final class Builder
        extends ApiResponse.Builder<Builder, Response> {
            private Builder() {
            }

            public Response build() {
                return new Response(this);
            }
        }
    }

    public static abstract class Request<T extends Request<T>>
    extends VaultRequest<T> {
        private String name;

        protected Request(String pluginName) {
            this.add("plugin_name", pluginName);
        }

        public T username(String username) {
            return (T)((Object)((Request)this.add("username", username)));
        }

        public T password(String password) {
            return (T)((Object)((Request)this.add("password", password)));
        }

        public T verifyConnection(boolean verify) {
            return (T)((Object)((Request)this.add("verify_connection", verify)));
        }

        public T addAllowedRole(String role) {
            return (T)((Object)((Request)this.addToArray("allowed_roles", role)));
        }

        public T addRootRotationStatement(String statement) {
            return (T)((Object)((Request)this.addToArray("root_rotation_statements", statement)));
        }

        public T passwordPolicy(String policy) {
            return (T)((Object)((Request)this.add("password_policy", policy)));
        }

        public T name(String name) {
            this.name = name;
            return (T)((Object)((Request)this.me()));
        }

        String name() {
            if (this.name == null) {
                throw new VaultApiException("DbGet.Request name must be defined");
            }
            return this.name;
        }
    }
}

