/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.vault.secrets.database;

import io.helidon.integrations.vault.secrets.database.DbConfigure;
import java.time.Duration;

public class MySqlConfigureRequest
extends DbConfigure.Request<MySqlConfigureRequest> {
    protected MySqlConfigureRequest(String connectionUrl) {
        super("mysql-database-plugin");
        this.add("connection_url", connectionUrl);
    }

    public static MySqlConfigureRequest builder(String connectionUrl) {
        return new MySqlConfigureRequest(connectionUrl);
    }

    public MySqlConfigureRequest maxOpenConnections(int connections) {
        return (MySqlConfigureRequest)this.add("max_open_connections", connections);
    }

    public MySqlConfigureRequest maxIdleConnections(int connections) {
        return (MySqlConfigureRequest)this.add("max_idle_connections", connections);
    }

    public MySqlConfigureRequest maxConnectionLifetime(Duration duration) {
        return (MySqlConfigureRequest)this.add("max_connection_lifetime", duration);
    }

    public MySqlConfigureRequest tlsCertificateKey(String certificateWithKey) {
        return (MySqlConfigureRequest)this.add("tls_certificate_key", certificateWithKey);
    }

    public MySqlConfigureRequest tlsCa(String tlsCa) {
        return (MySqlConfigureRequest)this.add("tls_ca", tlsCa);
    }
}

