/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.openapi.ui;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.LazyValue;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderNames;
import io.helidon.http.HttpMediaType;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.Status;
import io.helidon.integrations.openapi.ui.OpenApiUiConfig;
import io.helidon.openapi.OpenApiService;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.StaticContentService;
import io.smallrye.openapi.ui.IndexHtmlCreator;
import io.smallrye.openapi.ui.Option;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

@RuntimeType.PrototypedBy(value=OpenApiUiConfig.class)
public final class OpenApiUi
implements OpenApiService,
RuntimeType.Api<OpenApiUiConfig> {
    private static final String LOGO_RESOURCE = "logo.svg";
    private static final String HELIDON_IO_LINK = "https://helidon.io";
    private static final MediaType[] ACCEPTED_MEDIA_TYPES = new MediaType[]{MediaTypes.APPLICATION_JSON, MediaTypes.TEXT_YAML, MediaTypes.TEXT_PLAIN, MediaTypes.TEXT_HTML};
    private static final HttpMediaType TEXT_HTML = HttpMediaType.create((MediaType)MediaTypes.TEXT_HTML);
    private static final Map<Option, String> HELIDON_OPTIONS = Map.of(Option.title, "Helidon OpenAPI UI", Option.logoHref, "logo.svg", Option.oauth2RedirectUrl, "-", Option.backHref, "https://helidon.io", Option.selfHref, "https://helidon.io");
    private final LazyValue<byte[]> indexHtml = LazyValue.create(this::createIndexHtml);
    private final OpenApiUiConfig config;
    private volatile String docPath = "/openapi";
    private volatile String uiPath = "/openapi/ui";

    public static OpenApiUiConfig.Builder builder() {
        return OpenApiUiConfig.builder();
    }

    public static OpenApiUi create() {
        return OpenApiUi.builder().build();
    }

    static OpenApiUi create(OpenApiUiConfig config) {
        return new OpenApiUi(config);
    }

    public static OpenApiUi create(Consumer<OpenApiUiConfig.Builder> builderConsumer) {
        OpenApiUiConfig.Builder b = OpenApiUiConfig.builder();
        builderConsumer.accept(b);
        return b.build();
    }

    OpenApiUi(OpenApiUiConfig config) {
        this.config = config;
    }

    public OpenApiUiConfig prototype() {
        return this.config;
    }

    public String name() {
        return "openapi-ui";
    }

    public String type() {
        return "openapi-ui";
    }

    public boolean supports(ServerRequestHeaders headers) {
        return headers.bestAccepted(ACCEPTED_MEDIA_TYPES).map(arg_0 -> ((HttpMediaType)TEXT_HTML).test(arg_0)).orElse(false);
    }

    public void setup(HttpRules rules, String docPath, Function<MediaType, String> content) {
        if (!this.config.isEnabled()) {
            return;
        }
        this.docPath = docPath;
        this.uiPath = this.config.webContext().orElseGet(() -> docPath + "/ui");
        rules.get(docPath + "[/]", new Handler[]{(req, res) -> this.handle(req, res, content)}).get(this.uiPath + "[/]", new Handler[]{this::redirectIndex}).get(this.uiPath + "/index.html", new Handler[]{this::index}).register(this.uiPath, new HttpService[]{StaticContentService.create((String)"helidon-openapi-ui")}).register(this.uiPath, new HttpService[]{StaticContentService.create((String)"META-INF/resources/openapi-ui")});
    }

    private void index(ServerRequest req, ServerResponse res) {
        req.headers().bestAccepted(ACCEPTED_MEDIA_TYPES).filter(arg_0 -> ((HttpMediaType)TEXT_HTML).test(arg_0)).ifPresentOrElse(ct -> {
            res.headers().contentType(ct);
            res.send((byte[])this.indexHtml.get());
        }, () -> ((ServerResponse)res).next());
    }

    private void redirectIndex(ServerRequest req, ServerResponse res) {
        res.status(Status.TEMPORARY_REDIRECT_307);
        res.header(HeaderNames.LOCATION, new String[]{this.uiPath + "/index.html"});
        res.send();
    }

    private void handle(ServerRequest req, ServerResponse res, Function<MediaType, String> content) {
        req.headers().bestAccepted(ACCEPTED_MEDIA_TYPES).ifPresentOrElse(ct -> {
            if (TEXT_HTML.test(ct)) {
                this.redirectIndex(req, res);
            } else {
                res.headers().contentType(ct);
                res.send(content.apply((MediaType)ct));
            }
        }, () -> ((ServerResponse)res).next());
    }

    private byte[] createIndexHtml() {
        HashMap<Option, String> options = new HashMap<Option, String>(HELIDON_OPTIONS);
        options.put(Option.url, this.docPath);
        this.config.options().forEach((k, v) -> options.put(Option.valueOf((String)k), (String)v));
        try {
            return IndexHtmlCreator.createIndexHtml(options);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to initialize the index.html content for the OpenAPI UI", e);
        }
    }
}

