/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.oci.sdk.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenOptions;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.Weight;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.integrations.oci.sdk.codegen.OciInjectCodegenObserverProvider;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.spi.InjectCodegenObserver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

class OciInjectionCodegenObserver
implements InjectCodegenObserver {
    static final String OCI_ROOT_PACKAGE_NAME_PREFIX = "com.oracle.bmc.";
    static final String GENERATED_PREFIX = "io.helidon.integrations.generated.";
    static final String GENERATED_CLIENT_SUFFIX = "__Oci_Client";
    static final String GENERATED_CLIENT_BUILDER_SUFFIX = "__Oci_ClientBuilder";
    private static final double DEFAULT_INJECT_WEIGHT = 99.0;
    private static final TypeName PROCESSOR_TYPE = TypeName.create(OciInjectionCodegenObserver.class);
    private static final String TYPENAME_EXCEPTIONS_FILENAME = "codegen-exclusions.txt";
    private static final String NO_DOT_EXCEPTIONS_FILENAME = "builder-name-exceptions.txt";
    private static final Set<TypeName> FACTORIES = Set.of(TypeNames.SUPPLIER, ServiceCodegenTypes.SERVICE_SERVICES_FACTORY, ServiceCodegenTypes.SERVICE_INJECTION_POINT_FACTORY, ServiceCodegenTypes.SERVICE_QUALIFIED_FACTORY);
    private final Set<String> typenameExceptions;
    private final Set<String> noDotExceptions;
    private final RegistryCodegenContext ctx;

    OciInjectionCodegenObserver(RegistryCodegenContext ctx) {
        this.ctx = ctx;
        CodegenOptions options = ctx.options();
        HashSet<String> typenameExceptions = new HashSet<String>();
        typenameExceptions.addAll((Collection)OciInjectCodegenObserverProvider.OPTION_TYPENAME_EXCEPTIONS.value(options));
        typenameExceptions.addAll(OciInjectionCodegenObserver.loadMetaConfig(TYPENAME_EXCEPTIONS_FILENAME));
        this.typenameExceptions = typenameExceptions;
        HashSet<String> noDotExceptions = new HashSet<String>();
        noDotExceptions.addAll((Collection)OciInjectCodegenObserverProvider.OPTION_NO_DOT_EXCEPTIONS.value(options));
        noDotExceptions.addAll(OciInjectionCodegenObserver.loadMetaConfig(NO_DOT_EXCEPTIONS_FILENAME));
        this.noDotExceptions = noDotExceptions;
    }

    static TypeName toGeneratedServiceClientTypeName(TypeName typeName) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(GENERATED_PREFIX + typeName.packageName())).className(typeName.className() + GENERATED_CLIENT_SUFFIX)).build();
    }

    static TypeName toGeneratedServiceClientBuilderTypeName(TypeName typeName) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(GENERATED_PREFIX + typeName.packageName())).className(typeName.className() + GENERATED_CLIENT_BUILDER_SUFFIX)).build();
    }

    public void onProcessingEvent(RegistryRoundContext roundContext, Set<TypedElementInfo> elements) {
        elements.stream().filter(this::shouldProcess).forEach(it -> this.process(roundContext, (TypedElementInfo)it));
    }

    Set<String> typenameExceptions() {
        return this.typenameExceptions;
    }

    Set<String> noDotExceptions() {
        return this.noDotExceptions;
    }

    ClassModel.Builder toBuilderBody(TypeName ociServiceTypeName, TypeName generatedOciService, TypeName generatedOciServiceBuilderTypeName) {
        boolean usesRegion = this.usesRegion(ociServiceTypeName);
        String maybeDot = this.maybeDot(ociServiceTypeName);
        String builderSuffix = "Client" + maybeDot + "Builder";
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE).copyright(CodegenUtil.copyright((TypeName)PROCESSOR_TYPE, (TypeName)ociServiceTypeName, (TypeName)generatedOciService)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)PROCESSOR_TYPE, (TypeName)ociServiceTypeName, (TypeName)generatedOciService, (String)"1", (String)""))).type(generatedOciServiceBuilderTypeName).addInterface(OciInjectionCodegenObserver.ipProvider(ociServiceTypeName, builderSuffix))).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON))).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(TypeName.create(Weight.class))).putValue("value", (Object)99.0)).build());
        if (usesRegion) {
            TypeName regionProviderType = OciInjectionCodegenObserver.ipProvider(TypeName.create((String)"com.oracle.bmc.Region"), "");
            classModel.addField(regionProvider -> ((Field.Builder)regionProvider.isFinal(true).accessModifier(AccessModifier.PRIVATE).name("regionProvider")).type(regionProviderType));
            classModel.addConstructor(ctor -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctor.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).addAnnotation(Annotation.create(Deprecated.class))).addParameter(regionProvider -> ((Parameter.Builder)regionProvider.name("regionProvider")).type(regionProviderType))).addContentLine("this.regionProvider = regionProvider;"));
        } else {
            classModel.addConstructor(ctor -> ((Constructor.Builder)((Constructor.Builder)ctor.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).addAnnotation(Annotation.create(Deprecated.class)));
        }
        String clientType = "@" + ociServiceTypeName.fqName() + "Client@";
        classModel.addMethod(first -> ((Method.Builder)((Method.Builder)((Method.Builder)first.name("first")).addAnnotation(Annotation.create(Override.class))).returnType(OciInjectionCodegenObserver.optionalQualifiedInstance(ociServiceTypeName, builderSuffix)).addParameter(query -> ((Parameter.Builder)query.name("query")).type(ServiceCodegenTypes.SERVICE_LOOKUP))).update(it -> {
            if (usesRegion) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.addContentLine("var builder = " + clientType + ".builder();")).addContent("regionProvider.first(query).map(")).addContent(ServiceCodegenTypes.SERVICE_QUALIFIED_INSTANCE)).addContentLine("::get).ifPresent(builder::region);")).addContent("return ")).addContent(Optional.class)).addContent(".of(")).addContent(ServiceCodegenTypes.SERVICE_QUALIFIED_INSTANCE)).addContent(".create(")).addContentLine("builder));");
            } else {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)it.addContent("return ")).addContent(Optional.class)).addContent(".of(")).addContent(ServiceCodegenTypes.SERVICE_QUALIFIED_INSTANCE)).addContent(".create(")).addContent(clientType)).addContent(".builder());");
            }
        }));
        return classModel;
    }

    ClassModel.Builder toBody(TypeName ociServiceTypeName, TypeName generatedOciService) {
        ClassModel.Builder classModel = (ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)((ClassModel.Builder)ClassModel.builder().accessModifier(AccessModifier.PACKAGE_PRIVATE).copyright(CodegenUtil.copyright((TypeName)PROCESSOR_TYPE, (TypeName)ociServiceTypeName, (TypeName)generatedOciService)).addAnnotation(CodegenUtil.generatedAnnotation((TypeName)PROCESSOR_TYPE, (TypeName)ociServiceTypeName, (TypeName)generatedOciService, (String)"1", (String)""))).type(generatedOciService).addInterface(OciInjectionCodegenObserver.ipProvider(ociServiceTypeName, "Client"))).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_SINGLETON))).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(TypeName.create(Weight.class))).putValue("value", (Object)99.0)).build())).addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(ServiceCodegenTypes.SERVICE_ANNOTATION_EXTERNAL_CONTRACTS)).putValue("value", (Object)ociServiceTypeName)).build());
        TypeName authProviderType = OciInjectionCodegenObserver.ipProvider(TypeName.create((String)"com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider"), "");
        TypeName builderProviderType = OciInjectionCodegenObserver.ipProvider(ociServiceTypeName, "Client" + this.maybeDot(ociServiceTypeName) + "Builder");
        classModel.addField(authProvider -> ((Field.Builder)authProvider.isFinal(true).accessModifier(AccessModifier.PRIVATE).name("authProvider")).type(authProviderType));
        classModel.addField(builderProvider -> ((Field.Builder)builderProvider.isFinal(true).accessModifier(AccessModifier.PRIVATE).name("builderProvider")).type(builderProviderType));
        classModel.addConstructor(ctor -> ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)ctor.accessModifier(AccessModifier.PACKAGE_PRIVATE)).addAnnotation(Annotation.create((TypeName)ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT))).addAnnotation(Annotations.DEPRECATED)).addParameter(authProvider -> ((Parameter.Builder)authProvider.name("authProvider")).type(authProviderType))).addParameter(builderProvider -> ((Parameter.Builder)builderProvider.name("builderProvider")).type(builderProviderType))).addContentLine("this.authProvider = authProvider;")).addContentLine("this.builderProvider = builderProvider;"));
        classModel.addMethod(first -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)first.name("first")).addAnnotation(Annotation.create(Override.class))).returnType(OciInjectionCodegenObserver.optionalQualifiedInstance(ociServiceTypeName, "Client")).addParameter(query -> ((Parameter.Builder)query.name("query")).type(ServiceCodegenTypes.SERVICE_LOOKUP))).addContent("return ")).addContent(Optional.class)).addContent(".of(")).addContent(ServiceCodegenTypes.SERVICE_QUALIFIED_INSTANCE)).addContent(".create(")).addContentLine("builderProvider.first(query).orElseThrow().get().build(authProvider.first(query).orElseThrow().get())));"));
        return classModel;
    }

    boolean usesRegion(TypeName ociServiceTypeName) {
        return !this.noDotExceptions.contains(ociServiceTypeName.name());
    }

    String maybeDot(TypeName ociServiceTypeName) {
        return this.noDotExceptions.contains(ociServiceTypeName.name()) ? "" : ".";
    }

    boolean shouldProcess(TypeName typeName) {
        String name;
        if (!typeName.typeArguments().isEmpty() && this.isFactory(typeName) || typeName.isOptional()) {
            typeName = (TypeName)typeName.typeArguments().getFirst();
        }
        if (!(name = typeName.resolvedName()).startsWith(OCI_ROOT_PACKAGE_NAME_PREFIX) || name.endsWith(".Builder") || name.endsWith("Client") || name.endsWith("ClientBuilder") || this.typenameExceptions.contains(name)) {
            return false;
        }
        TypeName generatedTypeName = OciInjectionCodegenObserver.toGeneratedServiceClientTypeName(typeName);
        return this.ctx.typeInfo(generatedTypeName).isEmpty();
    }

    private boolean isFactory(TypeName typeName) {
        return FACTORIES.contains(typeName);
    }

    private static Set<String> loadMetaConfig(String fileName) {
        String path = "META-INF/helidon/oci/sdk/codegen/" + fileName;
        HashSet<String> result = new HashSet<String>();
        try {
            Enumeration<URL> resources = OciInjectionCodegenObserver.class.getClassLoader().getResources(path);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                    reader.lines().map(String::trim).filter(Predicate.not(String::isEmpty)).filter(Predicate.not(s -> s.startsWith("#"))).forEach(result::add);
                }
            }
        }
        catch (IOException e) {
            throw new CodegenException("Failed to load " + path + " from classpath", (Throwable)e);
        }
        return result;
    }

    private static TypeName optionalQualifiedInstance(TypeName typeName, String suffix) {
        return ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.SERVICE_QUALIFIED_INSTANCE).addTypeArgument(TypeName.create((String)(typeName.fqName() + suffix)))).build())).build();
    }

    private static TypeName ipProvider(TypeName provided, String suffix) {
        return ((TypeName.Builder)TypeName.builder((TypeName)ServiceCodegenTypes.SERVICE_INJECTION_POINT_FACTORY).addTypeArgument(TypeName.create((String)(provided.fqName() + suffix)))).build();
    }

    private boolean shouldProcess(TypedElementInfo element) {
        if (!element.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_INJECT)) {
            return false;
        }
        return switch (element.kind()) {
            case ElementKind.FIELD -> this.shouldProcess(element.typeName());
            case ElementKind.METHOD, ElementKind.CONSTRUCTOR -> element.parameterArguments().stream().anyMatch(it -> this.shouldProcess(it.typeName()));
            default -> false;
        };
    }

    private void process(RegistryRoundContext roundCtx, TypedElementInfo element) {
        switch (element.kind()) {
            case FIELD: {
                this.process(roundCtx, element.typeName());
                break;
            }
            case METHOD: 
            case CONSTRUCTOR: {
                element.parameterArguments().stream().filter(it -> this.shouldProcess(it.typeName())).forEach(it -> this.process(roundCtx, it.typeName()));
                break;
            }
        }
    }

    private void process(RegistryRoundContext roundCtx, TypeName ociServiceTypeName) {
        TypeName generatedOciServiceClientBuilderTypeName;
        if (this.isFactory(ociServiceTypeName) || ociServiceTypeName.isOptional()) {
            ociServiceTypeName = (TypeName)ociServiceTypeName.typeArguments().getFirst();
        }
        assert (!ociServiceTypeName.generic()) : ociServiceTypeName.name();
        assert (ociServiceTypeName.name().startsWith(OCI_ROOT_PACKAGE_NAME_PREFIX)) : ociServiceTypeName.name();
        TypeName generatedOciServiceClientTypeName = OciInjectionCodegenObserver.toGeneratedServiceClientTypeName(ociServiceTypeName);
        if (roundCtx.generatedType(generatedOciServiceClientTypeName).isEmpty()) {
            ClassModel.Builder serviceClient = this.toBody(ociServiceTypeName, generatedOciServiceClientTypeName);
            roundCtx.addGeneratedType(generatedOciServiceClientTypeName, serviceClient, ociServiceTypeName, new Object[0]);
        }
        if (roundCtx.generatedType(generatedOciServiceClientBuilderTypeName = OciInjectionCodegenObserver.toGeneratedServiceClientBuilderTypeName(ociServiceTypeName)).isEmpty()) {
            ClassModel.Builder serviceClientBuilder = this.toBuilderBody(ociServiceTypeName, generatedOciServiceClientTypeName, generatedOciServiceClientBuilderTypeName);
            roundCtx.addGeneratedType(generatedOciServiceClientBuilderTypeName, serviceClientBuilder, ociServiceTypeName, new Object[0]);
        }
    }
}

