/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.microstream.metrics;

import io.helidon.common.config.Config;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.Tag;
import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import one.microstream.storage.types.StorageRawFileStatistics;
import one.microstream.storage.types.StorageRawFileStatisticsItem;

@Deprecated(forRemoval=true, since="4.2.1")
public class MicrostreamMetricsSupport {
    private static final String CONFIG_METRIC_ENABLED_VENDOR = "vendor.";
    private static final GaugeInfo<StorageRawFileStatistics> GLOBAL_FILE_COUNT = new GaugeInfo<StorageRawFileStatistics>("microstream.globalFileCount", "Displays the number of storage files.", null, StorageRawFileStatisticsItem::fileCount, new Tag[0]);
    private static final GaugeInfo<StorageRawFileStatistics> LIVE_DATA_LENGTH = new GaugeInfo<StorageRawFileStatistics>("microstream.liveDataLength", "Displays live data length. This is the 'real' size of the stored data.", "bytes", StorageRawFileStatisticsItem::liveDataLength, new Tag[0]);
    private static final GaugeInfo<StorageRawFileStatistics> TOTAL_DATA_LENGTH = new GaugeInfo<StorageRawFileStatistics>("microstream.totalDataLength", "Displays total data length. This is the accumulated size of all storage data files.", "bytes", StorageRawFileStatisticsItem::totalDataLength, new Tag[0]);
    private final Config config;
    private final EmbeddedStorageManager embeddedStorageManager;
    private final MeterRegistry vendorRegistry;

    private MicrostreamMetricsSupport(Builder builder) {
        this.config = builder.config();
        this.embeddedStorageManager = builder.embeddedStorageManager();
        MetricsFactory metricsFactory = builder.metricsFactory() == null ? MetricsFactory.getInstance((Config)this.config.get("metrics")) : builder.metricsFactory();
        this.vendorRegistry = metricsFactory.globalRegistry();
    }

    public static Builder builder(EmbeddedStorageManager embeddedStorageManager) {
        return new Builder(embeddedStorageManager);
    }

    private void register(GaugeInfo<StorageRawFileStatistics> gaugeInfo, StorageRawFileStatistics stats) {
        if (((Boolean)this.config.get(CONFIG_METRIC_ENABLED_VENDOR + gaugeInfo.name + ".enabled").asBoolean().orElse((Object)true)).booleanValue()) {
            this.vendorRegistry.getOrCreate(gaugeInfo.builder(stats));
        }
    }

    public void registerMetrics() {
        StorageRawFileStatistics stats = this.embeddedStorageManager.createStorageStatistics();
        this.register(GLOBAL_FILE_COUNT, stats);
        this.register(LIVE_DATA_LENGTH, stats);
        this.register(TOTAL_DATA_LENGTH, stats);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, MicrostreamMetricsSupport> {
        private final EmbeddedStorageManager embeddedStorageManager;
        private Config config = Config.empty();
        private MetricsFactory metricsFactory;

        private Builder(EmbeddedStorageManager embeddedStorageManager) {
            Objects.requireNonNull(embeddedStorageManager);
            this.embeddedStorageManager = embeddedStorageManager;
        }

        public MicrostreamMetricsSupport build() {
            return new MicrostreamMetricsSupport(this);
        }

        public MetricsFactory metricsFactory() {
            return this.metricsFactory;
        }

        public EmbeddedStorageManager embeddedStorageManager() {
            return this.embeddedStorageManager;
        }

        public Config config() {
            return this.config;
        }

        public Builder metricsFactory(MetricsFactory metricsFactory) {
            this.metricsFactory = metricsFactory;
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            return this;
        }
    }

    private record GaugeInfo<T>(String name, String description, String unit, ToDoubleFunction<T> fn, Tag[] tags) {
        Gauge.Builder<Double> builder(T stateObject) {
            Gauge.Builder builder = (Gauge.Builder)Gauge.builder((String)this.name, stateObject, this.fn).description(this.description);
            if (this.unit != null) {
                builder.baseUnit(this.unit);
            }
            if (this.tags != null) {
                builder.tags(List.of(this.tags));
            }
            return builder;
        }
    }
}

