/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.microstream.metrics;

import io.helidon.config.Config;
import io.helidon.metrics.api.RegistryFactory;
import java.util.Objects;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class MicrostreamMetricsSupport {
    private static final String CONFIG_METRIC_ENABLED_VENDOR = "vendor.";
    static final String BASE_ENABLED_KEY = "vendor.enabled";
    private static final Metadata GLOBAL_FILE_COUNT = Metadata.builder().withName("microstream.globalFileCount").withDisplayName("total storage file count").withDescription("Displays the number of storage files.").withType(MetricType.GAUGE).withUnit("none").build();
    private static final Metadata LIVE_DATA_LENGTH = Metadata.builder().withName("microstream.liveDataLength").withDisplayName("live data length").withDescription("Displays live data length. This is the 'real' size of the stored data.").withType(MetricType.GAUGE).withUnit("bytes").build();
    private static final Metadata TOTAL_DATA_LENGTH = Metadata.builder().withName("microstream.totalDataLength").withDisplayName("total data length").withDescription("Displays total data length. This is the accumulated size of all storage data files.").withType(MetricType.GAUGE).withUnit("bytes").build();
    private final Config config;
    private final EmbeddedStorageManager embeddedStorageManager;
    private final RegistryFactory registryFactory;
    private final MetricRegistry vendorRegistry;

    private MicrostreamMetricsSupport(Builder builder) {
        this.config = builder.config();
        this.embeddedStorageManager = builder.embeddedStorageManager();
        this.registryFactory = builder.registryFactory() == null ? RegistryFactory.getInstance((Config)this.config) : builder.registryFactory();
        this.vendorRegistry = this.registryFactory.getRegistry(MetricRegistry.Type.VENDOR);
    }

    public static Builder builder(EmbeddedStorageManager embeddedStorageManager) {
        return new Builder(embeddedStorageManager);
    }

    private void register(Metadata meta, Metric metric, Tag ... tags) {
        if (((Boolean)this.config.get(CONFIG_METRIC_ENABLED_VENDOR + meta.getName() + ".enabled").asBoolean().orElse((Object)true)).booleanValue()) {
            this.vendorRegistry.register(meta, metric, tags);
        }
    }

    public void registerMetrics() {
        this.register(GLOBAL_FILE_COUNT, (Metric)((Gauge)() -> this.embeddedStorageManager.createStorageStatistics().fileCount()), new Tag[0]);
        this.register(LIVE_DATA_LENGTH, (Metric)((Gauge)() -> this.embeddedStorageManager.createStorageStatistics().liveDataLength()), new Tag[0]);
        this.register(TOTAL_DATA_LENGTH, (Metric)((Gauge)() -> this.embeddedStorageManager.createStorageStatistics().totalDataLength()), new Tag[0]);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, MicrostreamMetricsSupport> {
        private final EmbeddedStorageManager embeddedStorageManager;
        private Config config = Config.empty();
        private RegistryFactory registryFactory;

        private Builder(EmbeddedStorageManager embeddedStorageManager) {
            Objects.requireNonNull(embeddedStorageManager);
            this.embeddedStorageManager = embeddedStorageManager;
        }

        public MicrostreamMetricsSupport build() {
            return new MicrostreamMetricsSupport(this);
        }

        public RegistryFactory registryFactory() {
            return this.registryFactory;
        }

        public EmbeddedStorageManager embeddedStorageManager() {
            return this.embeddedStorageManager;
        }

        public Config config() {
            return this.config;
        }

        public Builder registryFactory(RegistryFactory registryFactory) {
            this.registryFactory = registryFactory;
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            return this;
        }
    }
}

