/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.microstream.cdi;

import io.helidon.common.GenericType;
import io.helidon.config.Config;
import io.helidon.integrations.microstream.cache.CacheBuilder;
import io.helidon.integrations.microstream.cdi.MicrostreamCache;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import one.microstream.cache.types.Cache;

@Deprecated(forRemoval=true, since="4.2.1")
public class CacheExtension
implements Extension {
    private final Set<Descriptor> cacheBeans = new HashSet<Descriptor>();
    private Config config;

    private void configure(@Observes @Priority(value=0) Config config) {
        this.config = config;
    }

    private <T extends javax.cache.Cache<?, ?>> void processInjectionPoint(@Observes ProcessInjectionPoint<?, T> event) {
        InjectionPoint injectionPoint;
        if (event != null && (injectionPoint = event.getInjectionPoint()) != null && injectionPoint.getAnnotated().isAnnotationPresent(MicrostreamCache.class)) {
            this.cacheBeans.add(new Descriptor(injectionPoint.getQualifiers(), (ParameterizedType)injectionPoint.getType()));
        }
    }

    private void addBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (event != null && beanManager != null && !this.cacheBeans.isEmpty()) {
            for (Descriptor entry : this.cacheBeans) {
                assert (entry != null);
                Set<Annotation> qualifiers = entry.getAnnotations();
                assert (qualifiers != null);
                assert (!qualifiers.isEmpty());
                ParameterizedType types = entry.getTypes();
                GenericType keyType = GenericType.create((Type)types.getActualTypeArguments()[0]);
                GenericType valueType = GenericType.create((Type)types.getActualTypeArguments()[1]);
                String name = this.getName(qualifiers);
                event.addBean().qualifiers(qualifiers).scope(ApplicationScoped.class).addTransitiveTypeClosure(Cache.class).addTypes(new Type[]{types}).createWith(cc -> CacheBuilder.create((String)name, (Config)this.getConfigNode(qualifiers), (Class)keyType.rawType(), (Class)valueType.rawType())).destroyWith((cache, context) -> cache.close());
            }
        }
    }

    private Config getConfigNode(Set<Annotation> qualifiers) {
        Optional<Annotation> optAnnotation = qualifiers.stream().filter(e -> e instanceof MicrostreamCache).findFirst();
        if (optAnnotation.isPresent()) {
            MicrostreamCache annotation = (MicrostreamCache)optAnnotation.get();
            String name = annotation.configNode();
            return this.config.get(name);
        }
        return null;
    }

    private String getName(Set<Annotation> qualifiers) {
        Optional<Annotation> optAnnotation = qualifiers.stream().filter(e -> e instanceof MicrostreamCache).findFirst();
        if (optAnnotation.isPresent()) {
            MicrostreamCache annotation = (MicrostreamCache)optAnnotation.get();
            return annotation.name();
        }
        return null;
    }

    private static class Descriptor {
        private final Set<Annotation> annotations;
        private final ParameterizedType types;

        private Descriptor(Set<Annotation> cacheBeans, ParameterizedType types) {
            this.annotations = cacheBeans;
            this.types = types;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public ParameterizedType getTypes() {
            return this.types;
        }

        public int hashCode() {
            return Objects.hash(this.annotations, this.types);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Descriptor other = (Descriptor)obj;
            return Objects.equals(this.annotations, other.annotations) && Objects.equals(this.types, other.types);
        }
    }
}

