/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.micrometer;

import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.Method;
import io.helidon.http.Status;
import io.helidon.integrations.micrometer.MicrometerPrometheusRegistrySupport;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.StringWriter;

class PrometheusHandler
implements Handler {
    private final PrometheusMeterRegistry registry;

    private PrometheusHandler(PrometheusMeterRegistry registry) {
        this.registry = registry;
    }

    static PrometheusHandler create(MeterRegistry registry) {
        return new PrometheusHandler((PrometheusMeterRegistry)PrometheusMeterRegistry.class.cast(registry));
    }

    public void handle(ServerRequest req, ServerResponse res) throws Exception {
        res.headers().contentType(MediaTypes.TEXT_PLAIN);
        Method method = req.prologue().method();
        if (method == Method.GET) {
            res.send((Object)this.registry.scrape());
        } else if (method == Method.OPTIONS) {
            StringWriter writer = new StringWriter();
            MicrometerPrometheusRegistrySupport.metadata(writer, this.registry);
            res.send((Object)writer.toString());
        } else {
            res.status(Status.NOT_IMPLEMENTED_501).send();
        }
    }
}

