/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.micrometer;

import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigValue;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.integrations.micrometer.MicrometerBuiltInRegistrySupport;
import io.helidon.integrations.micrometer.PrometheusHandler;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.ServerRequest;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.Collector;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Optional;
import java.util.function.Function;

class MicrometerPrometheusRegistrySupport
extends MicrometerBuiltInRegistrySupport {
    MicrometerPrometheusRegistrySupport(MeterRegistryConfig meterRegistryConfig) {
        super(meterRegistryConfig);
    }

    PrometheusMeterRegistry createRegistry(MeterRegistryConfig meterRegistryConfig) {
        return new PrometheusMeterRegistry((PrometheusConfig)PrometheusConfig.class.cast(meterRegistryConfig));
    }

    @Override
    public Function<ServerRequest, Optional<Handler>> requestToHandlerFn(MeterRegistry registry) {
        return req -> {
            if (req.headers().bestAccepted(new MediaType[]{MediaTypes.TEXT_PLAIN}).isPresent() || ((String)req.query().first("type").orElse((Object)"")).equals("prometheus")) {
                return Optional.of(PrometheusHandler.create(registry));
            }
            return Optional.empty();
        };
    }

    static void metadata(Writer writer, PrometheusMeterRegistry registry) throws IOException {
        Enumeration mfs = registry.getPrometheusRegistry().metricFamilySamples();
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = (Collector.MetricFamilySamples)mfs.nextElement();
            writer.write("# HELP ");
            writer.write(metricFamilySamples.name);
            writer.write(32);
            MicrometerPrometheusRegistrySupport.writeEscapedHelp(writer, metricFamilySamples.help);
            writer.write(10);
            writer.write("# TYPE ");
            writer.write(metricFamilySamples.name);
            writer.write(32);
            writer.write(MicrometerPrometheusRegistrySupport.typeString(metricFamilySamples.type));
            writer.write(10);
        }
    }

    private static void writeEscapedHelp(Writer writer, String s) throws IOException {
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block4;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block4;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    private static String typeString(Collector.Type t) {
        switch (t) {
            case GAUGE: {
                return "gauge";
            }
            case COUNTER: {
                return "counter";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "untyped";
    }

    static class PrometheusConfigImpl
    extends MicrometerBuiltInRegistrySupport.AbstractMeterRegistryConfig
    implements PrometheusConfig {
        static PrometheusConfig registryConfig(ConfigValue<Config> node) {
            return node.filter(Config::exists).map(PrometheusConfigImpl::registryConfig).orElse(PrometheusConfig.DEFAULT);
        }

        private static PrometheusConfig registryConfig(Config config) {
            return new PrometheusConfigImpl(config);
        }

        PrometheusConfigImpl(Config config) {
            super(config);
        }
    }
}

