/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.micrometer;

import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.integrations.micrometer.MeterRegistryFactory;
import io.helidon.integrations.micrometer.MicrometerPrometheusRegistrySupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.ServerRequest;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.prometheus.PrometheusConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

abstract class MicrometerBuiltInRegistrySupport {
    private final MeterRegistry registry;

    static MicrometerBuiltInRegistrySupport create(MeterRegistryFactory.BuiltInRegistryType type, ConfigValue<Config> node) {
        switch (type) {
            case PROMETHEUS: {
                return MicrometerBuiltInRegistrySupport.create(type, (MeterRegistryConfig)MicrometerPrometheusRegistrySupport.PrometheusConfigImpl.registryConfig(node));
            }
        }
        throw new IllegalArgumentException(MicrometerBuiltInRegistrySupport.unrecognizedMessage(type));
    }

    static MicrometerBuiltInRegistrySupport create(MeterRegistryFactory.BuiltInRegistryType type, MeterRegistryConfig meterRegistryConfig) {
        switch (type) {
            case PROMETHEUS: {
                return new MicrometerPrometheusRegistrySupport(meterRegistryConfig);
            }
        }
        throw new IllegalArgumentException(MicrometerBuiltInRegistrySupport.unrecognizedMessage(type));
    }

    static MicrometerBuiltInRegistrySupport create(MeterRegistryFactory.BuiltInRegistryType type) {
        return MicrometerBuiltInRegistrySupport.create(type, (MeterRegistryConfig)(switch (type) {
            case MeterRegistryFactory.BuiltInRegistryType.PROMETHEUS -> PrometheusConfig.DEFAULT;
            default -> throw new IllegalArgumentException(MicrometerBuiltInRegistrySupport.unrecognizedMessage(type));
        }));
    }

    MicrometerBuiltInRegistrySupport(MeterRegistryConfig meterRegistryConfig) {
        this.registry = this.createRegistry(meterRegistryConfig);
    }

    abstract MeterRegistry createRegistry(MeterRegistryConfig var1);

    abstract Function<ServerRequest, Optional<Handler>> requestToHandlerFn(MeterRegistry var1);

    MeterRegistry registry() {
        return this.registry;
    }

    private static String unrecognizedMessage(MeterRegistryFactory.BuiltInRegistryType type) {
        return String.format("Built-in registry type %s recognized but no support found", type.name());
    }

    static abstract class AbstractMeterRegistryConfig
    implements MeterRegistryConfig {
        private final Map<String, String> settings;

        AbstractMeterRegistryConfig(Config config) {
            this.settings = (Map)config.detach().asMap().orElse(Collections.emptyMap());
        }

        public String get(String key) {
            return this.settings.get(key);
        }
    }
}

