/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.micrometer;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.integrations.micrometer.MicrometerBuiltInRegistrySupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.prometheus.client.Collector;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Optional;
import java.util.function.Function;

class MicrometerPrometheusRegistrySupport
extends MicrometerBuiltInRegistrySupport {
    MicrometerPrometheusRegistrySupport(MeterRegistryConfig meterRegistryConfig) {
        super(meterRegistryConfig);
    }

    PrometheusMeterRegistry createRegistry(MeterRegistryConfig meterRegistryConfig) {
        return new PrometheusMeterRegistry((PrometheusConfig)PrometheusConfig.class.cast(meterRegistryConfig));
    }

    @Override
    public Function<ServerRequest, Optional<Handler>> requestToHandlerFn(MeterRegistry registry) {
        return req -> {
            if (req.headers().bestAccepted(new MediaType[]{MediaType.TEXT_PLAIN}).isPresent() || req.queryParams().first("type").orElse("").equals("prometheus")) {
                return Optional.of(PrometheusHandler.create(registry));
            }
            return Optional.empty();
        };
    }

    static void metadata(Writer writer, PrometheusMeterRegistry registry) throws IOException {
        Enumeration mfs = registry.getPrometheusRegistry().metricFamilySamples();
        while (mfs.hasMoreElements()) {
            Collector.MetricFamilySamples metricFamilySamples = (Collector.MetricFamilySamples)mfs.nextElement();
            writer.write("# HELP ");
            writer.write(metricFamilySamples.name);
            writer.write(32);
            MicrometerPrometheusRegistrySupport.writeEscapedHelp(writer, metricFamilySamples.help);
            writer.write(10);
            writer.write("# TYPE ");
            writer.write(metricFamilySamples.name);
            writer.write(32);
            writer.write(MicrometerPrometheusRegistrySupport.typeString(metricFamilySamples.type));
            writer.write(10);
        }
    }

    private static void writeEscapedHelp(Writer writer, String s) throws IOException {
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    writer.append("\\\\");
                    continue block4;
                }
                case '\n': {
                    writer.append("\\n");
                    continue block4;
                }
                default: {
                    writer.append(c);
                }
            }
        }
    }

    private static String typeString(Collector.Type t) {
        switch (t) {
            case GAUGE: {
                return "gauge";
            }
            case COUNTER: {
                return "counter";
            }
            case SUMMARY: {
                return "summary";
            }
            case HISTOGRAM: {
                return "histogram";
            }
        }
        return "untyped";
    }

    static class PrometheusHandler
    implements Handler {
        private final PrometheusMeterRegistry registry;

        private PrometheusHandler(PrometheusMeterRegistry registry) {
            this.registry = registry;
        }

        static PrometheusHandler create(MeterRegistry registry) {
            return new PrometheusHandler((PrometheusMeterRegistry)PrometheusMeterRegistry.class.cast(registry));
        }

        public void accept(ServerRequest req, ServerResponse res) {
            res.headers().contentType(MediaType.TEXT_PLAIN);
            switch (Http.Method.valueOf((String)req.method().name())) {
                case GET: {
                    res.send((Object)this.registry.scrape());
                    break;
                }
                case OPTIONS: {
                    StringWriter writer = new StringWriter();
                    try {
                        MicrometerPrometheusRegistrySupport.metadata(writer, this.registry);
                        res.send((Object)writer.toString());
                    }
                    catch (IOException e) {
                        res.status((Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500).send((Throwable)e);
                    }
                    break;
                }
                default: {
                    res.status((Http.ResponseStatus)Http.Status.NOT_IMPLEMENTED_501).send();
                }
            }
        }
    }

    static class PrometheusConfigImpl
    extends MicrometerBuiltInRegistrySupport.AbstractMeterRegistryConfig
    implements PrometheusConfig {
        static PrometheusConfig registryConfig(ConfigValue<Config> node) {
            return node.filter(Config::exists).map(PrometheusConfigImpl::registryConfig).orElse(PrometheusConfig.DEFAULT);
        }

        private static PrometheusConfig registryConfig(Config config) {
            return new PrometheusConfigImpl(config);
        }

        PrometheusConfigImpl(Config config) {
            super(config);
        }
    }
}

