/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.micrometer;

import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.integrations.micrometer.MicrometerBuiltInRegistrySupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterRegistryConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class MeterRegistryFactory {
    static final String BUILTIN_REGISTRIES_CONFIG_KEY = "builtin-registries";
    private static final String NO_MATCHING_REGISTRY_ERROR_MESSAGE = "No registered MeterRegistry matches the request";
    private static final Logger LOGGER = Logger.getLogger(MeterRegistryFactory.class.getName());
    private static MeterRegistryFactory instance = MeterRegistryFactory.create();
    private final CompositeMeterRegistry compositeMeterRegistry;
    private final List<Enrollment> registryEnrollments;
    private final Map<BuiltInRegistryType, MeterRegistry> builtInRegistryEnrollments = new HashMap<BuiltInRegistryType, MeterRegistry>();

    public static MeterRegistryFactory create() {
        return MeterRegistryFactory.create(Config.empty());
    }

    public static MeterRegistryFactory create(Config config) {
        return MeterRegistryFactory.builder().config(config).build();
    }

    public static MeterRegistryFactory getInstance() {
        return instance;
    }

    public static MeterRegistryFactory getInstance(Builder builder) {
        instance = builder.build();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private MeterRegistryFactory(Builder builder) {
        this.compositeMeterRegistry = new CompositeMeterRegistry();
        if (builder.explicitAndBuiltInEnrollments().isEmpty()) {
            builder.enrollBuiltInRegistry(BuiltInRegistryType.PROMETHEUS);
        }
        this.registryEnrollments = builder.explicitAndBuiltInEnrollments();
        builder.builtInRegistriesRequested.forEach((builtInRegistryType, builtInRegistrySupport) -> {
            MeterRegistry meterRegistry = builtInRegistrySupport.registry();
            this.builtInRegistryEnrollments.put((BuiltInRegistryType)((Object)builtInRegistryType), meterRegistry);
        });
        this.registryEnrollments.forEach(e -> this.compositeMeterRegistry.add(e.meterRegistry()));
    }

    public MeterRegistry meterRegistry() {
        return this.compositeMeterRegistry;
    }

    Handler matchingHandler(ServerRequest serverRequest, ServerResponse serverResponse) {
        return this.registryEnrollments.stream().map(e -> e.handlerFn().apply(serverRequest)).findFirst().filter(Optional::isPresent).map(Optional::get).orElse((req, res) -> res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406).send((Object)NO_MATCHING_REGISTRY_ERROR_MESSAGE));
    }

    Set<MeterRegistry> registries() {
        return this.compositeMeterRegistry.getRegistries();
    }

    Map<BuiltInRegistryType, MeterRegistry> enrolledBuiltInRegistries() {
        return this.builtInRegistryEnrollments;
    }

    private static class Enrollment {
        private final MeterRegistry meterRegistry;
        private final Function<ServerRequest, Optional<Handler>> handlerFn;

        private Enrollment(MeterRegistry meterRegistry, Function<ServerRequest, Optional<Handler>> handlerFn) {
            this.meterRegistry = meterRegistry;
            this.handlerFn = handlerFn;
        }

        private MeterRegistry meterRegistry() {
            return this.meterRegistry;
        }

        private Function<ServerRequest, Optional<Handler>> handlerFn() {
            return this.handlerFn;
        }
    }

    public static class Builder
    implements io.helidon.common.Builder<MeterRegistryFactory> {
        private final List<Enrollment> explicitRegistryEnrollments = new ArrayList<Enrollment>();
        private final Map<BuiltInRegistryType, MicrometerBuiltInRegistrySupport> builtInRegistriesRequested = new HashMap<BuiltInRegistryType, MicrometerBuiltInRegistrySupport>();
        private final List<LogRecord> logRecords = new ArrayList<LogRecord>();

        public MeterRegistryFactory build() {
            return new MeterRegistryFactory(this);
        }

        public Builder config(Config config) {
            config.get(MeterRegistryFactory.BUILTIN_REGISTRIES_CONFIG_KEY).ifExists(this::enrollBuiltInRegistries);
            return this;
        }

        public Builder enrollBuiltInRegistry(BuiltInRegistryType builtInRegistryType, MeterRegistryConfig meterRegistryConfig) {
            MicrometerBuiltInRegistrySupport builtInRegistrySupport = MicrometerBuiltInRegistrySupport.create(builtInRegistryType, meterRegistryConfig);
            this.builtInRegistriesRequested.put(builtInRegistryType, builtInRegistrySupport);
            return this;
        }

        public Builder enrollBuiltInRegistry(BuiltInRegistryType builtInRegistryType) {
            MicrometerBuiltInRegistrySupport builtInRegistrySupport = MicrometerBuiltInRegistrySupport.create(builtInRegistryType);
            this.builtInRegistriesRequested.put(builtInRegistryType, builtInRegistrySupport);
            return this;
        }

        public Builder enrollRegistry(MeterRegistry meterRegistry, Function<ServerRequest, Optional<Handler>> handlerFunction) {
            this.explicitRegistryEnrollments.add(new Enrollment(meterRegistry, handlerFunction));
            return this;
        }

        List<LogRecord> logRecords() {
            return this.logRecords;
        }

        private List<Enrollment> explicitAndBuiltInEnrollments() {
            ArrayList<Enrollment> result = new ArrayList<Enrollment>(this.explicitRegistryEnrollments);
            this.builtInRegistriesRequested.forEach((builtInRegistrySupportType, builtInRegistrySupport) -> {
                MeterRegistry meterRegistry = builtInRegistrySupport.registry();
                result.add(new Enrollment(meterRegistry, builtInRegistrySupport.requestToHandlerFn(meterRegistry)));
            });
            return result;
        }

        private void enrollBuiltInRegistries(Config registriesConfig) {
            HashMap candidateBuiltInRegistryTypes = new HashMap();
            ArrayList unrecognizedTypes = new ArrayList();
            registriesConfig.asList(Config.class).ifPresent(confList -> {
                for (Config registryConfig : confList) {
                    String registryType = (String)registryConfig.get("type").asString().get();
                    try {
                        BuiltInRegistryType type = BuiltInRegistryType.valueByName(registryType);
                        MicrometerBuiltInRegistrySupport builtInRegistrySupport = MicrometerBuiltInRegistrySupport.create(type, (ConfigValue<Config>)registryConfig.asNode());
                        candidateBuiltInRegistryTypes.put(type, builtInRegistrySupport);
                    }
                    catch (BuiltInRegistryType.UnrecognizedBuiltInRegistryTypeException e) {
                        unrecognizedTypes.add(e.unrecognizedType());
                        this.logRecords.add(new LogRecord(Level.WARNING, String.format("Ignoring unrecognized Micrometer built-in registry type %s", e.unrecognizedType())));
                    }
                }
            });
            if (!unrecognizedTypes.isEmpty()) {
                LOGGER.log(Level.WARNING, String.format("Ignoring unrecognized Micrometer built-in registries: %s", unrecognizedTypes));
            }
            if (!candidateBuiltInRegistryTypes.isEmpty()) {
                this.builtInRegistriesRequested.clear();
                this.builtInRegistriesRequested.putAll(candidateBuiltInRegistryTypes);
                LOGGER.log(Level.FINE, () -> "Selecting built-in Micrometer registries " + candidateBuiltInRegistryTypes);
            }
        }
    }

    public static enum BuiltInRegistryType {
        PROMETHEUS;


        static BuiltInRegistryType valueByName(String name) throws UnrecognizedBuiltInRegistryTypeException {
            try {
                return BuiltInRegistryType.valueOf(name.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new UnrecognizedBuiltInRegistryTypeException(name);
            }
        }

        public static class UnrecognizedBuiltInRegistryTypeException
        extends Exception {
            private static final long serialVersionUID = 9079876961827144352L;
            private final String unrecognizedType;

            public UnrecognizedBuiltInRegistryTypeException(String unrecognizedType) {
                this.unrecognizedType = unrecognizedType;
            }

            public String unrecognizedType() {
                return this.unrecognizedType;
            }

            @Override
            public String getMessage() {
                return "Unrecognized built-in Micrometer registry type: " + this.unrecognizedType;
            }
        }
    }
}

